/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.util.logging;

import java.io.IOException;
import java.io.StringWriter;
import java.text.FieldPosition;
import java.text.SimpleDateFormat;
import java.util.Arrays;
import java.util.Comparator;
import java.util.Date;
import java.util.Map;
import java.util.SortedMap;
import java.util.TimeZone;
import java.util.TreeMap;
import java.util.logging.ConsoleHandler;
import java.util.logging.Formatter;
import java.util.logging.Handler;
import java.util.logging.Level;
import java.util.logging.LogManager;
import java.util.logging.LogRecord;
import java.util.logging.Logger;
import java.util.logging.SimpleFormatter;
import org.geotoolkit.io.LineWriter;
import org.geotoolkit.io.X364;
import org.geotoolkit.util.Utilities;
import org.geotoolkit.util.logging.Logging;

public class MonolineFormatter
extends Formatter {
    private static final String MARGIN = "";
    private static final int NO_SOURCE = 0;
    private static final int NO_SOURCE_EX = 1;
    private static final int LOGGER_SHORT = 2;
    private static final int LOGGER_LONG = 3;
    private static final int CLASS_SHORT = 4;
    private static final int CLASS_LONG = 5;
    private static final String[] FORMAT_LABELS = new String[6];
    private static final Level LEVEL_THRESHOLD;
    private static final Comparator<Level> COMPARATOR;
    private SortedMap<Level, X364> colors;
    private transient int[] colorLevels;
    private transient String[] colorSequences;
    private final String lineSeparator;
    private String bodyLineSeparator;
    private int levelWidth;
    private final long startMillis;
    private SimpleDateFormat timeFormat;
    private int sourceFormat;
    private final StringBuffer buffer;
    private final LineWriter writer;

    public MonolineFormatter(Handler handler) {
        Object object;
        this.bodyLineSeparator = this.lineSeparator = System.getProperty("line.separator", "\n");
        this.timeFormat = null;
        this.sourceFormat = 0;
        this.startMillis = System.currentTimeMillis();
        Level level = handler != null ? handler.getLevel() : null;
        int n = 0;
        block13: while (true) {
            int n2;
            switch (n) {
                case 0: {
                    object = Level.FINEST;
                    break;
                }
                case 1: {
                    object = Level.FINER;
                    break;
                }
                case 2: {
                    object = Level.FINE;
                    break;
                }
                case 3: {
                    object = Level.CONFIG;
                    break;
                }
                case 4: {
                    object = Level.INFO;
                    break;
                }
                case 5: {
                    object = Level.WARNING;
                    break;
                }
                case 6: {
                    object = Level.SEVERE;
                    break;
                }
                default: {
                    break block13;
                }
            }
            if ((level == null || ((Level)object).intValue() >= level.intValue()) && (n2 = ((Level)object).getLocalizedName().length()) > this.levelWidth) {
                this.levelWidth = n2;
            }
            ++n;
        }
        StringWriter stringWriter = new StringWriter();
        this.writer = new LineWriter(stringWriter);
        this.buffer = stringWriter.getBuffer();
        this.buffer.append(MARGIN);
        object = LogManager.getLogManager();
        String string = MonolineFormatter.class.getName();
        try {
            this.setTimeFormat(((LogManager)object).getProperty(string + ".time"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(illegalArgumentException);
        }
        try {
            this.setSourceFormat(((LogManager)object).getProperty(string + ".source"));
        }
        catch (IllegalArgumentException illegalArgumentException) {
            System.err.println(illegalArgumentException);
        }
        if (handler instanceof ConsoleHandler && X364.isSupported()) {
            SortedMap<Level, X364> sortedMap = this.colors = new TreeMap<Level, X364>(COMPARATOR);
            sortedMap.put(Level.ALL, X364.BACKGROUND_GRAY);
            sortedMap.put(Level.CONFIG, X364.BACKGROUND_BLUE);
            sortedMap.put(Level.INFO, X364.BACKGROUND_GREEN);
            sortedMap.put(Level.WARNING, X364.BACKGROUND_YELLOW);
            sortedMap.put(Level.SEVERE, X364.BACKGROUND_RED);
        }
    }

    public synchronized String getTimeFormat() {
        return this.timeFormat != null ? this.timeFormat.toPattern() : null;
    }

    public synchronized void setTimeFormat(String string) {
        if (string == null) {
            this.timeFormat = null;
        } else if (this.timeFormat == null) {
            this.timeFormat = new SimpleDateFormat(string);
            this.timeFormat.setTimeZone(TimeZone.getTimeZone("UTC"));
        } else {
            this.timeFormat.applyPattern(string);
        }
    }

    public synchronized String getSourceFormat() {
        return FORMAT_LABELS[this.sourceFormat];
    }

    public synchronized void setSourceFormat(String string) {
        if (string != null) {
            string = string.trim().toLowerCase();
        }
        for (int i = 0; i < FORMAT_LABELS.length; ++i) {
            if (!Utilities.equals(FORMAT_LABELS[i], string)) continue;
            this.sourceFormat = i;
            return;
        }
        throw new IllegalArgumentException(string);
    }

    public synchronized X364 getLevelColor(Level level) {
        return this.colors != null ? (X364)((Object)this.colors.get(level)) : null;
    }

    public synchronized void setLevelColor(Level level, X364 x364) {
        boolean bl = false;
        if (x364 != null) {
            if (this.colors == null) {
                this.colors = new TreeMap<Level, X364>(COMPARATOR);
            }
            bl = !x364.equals((Object)this.colors.put(level, x364));
        } else if (this.colors != null) {
            boolean bl2 = bl = this.colors.remove(level) != null;
            if (this.colors.isEmpty()) {
                this.colors = null;
            }
        }
        if (bl) {
            this.colorLevels = null;
            this.colorSequences = null;
        }
    }

    public synchronized void clearLevelColors() {
        this.colors = null;
        this.colorLevels = null;
        this.colorSequences = null;
    }

    private String interpolateColor(Level level) {
        int n;
        if (this.colorSequences == null) {
            this.colorSequences = new String[this.colors.size()];
            this.colorLevels = new int[this.colorSequences.length];
            n = 0;
            for (Map.Entry<Level, X364> entry : this.colors.entrySet()) {
                this.colorSequences[n] = entry.getValue().background().sequence();
                this.colorLevels[n++] = entry.getKey().intValue();
            }
        }
        if ((n = Arrays.binarySearch(this.colorLevels, level.intValue())) < 0) {
            n = Math.max(~n - 1, 0);
        }
        return this.colorSequences[n];
    }

    @Override
    public synchronized String format(LogRecord logRecord) {
        String string;
        Level level = logRecord.getLevel();
        boolean bl = this.colors != null;
        boolean bl2 = level.intValue() >= LEVEL_THRESHOLD.intValue();
        StringBuffer stringBuffer = this.buffer;
        stringBuffer.setLength(MARGIN.length());
        if (this.timeFormat != null) {
            Date date = new Date(Math.max(0L, logRecord.getMillis() - this.startMillis));
            this.timeFormat.format(date, stringBuffer, new FieldPosition(0));
            stringBuffer.append(' ');
        }
        int n = stringBuffer.length();
        if (bl) {
            stringBuffer.append(this.interpolateColor(level));
        }
        int n2 = stringBuffer.length();
        stringBuffer.append(level.getLocalizedName());
        stringBuffer.append(Utilities.spaces(this.levelWidth - (stringBuffer.length() - n2)));
        n += stringBuffer.length() - n2;
        if (bl) {
            stringBuffer.append(X364.BACKGROUND_DEFAULT.sequence());
        }
        stringBuffer.append(' ');
        ++n;
        switch (this.sourceFormat) {
            case 2: 
            case 3: {
                string = logRecord.getLoggerName();
                break;
            }
            case 4: 
            case 5: {
                string = logRecord.getSourceClassName();
                break;
            }
            default: {
                string = null;
            }
        }
        if (string != null) {
            switch (this.sourceFormat) {
                case 2: 
                case 4: {
                    string = string.substring(string.lastIndexOf(46) + 1);
                }
            }
            string = string.replace('$', '.');
            if (bl && bl2) {
                stringBuffer.append(X364.BOLD.sequence());
            }
            stringBuffer.append('[').append(string).append(']');
            if (bl && bl2) {
                stringBuffer.append(X364.NORMAL.sequence());
            }
            stringBuffer.append(' ');
        }
        if (this.bodyLineSeparator.length() != this.lineSeparator.length() + n) {
            this.bodyLineSeparator = this.lineSeparator + Utilities.spaces(n);
        }
        if (bl && !bl2) {
            stringBuffer.append(X364.FAINT.sequence());
        }
        LineWriter lineWriter = this.writer;
        try {
            lineWriter.setLineSeparator(this.bodyLineSeparator);
            lineWriter.write(String.valueOf(this.formatMessage(logRecord)));
            lineWriter.setLineSeparator(this.lineSeparator);
            lineWriter.write(10);
            lineWriter.flush();
        }
        catch (IOException iOException) {
            throw new AssertionError((Object)iOException);
        }
        if (bl && !bl2) {
            stringBuffer.append(X364.NORMAL.sequence());
        }
        return stringBuffer.toString();
    }

    public static MonolineFormatter configureConsoleHandler(Logger logger, Level level) {
        Object object;
        MonolineFormatter monolineFormatter = null;
        boolean bl = false;
        Handler[] handlerArray = logger.getHandlers();
        for (int i = 0; i < handlerArray.length; ++i) {
            Handler handler = handlerArray[i];
            if (!handler.getClass().equals(ConsoleHandler.class)) continue;
            bl = true;
            object = handler.getFormatter();
            if (object instanceof MonolineFormatter) {
                if (monolineFormatter != null) continue;
                monolineFormatter = (MonolineFormatter)object;
                MonolineFormatter.setLevel(handler, level);
                continue;
            }
            if (!object.getClass().equals(SimpleFormatter.class)) continue;
            try {
                MonolineFormatter.setLevel(handler, level);
            }
            catch (SecurityException securityException) {
                MonolineFormatter.unexpectedException(securityException);
            }
            if (monolineFormatter == null) {
                monolineFormatter = new MonolineFormatter(handler);
            }
            try {
                handler.setFormatter(monolineFormatter);
                continue;
            }
            catch (SecurityException securityException) {
                MonolineFormatter.unexpectedException(securityException);
            }
        }
        Logger logger2 = logger;
        while (logger2.getUseParentHandlers() && (logger2 = logger2.getParent()) != null) {
            handlerArray = logger2.getHandlers();
            for (int i = 0; i < handlerArray.length; ++i) {
                object = handlerArray[i];
                if (object.getClass().equals(ConsoleHandler.class)) {
                    if (!bl) continue;
                    bl = true;
                    Formatter formatter = ((Handler)object).getFormatter();
                    if (formatter.getClass().equals(SimpleFormatter.class)) {
                        monolineFormatter = MonolineFormatter.addHandler(logger, level);
                        continue;
                    }
                }
                logger.addHandler((Handler)object);
            }
        }
        logger.setUseParentHandlers(false);
        if (!bl) {
            monolineFormatter = MonolineFormatter.addHandler(logger, level);
        }
        return monolineFormatter;
    }

    private static MonolineFormatter addHandler(Logger logger, Level level) {
        MonolineFormatter monolineFormatter = null;
        try {
            ConsoleHandler consoleHandler = new ConsoleHandler();
            monolineFormatter = new MonolineFormatter(consoleHandler);
            consoleHandler.setFormatter(monolineFormatter);
            MonolineFormatter.setLevel(consoleHandler, level);
            logger.addHandler(consoleHandler);
        }
        catch (SecurityException securityException) {
            MonolineFormatter.unexpectedException(securityException);
        }
        return monolineFormatter;
    }

    private static void setLevel(Handler handler, Level level) {
        if (level != null) {
            int n = level.intValue();
            int n2 = handler.getLevel().intValue();
            if (n < LEVEL_THRESHOLD.intValue() ? n < n2 : n > n2) {
                handler.setLevel(level);
            }
        }
    }

    private static void unexpectedException(Exception exception) {
        Logging.unexpectedException(MonolineFormatter.class, "configureConsoleHandler", exception);
    }

    static {
        MonolineFormatter.FORMAT_LABELS[1] = "none";
        MonolineFormatter.FORMAT_LABELS[2] = "logger:short";
        MonolineFormatter.FORMAT_LABELS[3] = "logger:long";
        MonolineFormatter.FORMAT_LABELS[4] = "class:short";
        MonolineFormatter.FORMAT_LABELS[5] = "class:long";
        LEVEL_THRESHOLD = Level.INFO;
        COMPARATOR = new Comparator<Level>(){

            @Override
            public int compare(Level level, Level level2) {
                int n;
                int n2 = level.intValue();
                if (n2 < (n = level2.intValue())) {
                    return -1;
                }
                if (n2 > n) {
                    return 1;
                }
                return 0;
            }
        };
    }
}

