/*
 * Decompiled with CFR 0.152.
 */
package org.geotoolkit.xml;

import java.net.URI;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Deque;
import java.util.LinkedList;
import java.util.Map;
import java.util.ServiceLoader;
import javax.xml.bind.JAXBContext;
import javax.xml.bind.JAXBException;
import javax.xml.bind.Marshaller;
import javax.xml.bind.Unmarshaller;
import javax.xml.bind.annotation.adapters.XmlAdapter;
import org.geotoolkit.internal.jaxb.RegisterableAdapter;
import org.geotoolkit.internal.jaxb.RegisterableTypes;
import org.geotoolkit.internal.jaxb.text.AnchoredCharSequenceAdapter;
import org.geotoolkit.util.logging.Logging;
import org.geotoolkit.xml.Pooled;
import org.geotoolkit.xml.PooledMarshaller;
import org.geotoolkit.xml.PooledUnmarshaller;

public class MarshallerPool {
    private static final int CAPACITY = 16;
    public static final String ROOT_NAMESPACE_KEY = "org.geotoolkit.xml.rootNamespace";
    private static final ServiceLoader<RegisterableTypes> TYPES = ServiceLoader.load(RegisterableTypes.class);
    private static final ServiceLoader<RegisterableAdapter> ADAPTERS = ServiceLoader.load(RegisterableAdapter.class);
    private final JAXBContext context;
    private final boolean internal;
    private final Object mapper;
    private final AnchoredCharSequenceAdapter anchors = new AnchoredCharSequenceAdapter();
    private final Deque<Marshaller> marshallers = new LinkedList<Marshaller>();
    private final Deque<Unmarshaller> unmarshallers = new LinkedList<Unmarshaller>();

    public static Class<?>[] defaultClassesToBeBound() {
        ArrayList arrayList = new ArrayList();
        for (RegisterableTypes registerableTypes : TYPES) {
            registerableTypes.getTypes(arrayList);
        }
        return arrayList.toArray(new Class[arrayList.size()]);
    }

    public MarshallerPool(Class<?> ... classArray) throws JAXBException {
        this(Collections.emptyMap(), classArray);
    }

    @Deprecated
    public MarshallerPool(String string, Class<?> ... classArray) throws JAXBException {
        this(Collections.singletonMap(ROOT_NAMESPACE_KEY, string), classArray);
    }

    public MarshallerPool(Map<String, String> map, Class<?> ... classArray) throws JAXBException {
        this(map, JAXBContext.newInstance((Class[])classArray));
    }

    public MarshallerPool(String string) throws JAXBException {
        this(Collections.emptyMap(), string);
    }

    @Deprecated
    public MarshallerPool(String string, String string2) throws JAXBException {
        this(Collections.singletonMap(ROOT_NAMESPACE_KEY, string), string2);
    }

    public MarshallerPool(Map<String, String> map, String string) throws JAXBException {
        this(map, JAXBContext.newInstance((String)string));
    }

    private MarshallerPool(Map<String, String> map, JAXBContext jAXBContext) throws JAXBException {
        this.context = jAXBContext;
        String string = map.get(ROOT_NAMESPACE_KEY);
        if (string == null) {
            string = "";
        }
        this.internal = !jAXBContext.getClass().getName().startsWith("com.sun.xml.bind");
        String string2 = "org.geotoolkit.xml.OGCNamespacePrefixMapper_Endorsed";
        if (this.internal) {
            string2 = string2.substring(0, string2.lastIndexOf(95));
        }
        try {
            this.mapper = Class.forName(string2).getConstructor(String.class).newInstance(string);
        }
        catch (Throwable throwable) {
            throw new JAXBException("Unsupported JAXB implementation.", throwable);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> T acquire(Deque<T> deque) {
        Deque<T> deque2 = deque;
        synchronized (deque2) {
            return deque.pollLast();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static <T> void release(Deque<T> deque, T t) {
        try {
            ((Pooled)t).reset();
        }
        catch (JAXBException jAXBException) {
            Logging.unexpectedException(MarshallerPool.class, "release", jAXBException);
            return;
        }
        Deque<T> deque2 = deque;
        synchronized (deque2) {
            deque.addLast(t);
            while (deque.size() > 16) {
                deque.removeFirst();
            }
        }
    }

    public Marshaller acquireMarshaller() throws JAXBException {
        Marshaller marshaller = MarshallerPool.acquire(this.marshallers);
        if (marshaller == null) {
            marshaller = this.createMarshaller();
            marshaller = new PooledMarshaller(marshaller, this.internal);
        }
        return marshaller;
    }

    public Unmarshaller acquireUnmarshaller() throws JAXBException {
        Unmarshaller unmarshaller = MarshallerPool.acquire(this.unmarshallers);
        if (unmarshaller == null) {
            unmarshaller = this.createUnmarshaller();
            unmarshaller = new PooledUnmarshaller(unmarshaller, this.internal);
        }
        return unmarshaller;
    }

    public void release(Marshaller marshaller) {
        MarshallerPool.release(this.marshallers, marshaller);
    }

    public void release(Unmarshaller unmarshaller) {
        MarshallerPool.release(this.unmarshallers, unmarshaller);
    }

    protected Marshaller createMarshaller() throws JAXBException {
        String string = this.internal ? "com.sun.xml.internal.bind.namespacePrefixMapper" : "com.sun.xml.bind.namespacePrefixMapper";
        Marshaller marshaller = this.context.createMarshaller();
        marshaller.setProperty("jaxb.formatted.output", (Object)true);
        marshaller.setProperty("jaxb.encoding", (Object)"UTF-8");
        marshaller.setProperty(string, this.mapper);
        marshaller.setAdapter((XmlAdapter)this.anchors);
        marshaller.setAdapter((XmlAdapter)this.anchors.string);
        marshaller.setAdapter((XmlAdapter)this.anchors.international);
        for (RegisterableAdapter registerableAdapter : ADAPTERS) {
            registerableAdapter.register(marshaller);
        }
        return marshaller;
    }

    protected Unmarshaller createUnmarshaller() throws JAXBException {
        Unmarshaller unmarshaller = this.context.createUnmarshaller();
        unmarshaller.setAdapter((XmlAdapter)this.anchors);
        unmarshaller.setAdapter((XmlAdapter)this.anchors.string);
        unmarshaller.setAdapter((XmlAdapter)this.anchors.international);
        for (RegisterableAdapter registerableAdapter : ADAPTERS) {
            registerableAdapter.register(unmarshaller);
        }
        return unmarshaller;
    }

    protected void addAnchor(String string, URI uRI) throws IllegalStateException {
        this.anchors.addLinkage(string, uRI);
    }
}

