/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2.dt.trajectory;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.ArrayFloat;
import ucar.ma2.ArrayInt;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.StructureData;
import ucar.nc2.Attribute;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Structure;
import ucar.nc2.StructurePseudo;
import ucar.nc2.Variable;
import ucar.nc2.VariableSimpleIF;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.dataset.VariableDS;
import ucar.nc2.dt.DataIterator;
import ucar.nc2.dt.DatatypeIterator;
import ucar.nc2.dt.PointObsDatatype;
import ucar.nc2.dt.TrajectoryObsDataset;
import ucar.nc2.dt.TrajectoryObsDatatype;
import ucar.nc2.dt.TypedDatasetImpl;
import ucar.nc2.dt.VariableSimpleSubclass;
import ucar.nc2.units.DateUnit;
import ucar.nc2.units.SimpleUnit;
import ucar.unidata.geoloc.EarthLocation;
import ucar.unidata.geoloc.EarthLocationImpl;
import ucar.unidata.geoloc.LatLonRect;

public abstract class TrajectoryObsDatasetImpl
extends TypedDatasetImpl
implements TrajectoryObsDataset {
    protected String trajectoryId;
    protected int trajectoryNumPoint;
    protected HashMap trajectoryVarsMap;
    protected Dimension trajectoryDim;
    protected Variable dimVar;
    protected Structure recordVar;
    protected Variable latVar;
    protected Variable lonVar;
    protected Variable elevVar;
    protected String dimVarUnitsString;
    protected double elevVarUnitsConversionFactor;
    protected TrajectoryObsDatatype trajectory;

    public TrajectoryObsDatasetImpl() {
    }

    public TrajectoryObsDatasetImpl(NetcdfDataset ncfile) {
        super(ncfile);
    }

    public void setTrajectoryInfo(Config trajConfig) throws IOException {
        Object result;
        if (this.trajectoryDim != null) {
            throw new IllegalStateException("The setTrajectoryInfo() method can only be called once.");
        }
        this.trajectoryId = trajConfig.getTrajectoryId();
        this.trajectoryDim = trajConfig.getTrajectoryDim();
        this.dimVar = trajConfig.getDimensionVar();
        this.latVar = trajConfig.getLatVar();
        this.lonVar = trajConfig.getLonVar();
        this.elevVar = trajConfig.getElevVar();
        this.trajectoryNumPoint = this.trajectoryDim.getLength();
        this.dimVarUnitsString = this.dimVar.findAttribute("units").getStringValue();
        String latVarUnitsString = this.latVar.findAttribute("units").getStringValue();
        if (!SimpleUnit.isCompatible(latVarUnitsString, "deg")) {
            throw new IllegalArgumentException("Units of lat var <" + latVarUnitsString + "> not compatible with \"degrees_north\".");
        }
        String lonVarUnitsString = this.lonVar.findAttribute("units").getStringValue();
        if (!SimpleUnit.isCompatible(lonVarUnitsString, "deg")) {
            throw new IllegalArgumentException("Units of lon var <" + lonVarUnitsString + "> not compatible with \"degrees_east\".");
        }
        String elevVarUnitsString = this.elevVar.findAttribute("units").getStringValue();
        if (!SimpleUnit.isCompatible(elevVarUnitsString, "meters")) {
            throw new IllegalArgumentException("Units of elev var <" + elevVarUnitsString + "> not compatible with \"meters\".");
        }
        try {
            this.elevVarUnitsConversionFactor = TrajectoryObsDatasetImpl.getMetersConversionFactor(elevVarUnitsString);
        }
        catch (Exception e) {
            throw new IllegalArgumentException("Exception on getMetersConversionFactor() for the units of elev var <" + elevVarUnitsString + ">.");
        }
        this.recordVar = this.ncfile.hasUnlimitedDimension() && this.ncfile.getUnlimitedDimension().equals(this.trajectoryDim) ? ((result = this.ncfile.sendIospMessage("AddRecordStructure")) != null && ((Boolean)result).booleanValue() ? (Structure)this.ncfile.getRootGroup().findVariable("record") : new StructurePseudo((NetcdfFile)this.ncfile, null, "record", this.trajectoryDim)) : new StructurePseudo((NetcdfFile)this.ncfile, null, "record", this.trajectoryDim);
        Variable elevVarInRecVar = this.recordVar.findVariable(this.elevVar.getFullNameEscaped());
        if (!elevVarUnitsString.equals(elevVarInRecVar.findAttribute("units").getStringValue())) {
            elevVarInRecVar.addAttribute(new Attribute("units", elevVarUnitsString));
        }
        this.trajectoryVarsMap = new HashMap();
        for (Variable curVar : this.ncfile.getRootGroup().getVariables()) {
            if (curVar.getRank() <= 0 || curVar.equals(this.dimVar) || curVar.equals(this.latVar) || curVar.equals(this.lonVar) || curVar.equals(this.elevVar) || this.recordVar != null && curVar.equals(this.recordVar)) continue;
            MyTypedDataVariable typedVar = new MyTypedDataVariable(new VariableDS(null, curVar, true));
            this.dataVariables.add(typedVar);
            this.trajectoryVarsMap.put(typedVar.getShortName(), typedVar);
        }
        this.trajectory = new Trajectory(this.trajectoryId, this.trajectoryNumPoint, this.dimVar, this.dimVarUnitsString, this.latVar, this.lonVar, this.elevVar, this.dataVariables, this.trajectoryVarsMap);
        this.startDate = this.getStartDate();
        this.endDate = this.getEndDate();
        ((Trajectory)this.trajectory).setStartDate(this.startDate);
        ((Trajectory)this.trajectory).setEndDate(this.endDate);
    }

    protected static double getMetersConversionFactor(String unitsString) throws Exception {
        SimpleUnit unit = SimpleUnit.factoryWithExceptions(unitsString);
        return unit.convertTo(1.0, SimpleUnit.meterUnit);
    }

    @Override
    protected void setBoundingBox() {
    }

    public List getTrajectoryIds() {
        ArrayList<String> l = new ArrayList<String>();
        l.add(this.trajectoryId);
        return l;
    }

    @Override
    public List getTrajectories() {
        ArrayList<TrajectoryObsDatatype> l = new ArrayList<TrajectoryObsDatatype>();
        l.add(this.trajectory);
        return l;
    }

    @Override
    public TrajectoryObsDatatype getTrajectory(String trajectoryId) {
        if (!trajectoryId.equals(this.trajectoryId)) {
            return null;
        }
        return this.trajectory;
    }

    @Override
    public String getDetailInfo() {
        StringBuffer sbuff = new StringBuffer();
        sbuff.append("TrajectoryObsDataset\n");
        sbuff.append("  adapter   = " + this.getClass().getName() + "\n");
        sbuff.append("  trajectories:\n");
        Iterator it = this.getTrajectoryIds().iterator();
        while (it.hasNext()) {
            sbuff.append("      " + (String)it.next() + "\n");
        }
        sbuff.append(super.getDetailInfo());
        return sbuff.toString();
    }

    @Override
    public boolean syncExtend() {
        if (!this.ncfile.hasUnlimitedDimension()) {
            return false;
        }
        try {
            if (!this.ncfile.syncExtend()) {
                return false;
            }
        }
        catch (IOException e) {
            return false;
        }
        int newNumPoints = this.trajectoryDim.getLength();
        if (this.trajectoryNumPoint >= newNumPoints) {
            return false;
        }
        this.trajectoryNumPoint = newNumPoints;
        ((Trajectory)this.trajectory).setNumPoints(this.trajectoryNumPoint);
        try {
            this.endDate = this.trajectory.getTime(this.trajectoryNumPoint - 1);
        }
        catch (IOException e) {
            return false;
        }
        ((Trajectory)this.trajectory).setEndDate(this.endDate);
        return true;
    }

    private class MyTypedDataVariable
    extends VariableSimpleSubclass {
        private int rank;
        private int[] shape;

        private MyTypedDataVariable(VariableDS v) {
            super(v);
            this.rank = super.getRank() - 1;
            int[] varShape = super.getShape();
            this.shape = new int[varShape.length - 1];
            int trajDimIndex = v.findDimensionIndex(TrajectoryObsDatasetImpl.this.trajectoryDim.getName());
            int j = 0;
            for (int i = 0; i < varShape.length; ++i) {
                if (i == trajDimIndex) continue;
                this.shape[j++] = varShape[i];
            }
        }

        @Override
        public int getRank() {
            return this.rank;
        }

        @Override
        public int[] getShape() {
            return this.shape;
        }
    }

    private class Trajectory
    implements TrajectoryObsDatatype {
        private String id;
        private String description = null;
        private int numPoints;
        private Date startDate;
        private Date endDate;
        private String dimVarUnitsString;
        private Variable dimVar;
        private Variable latVar;
        private Variable lonVar;
        private Variable elevVar;
        private List variables;
        private HashMap variablesMap;

        private Trajectory(String id, int numPoints, Variable dimVar, String dimVarUnitsString, Variable latVar, Variable lonVar, Variable elevVar, List variables, HashMap variablesMap) {
            this.id = id;
            this.numPoints = numPoints;
            this.dimVarUnitsString = dimVarUnitsString;
            this.dimVar = dimVar;
            this.variables = variables;
            this.variablesMap = variablesMap;
            this.latVar = latVar;
            this.lonVar = lonVar;
            this.elevVar = elevVar;
        }

        protected void setNumPoints(int numPoints) {
            this.numPoints = numPoints;
        }

        protected void setStartDate(Date startDate) {
            if (this.startDate != null) {
                throw new IllegalStateException("Can only call setStartDate() once.");
            }
            this.startDate = startDate;
        }

        protected void setEndDate(Date endDate) {
            this.endDate = endDate;
        }

        @Override
        public String getId() {
            return this.id;
        }

        @Override
        public String getDescription() {
            return this.description;
        }

        @Override
        public int getNumberPoints() {
            return this.numPoints;
        }

        @Override
        public List getDataVariables() {
            return this.variables;
        }

        @Override
        public VariableSimpleIF getDataVariable(String name) {
            return (VariableSimpleIF)this.variablesMap.get(name);
        }

        @Override
        public PointObsDatatype getPointObsData(int point) throws IOException {
            return new MyPointObsDatatype(point);
        }

        @Override
        public Date getStartDate() {
            return this.startDate;
        }

        @Override
        public Date getEndDate() {
            return this.endDate;
        }

        @Override
        public LatLonRect getBoundingBox() {
            return null;
        }

        @Override
        public Date getTime(int point) throws IOException {
            if (SimpleUnit.isDateUnit(this.dimVarUnitsString)) {
                return DateUnit.getStandardDate(this.getTimeValue(point) + " " + this.dimVarUnitsString);
            }
            return this.startDate;
        }

        @Override
        public EarthLocation getLocation(int point) throws IOException {
            return new MyEarthLocation(point);
        }

        @Override
        public String getTimeUnitsIdentifier() {
            return this.dimVarUnitsString;
        }

        @Override
        public double getTimeValue(int point) throws IOException {
            Array array = null;
            try {
                array = this.getTime(this.getPointRange(point));
            }
            catch (InvalidRangeException e) {
                IllegalArgumentException iae = new IllegalArgumentException("Point <" + point + "> not in valid range <0, " + (this.getNumberPoints() - 1) + ">: " + e.getMessage());
                iae.initCause(e);
                throw iae;
            }
            if (array instanceof ArrayDouble) {
                return array.getDouble(array.getIndex());
            }
            if (array instanceof ArrayFloat) {
                return array.getFloat(array.getIndex());
            }
            if (array instanceof ArrayInt) {
                return array.getInt(array.getIndex());
            }
            throw new IOException("Time variable not float, double, or integer <" + array.getElementType().toString() + ">.");
        }

        @Override
        public double getLatitude(int point) throws IOException {
            Array array = null;
            try {
                array = this.getLatitude(this.getPointRange(point));
            }
            catch (InvalidRangeException e) {
                IllegalArgumentException iae = new IllegalArgumentException("Point <" + point + "> not in valid range <0, " + (this.getNumberPoints() - 1) + ">: " + e.getMessage());
                iae.initCause(e);
                throw iae;
            }
            if (array instanceof ArrayDouble) {
                return array.getDouble(array.getIndex());
            }
            if (array instanceof ArrayFloat) {
                return array.getFloat(array.getIndex());
            }
            throw new IOException("Latitude variable not float or double <" + array.getElementType().toString() + ">.");
        }

        @Override
        public double getLongitude(int point) throws IOException {
            Array array = null;
            try {
                array = this.getLongitude(this.getPointRange(point));
            }
            catch (InvalidRangeException e) {
                IllegalArgumentException iae = new IllegalArgumentException("Point <" + point + "> not in valid range <0, " + (this.getNumberPoints() - 1) + ">: " + e.getMessage());
                iae.initCause(e);
                throw iae;
            }
            if (array instanceof ArrayDouble) {
                return array.getDouble(array.getIndex());
            }
            if (array instanceof ArrayFloat) {
                return array.getFloat(array.getIndex());
            }
            throw new IOException("Longitude variable not float or double <" + array.getElementType().toString() + ">.");
        }

        @Override
        public double getElevation(int point) throws IOException {
            Array array = null;
            try {
                array = this.getElevation(this.getPointRange(point));
            }
            catch (InvalidRangeException e) {
                IllegalArgumentException iae = new IllegalArgumentException("Point <" + point + "> not in valid range <0, " + (this.getNumberPoints() - 1) + ">: " + e.getMessage());
                iae.initCause(e);
                throw iae;
            }
            if (array instanceof ArrayDouble) {
                return array.getDouble(array.getIndex());
            }
            if (array instanceof ArrayFloat) {
                return array.getFloat(array.getIndex());
            }
            throw new IOException("Elevation variable not float or double <" + array.getElementType().toString() + ">.");
        }

        @Override
        public StructureData getData(int point) throws IOException, InvalidRangeException {
            return TrajectoryObsDatasetImpl.this.recordVar.readStructure(point);
        }

        @Override
        public Array getData(int point, String parameterName) throws IOException {
            try {
                return this.getData(this.getPointRange(point), parameterName);
            }
            catch (InvalidRangeException e) {
                IllegalArgumentException iae = new IllegalArgumentException("Point <" + point + "> not in valid range <0, " + (this.getNumberPoints() - 1) + ">: " + e.getMessage());
                iae.initCause(e);
                throw iae;
            }
        }

        @Override
        public Range getFullRange() {
            Range range = null;
            try {
                range = new Range(0, this.getNumberPoints() - 1);
            }
            catch (InvalidRangeException e) {
                IllegalStateException ise = new IllegalStateException("Full trajectory range invalid <0, " + (this.getNumberPoints() - 1) + ">: " + e.getMessage());
                ise.initCause(e);
                throw ise;
            }
            return range;
        }

        @Override
        public Range getPointRange(int point) throws InvalidRangeException {
            if (point >= this.getNumberPoints()) {
                throw new InvalidRangeException("Point <" + point + "> not in acceptible range <0, " + (this.getNumberPoints() - 1) + ">.");
            }
            return new Range(point, point);
        }

        @Override
        public Range getRange(int start, int end, int stride) throws InvalidRangeException {
            if (end >= this.getNumberPoints()) {
                throw new InvalidRangeException("End point <" + end + "> not in acceptible range <0, " + (this.getNumberPoints() - 1) + ">.");
            }
            return new Range(start, end, stride);
        }

        @Override
        public Array getTime(Range range) throws IOException, InvalidRangeException {
            Array array = null;
            ArrayList<Range> section = new ArrayList<Range>(1);
            section.add(range);
            array = this.dimVar.read(section);
            if (SimpleUnit.isDateUnit(this.dimVarUnitsString)) {
                return array;
            }
            int size = (int)array.getSize();
            double[] pa = new double[size];
            for (int i = 0; i < size; ++i) {
                pa[i] = this.startDate.getTime();
            }
            Array ay = Array.factory(Double.TYPE, array.getShape(), (Object)pa);
            return ay;
        }

        @Override
        public Array getLatitude(Range range) throws IOException, InvalidRangeException {
            ArrayList<Range> section = new ArrayList<Range>(1);
            section.add(range);
            return this.latVar.read(section);
        }

        @Override
        public Array getLongitude(Range range) throws IOException, InvalidRangeException {
            ArrayList<Range> section = new ArrayList<Range>(1);
            section.add(range);
            return this.lonVar.read(section);
        }

        @Override
        public Array getElevation(Range range) throws IOException, InvalidRangeException {
            ArrayList<Range> section = new ArrayList<Range>(1);
            section.add(range);
            Array a = this.elevVar.read(section);
            if (TrajectoryObsDatasetImpl.this.elevVarUnitsConversionFactor == 1.0) {
                return a;
            }
            IndexIterator it = a.getIndexIterator();
            while (it.hasNext()) {
                if (this.elevVar.getDataType() == DataType.DOUBLE) {
                    double val = it.getDoubleNext();
                    it.setDoubleCurrent(val * TrajectoryObsDatasetImpl.this.elevVarUnitsConversionFactor);
                    continue;
                }
                if (this.elevVar.getDataType() == DataType.FLOAT) {
                    float val = it.getFloatNext();
                    it.setFloatCurrent((float)((double)val * TrajectoryObsDatasetImpl.this.elevVarUnitsConversionFactor));
                    continue;
                }
                if (this.elevVar.getDataType() == DataType.INT) {
                    int val = it.getIntNext();
                    it.setIntCurrent((int)((double)val * TrajectoryObsDatasetImpl.this.elevVarUnitsConversionFactor));
                    continue;
                }
                if (this.elevVar.getDataType() == DataType.LONG) {
                    long val = it.getLongNext();
                    it.setLongCurrent((long)((double)val * TrajectoryObsDatasetImpl.this.elevVarUnitsConversionFactor));
                    continue;
                }
                throw new IllegalStateException("Elevation variable type <" + this.elevVar.getDataType().toString() + "> not double, float, int, or long.");
            }
            return a;
        }

        @Override
        public Array getData(Range range, String parameterName) throws IOException, InvalidRangeException {
            Variable variable = TrajectoryObsDatasetImpl.this.ncfile.getRootGroup().findVariable(parameterName);
            int varRank = variable.getRank();
            int[] varShape = variable.getShape();
            ArrayList<Range> section = new ArrayList<Range>(varRank);
            section.add(range);
            for (int i = 1; i < varRank; ++i) {
                section.add(new Range(0, varShape[i] - 1));
            }
            Array array = variable.read(section);
            if (array.getShape()[0] == 1) {
                return array.reduce(0);
            }
            return array;
        }

        @Override
        public DataIterator getDataIterator(int bufferSize) throws IOException {
            return new PointDatatypeIterator(TrajectoryObsDatasetImpl.this.recordVar, bufferSize);
        }

        private class MyEarthLocation
        extends EarthLocationImpl {
            private double latitude;
            private double longitude;
            private double elevation;

            private MyEarthLocation(int point) throws IOException {
                this.latitude = Trajectory.this.getLatitude(point);
                this.longitude = Trajectory.this.getLongitude(point);
                this.elevation = Trajectory.this.getElevation(point);
            }

            private MyEarthLocation(StructureData sdata) {
                this.latitude = sdata.convertScalarDouble(Trajectory.this.latVar.getShortName());
                this.longitude = sdata.convertScalarDouble(Trajectory.this.lonVar.getShortName());
                this.elevation = sdata.convertScalarDouble(Trajectory.this.elevVar.getShortName());
                if (TrajectoryObsDatasetImpl.this.elevVarUnitsConversionFactor != 1.0) {
                    this.elevation *= TrajectoryObsDatasetImpl.this.elevVarUnitsConversionFactor;
                }
            }

            public double getLatitude() {
                return this.latitude;
            }

            public double getLongitude() {
                return this.longitude;
            }

            public double getAltitude() {
                return this.elevation;
            }
        }

        private class MyPointObsDatatype
        implements PointObsDatatype {
            private int point;
            private StructureData sdata;
            private double time;
            private EarthLocation earthLoc;

            private MyPointObsDatatype(int point) throws IOException {
                this.point = point;
                this.time = Trajectory.this.getTimeValue(point);
                this.earthLoc = Trajectory.this.getLocation(point);
            }

            private MyPointObsDatatype(int point, StructureData sdata) {
                this.point = point;
                this.sdata = sdata;
                this.time = sdata.convertScalarDouble(Trajectory.this.dimVar.getShortName());
                this.earthLoc = new MyEarthLocation(sdata);
            }

            @Override
            public double getNominalTime() {
                return this.time;
            }

            @Override
            public double getObservationTime() {
                return this.time;
            }

            @Override
            public Date getNominalTimeAsDate() {
                String dateStr = this.getNominalTime() + " " + Trajectory.this.dimVarUnitsString;
                return DateUnit.getStandardDate(dateStr);
            }

            @Override
            public Date getObservationTimeAsDate() {
                String dateStr = this.getObservationTime() + " " + Trajectory.this.dimVarUnitsString;
                return DateUnit.getStandardDate(dateStr);
            }

            @Override
            public EarthLocation getLocation() {
                return this.earthLoc;
            }

            @Override
            public StructureData getData() throws IOException {
                if (this.sdata != null) {
                    return this.sdata;
                }
                try {
                    return Trajectory.this.getData(this.point);
                }
                catch (InvalidRangeException e) {
                    throw new IllegalStateException(e.getMessage());
                }
            }
        }

        private class PointDatatypeIterator
        extends DatatypeIterator {
            @Override
            protected Object makeDatatypeWithData(int recnum, StructureData sdata) {
                return new MyPointObsDatatype(recnum, sdata);
            }

            PointDatatypeIterator(Structure struct, int bufferSize) {
                super(struct, bufferSize);
            }
        }
    }

    public static class Config {
        protected String trajectoryId;
        protected Dimension trajectoryDim;
        protected Variable dimVar;
        protected Variable latVar;
        protected Variable lonVar;
        protected Variable elevVar;

        public Config() {
        }

        public Config(String trajectoryId, Dimension trajectoryDim, Variable dimVar, Variable latVar, Variable lonVar, Variable elevVar) {
            this.trajectoryId = trajectoryId;
            this.trajectoryDim = trajectoryDim;
            this.dimVar = dimVar;
            this.latVar = latVar;
            this.lonVar = lonVar;
            this.elevVar = elevVar;
        }

        public void setTrajectoryId(String trajectoryId) {
            this.trajectoryId = trajectoryId;
        }

        public void setTrajectoryDim(Dimension trajectoryDim) {
            this.trajectoryDim = trajectoryDim;
        }

        public void setDimensionVar(Variable dimVar) {
            this.dimVar = dimVar;
        }

        public void setLatVar(Variable latVar) {
            this.latVar = latVar;
        }

        public void setLonVar(Variable lonVar) {
            this.lonVar = lonVar;
        }

        public void setElevVar(Variable elevVar) {
            this.elevVar = elevVar;
        }

        public String getTrajectoryId() {
            return this.trajectoryId;
        }

        public Dimension getTrajectoryDim() {
            return this.trajectoryDim;
        }

        public Variable getDimensionVar() {
            return this.dimVar;
        }

        public Variable getLatVar() {
            return this.latVar;
        }

        public Variable getLonVar() {
            return this.lonVar;
        }

        public Variable getElevVar() {
            return this.elevVar;
        }
    }
}

