/*
 * Decompiled with CFR 0.152.
 */
package atg.taglib.json;

import atg.taglib.json.JsonBaseTag;
import atg.taglib.json.JsonEntity;
import atg.taglib.json.Messages;
import atg.taglib.json.util.JSONArray;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.lang.reflect.Array;
import java.text.MessageFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Iterator;
import java.util.Map;
import javax.servlet.jsp.JspException;
import javax.servlet.jsp.tagext.JspFragment;

public class JsonArrayTag
extends JsonBaseTag {
    protected String mVar;
    protected Object mItems;
    protected Collection mItemsCollection;
    protected boolean mItemsPropertySet = false;

    public String getVar() {
        return this.mVar;
    }

    public void setVar(String pVar) {
        this.mVar = pVar;
    }

    public Object getItems() {
        return this.mItems;
    }

    public void setItems(Object pItems) {
        this.mItems = pItems;
        this.mItemsPropertySet = true;
    }

    public void doTag() throws JspException {
        JspFragment body = this.getJspBody();
        if (this.mItemsPropertySet && this.getVar() == null && body != null) {
            throw new JspException(Messages.getString("atg.taglib.json.error.array.1"));
        }
        try {
            JSONArray array = new JSONArray();
            JsonEntity entity = new JsonEntity(array);
            this.getEntityStack().push(entity);
            if (this.mItemsPropertySet) {
                this.coerceItemsToCollection();
                if (!this.mItemsCollection.isEmpty()) {
                    this.iterateOverItems(array);
                }
            } else if (body != null) {
                StringWriter writer = new StringWriter();
                body.invoke((Writer)writer);
            }
            this.getEntityStack().pop();
            this.processTagEnd(entity);
        }
        catch (JspException e) {
            throw e;
        }
        catch (Exception e) {
            throw new JspException(Messages.getString("atg.taglib.json.error.array.0"), (Throwable)e);
        }
    }

    private void iterateOverItems(JSONArray pArray) throws JspException, IOException {
        JspFragment body = this.getJspBody();
        Iterator it = this.mItemsCollection.iterator();
        while (it.hasNext()) {
            Object currentItem = it.next();
            if (body == null) {
                pArray.add(currentItem);
                continue;
            }
            this.getJspContext().setAttribute(this.getVar(), currentItem);
            int arraySizeBeforeInvokingBody = pArray.size();
            StringWriter writer = new StringWriter();
            body.invoke((Writer)writer);
            if (pArray.size() == arraySizeBeforeInvokingBody) {
                Object value = writer.toString();
                value = this.trimAndEscapeValue(value);
                pArray.add(value);
            }
            this.getJspContext().removeAttribute(this.getVar());
        }
    }

    private void coerceItemsToCollection() throws JspException {
        Collection<Object> result;
        Object o = this.getItems();
        if (o == null) {
            result = new ArrayList();
        } else if (o instanceof boolean[] || o instanceof byte[] || o instanceof char[] || o instanceof short[] || o instanceof int[] || o instanceof long[] || o instanceof float[] || o instanceof double[]) {
            result = this.convertArrayToList(o);
        } else if (o instanceof Object[]) {
            result = Arrays.asList((Object[])o);
        } else if (o instanceof Collection) {
            result = (Collection)o;
        } else if (o instanceof Map) {
            result = ((Map)o).values();
        } else if (o instanceof String) {
            result = Arrays.asList(((String)o).split(","));
        } else {
            String msg = MessageFormat.format(Messages.getString("atg.taglib.json.error.array.2"), o.getClass());
            throw new JspException(msg);
        }
        this.mItemsCollection = result;
    }

    private Collection convertArrayToList(Object pArray) {
        if (pArray == null) {
            return new ArrayList();
        }
        int length = Array.getLength(pArray);
        if (length == 0) {
            return new ArrayList();
        }
        Class<?> wrapperType = Array.get(pArray, 0).getClass();
        Object[] newArray = (Object[])Array.newInstance(wrapperType, length);
        for (int i = 0; i < length; ++i) {
            newArray[i] = Array.get(pArray, i);
        }
        return Arrays.asList(newArray);
    }
}

