/*
 * Decompiled with CFR 0.152.
 */
package atg.taglib.json;

import atg.taglib.json.util.JSONArray;
import atg.taglib.json.util.JSONException;
import atg.taglib.json.util.JSONObject;

public class JsonEntity {
    private Object mWrappedObject;

    public JsonEntity(Object pWrapped) {
        this.mWrappedObject = pWrapped;
    }

    public void add(Object pEntity, String pName) throws JSONException {
        if (this.mWrappedObject instanceof JSONObject) {
            if (pName == null) {
                throw new JSONException("Unable to add to JSONObject - property name is required.");
            }
            ((JSONObject)this.mWrappedObject).put(pName, pEntity);
        } else if (this.mWrappedObject instanceof JSONArray) {
            ((JSONArray)this.mWrappedObject).add(pEntity);
        }
    }

    public Object getWrappedObject() {
        return this.mWrappedObject;
    }

    public boolean isArray() {
        return this.mWrappedObject instanceof JSONArray;
    }

    public boolean isObject() {
        return this.mWrappedObject instanceof JSONObject;
    }

    public String toString() {
        return this.mWrappedObject.toString();
    }

    public String toString(int pIndentFactor) throws JSONException {
        if (this.isArray()) {
            return ((JSONArray)this.mWrappedObject).toString(pIndentFactor);
        }
        if (this.isObject()) {
            return ((JSONObject)this.mWrappedObject).toString(pIndentFactor);
        }
        return "";
    }
}

