/*
 * Decompiled with CFR 0.152.
 */
package examples;

import java.io.IOException;
import ucar.ma2.ArrayFloat;
import ucar.nc2.NetcdfFile;
import ucar.nc2.Variable;

public class Sfc_pres_temp_rd {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        int NLAT = 6;
        int NLON = 12;
        float SAMPLE_PRESSURE = 900.0f;
        float SAMPLE_TEMP = 9.0f;
        float START_LAT = 25.0f;
        float START_LON = -125.0f;
        float[][] presIn = new float[6][12];
        float[][] tempIn = new float[6][12];
        float[] latsIn = new float[6];
        float[] lonsIn = new float[12];
        String filename = "sfc_pres_temp.nc";
        NetcdfFile dataFile = null;
        try {
            dataFile = NetcdfFile.open((String)filename, null);
            Variable latVar = dataFile.findVariable("latitude");
            if (latVar == null) {
                System.out.println("Cant find Variable latitude");
                return;
            }
            Variable lonVar = dataFile.findVariable("longitude");
            if (lonVar == null) {
                System.out.println("Cant find Variable longitude");
                return;
            }
            Variable presVar = dataFile.findVariable("pressure");
            if (presVar == null) {
                System.out.println("Cant find Variable pressure");
                return;
            }
            Variable tempVar = dataFile.findVariable("temperature");
            if (tempVar == null) {
                System.out.println("Cant find Variable temperature");
                return;
            }
            if (latVar.getDimensions().size() != 1) {
                System.out.println(" fail to get the dimensions of variable latitude");
                return;
            }
            if (presVar.getDimensions().size() != 2) {
                System.out.println(" fail to get the dimensions of variable pressure");
                return;
            }
            ArrayFloat.D1 latArray = (ArrayFloat.D1)latVar.read();
            ArrayFloat.D1 lonArray = (ArrayFloat.D1)lonVar.read();
            int[] shape = latArray.getShape();
            for (int i = 0; i < shape[0]; ++i) {
                latsIn[i] = latArray.get(i);
            }
            shape = lonArray.getShape();
            for (int j = 0; j < shape[0]; ++j) {
                lonsIn[j] = lonArray.get(j);
            }
            for (int lat = 0; lat < 6; ++lat) {
                if ((double)latsIn[lat] == 25.0 + 5.0 * (double)lat) continue;
                System.err.println("ERROR reading variable latitude");
            }
            for (int lon = 0; lon < 12; ++lon) {
                if ((double)lonsIn[lon] == -125.0 + 5.0 * (double)lon) continue;
                System.err.println("ERROR reading variable longitude");
            }
            ArrayFloat.D2 presArray = (ArrayFloat.D2)presVar.read();
            ArrayFloat.D2 tempArray = (ArrayFloat.D2)tempVar.read();
            int[] shape1 = presArray.getShape();
            for (int i = 0; i < shape1[0]; ++i) {
                for (int j = 0; j < shape1[1]; ++j) {
                    presIn[i][j] = presArray.get(i, j);
                    tempIn[i][j] = tempArray.get(i, j);
                }
            }
            for (int lat = 0; lat < 6; ++lat) {
                for (int lon = 0; lon < 12; ++lon) {
                    if (presIn[lat][lon] == 900.0f + (float)(lon * 6 + lat) && (double)tempIn[lat][lon] == 9.0 + 0.25 * (double)(lon * 6 + lat)) continue;
                    System.err.println("ERROR reading variable pressure or temperature");
                }
            }
            if (!latVar.findAttributeIgnoreCase("units").getStringValue().equalsIgnoreCase("degrees_north")) {
                System.err.println("ERROR reading variable latitude units");
            }
            if (!lonVar.findAttributeIgnoreCase("units").getStringValue().equalsIgnoreCase("degrees_east")) {
                System.err.println("ERROR reading variable longitude units");
            }
            if (!presVar.findAttributeIgnoreCase("units").getStringValue().equalsIgnoreCase("hPa")) {
                System.err.println("ERROR reading variable pressure units");
            }
            if (!tempVar.findAttributeIgnoreCase("units").getStringValue().equalsIgnoreCase("celsius")) {
                System.err.println("ERROR reading variable temperature units");
            }
        }
        catch (IOException e) {
            System.out.println(" fail = " + e);
            e.printStackTrace();
        }
        finally {
            if (dataFile != null) {
                try {
                    dataFile.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
        System.out.println("*** SUCCESS reading example file sfc_pres_temp.nc!");
    }
}

