/*
 * Decompiled with CFR 0.152.
 */
package examples;

import java.io.IOException;
import java.util.ArrayList;
import ucar.ma2.Array;
import ucar.ma2.ArrayFloat;
import ucar.ma2.DataType;
import ucar.ma2.InvalidRangeException;
import ucar.nc2.Dimension;
import ucar.nc2.NetcdfFileWriteable;

public class Sfc_pres_temp_wr {
    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws Exception {
        int NLAT = 6;
        int NLON = 12;
        float SAMPLE_PRESSURE = 900.0f;
        float SAMPLE_TEMP = 9.0f;
        float START_LAT = 25.0f;
        float START_LON = -125.0f;
        String filename = "sfc_pres_temp.nc";
        NetcdfFileWriteable dataFile = null;
        try {
            int j;
            int i;
            dataFile = NetcdfFileWriteable.createNew((String)filename, (boolean)false);
            Dimension latDim = dataFile.addDimension("latitude", 6);
            Dimension lonDim = dataFile.addDimension("longitude", 12);
            ArrayList<Dimension> dims = null;
            dataFile.addVariable("latitude", DataType.FLOAT, new Dimension[]{latDim});
            dataFile.addVariable("longitude", DataType.FLOAT, new Dimension[]{lonDim});
            dataFile.addVariableAttribute("longitude", "units", "degrees_east");
            dataFile.addVariableAttribute("latitude", "units", "degrees_north");
            dims = new ArrayList<Dimension>();
            dims.add(latDim);
            dims.add(lonDim);
            dataFile.addVariable("pressure", DataType.FLOAT, dims);
            dataFile.addVariable("temperature", DataType.FLOAT, dims);
            dataFile.addVariableAttribute("pressure", "units", "hPa");
            dataFile.addVariableAttribute("temperature", "units", "celsius");
            dataFile.create();
            ArrayFloat.D1 dataLat = new ArrayFloat.D1(latDim.getLength());
            ArrayFloat.D1 dataLon = new ArrayFloat.D1(lonDim.getLength());
            for (i = 0; i < latDim.getLength(); ++i) {
                dataLat.set(i, 25.0f + 5.0f * (float)i);
            }
            for (j = 0; j < lonDim.getLength(); ++j) {
                dataLon.set(j, -125.0f + 5.0f * (float)j);
            }
            dataFile.write("latitude", (Array)dataLat);
            dataFile.write("longitude", (Array)dataLon);
            ArrayFloat.D2 dataTemp = new ArrayFloat.D2(latDim.getLength(), lonDim.getLength());
            ArrayFloat.D2 dataPres = new ArrayFloat.D2(latDim.getLength(), lonDim.getLength());
            for (i = 0; i < latDim.getLength(); ++i) {
                for (j = 0; j < lonDim.getLength(); ++j) {
                    dataTemp.set(i, j, 9.0f + 0.25f * (float)(j * 6 + i));
                    dataPres.set(i, j, 900.0f + (float)(j * 6 + i));
                }
            }
            int[] origin = new int[2];
            dataFile.write("pressure", origin, (Array)dataPres);
            dataFile.write("temperature", origin, (Array)dataTemp);
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (InvalidRangeException e) {
            e.printStackTrace();
        }
        finally {
            if (null != dataFile) {
                try {
                    dataFile.close();
                }
                catch (IOException ioe) {
                    ioe.printStackTrace();
                }
            }
        }
        System.out.println("*** SUCCESS writing example file sfc_pres_temp.nc!");
    }
}

