/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog;

import java.util.List;
import junit.framework.TestCase;
import thredds.catalog.InvAccessImpl;
import thredds.catalog.InvCatalog;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.InvDocumentation;
import thredds.catalog.InvMetadata;
import thredds.catalog.InvProperty;
import thredds.catalog.InvService;
import thredds.catalog.ServiceType;
import thredds.catalog.TestCatalogAll;
import thredds.catalog.ThreddsMetadata;

public class TestRead
extends TestCase {
    public TestRead(String name) {
        super(name);
    }

    public void testRead() {
        this.testRead((InvCatalog)TestCatalogAll.open("DatasetFmrc.xml", true));
    }

    public void testRead(InvCatalog cat) {
        assert (cat.getDataset() instanceof InvDatasetImpl);
        for (InvDatasetImpl dd : cat.getDatasets()) {
            this.testDatasets(dd);
        }
    }

    public void testDatasets(InvDatasetImpl d) {
        this.testAccess(d);
        this.testProperty(d);
        this.testDocs(d);
        this.testMetadata(d);
        this.testContributors(d);
        this.testKeywords(d);
        this.testProjects(d);
        this.testPublishers(d);
        this.testVariables(d);
        for (InvDatasetImpl dd : d.getDatasets()) {
            this.testDatasets(dd);
        }
    }

    public void testAccess(InvDatasetImpl d) {
        for (InvAccessImpl a : d.getAccess()) {
            assert (a.getService() != null);
            assert (a.getUrlPath() != null);
            assert (a.getDataset().equals(d));
            this.testService(a.getService());
        }
    }

    public void testProperty(InvDatasetImpl d) {
        block3: {
            try {
                for (InvProperty invProperty : d.getProperties()) {
                }
            }
            catch (Throwable t) {
                t.printStackTrace();
                if ($assertionsDisabled) break block3;
                throw new AssertionError();
            }
        }
    }

    public void testDocs(InvDatasetImpl d) {
        for (InvDocumentation invDocumentation : d.getDocumentation()) {
        }
    }

    public void testService(InvService s) {
        List l = s.getServices();
        if (s.getServiceType() == ServiceType.COMPOUND ? !$assertionsDisabled && l.size() <= 0 : !$assertionsDisabled && l.size() != 0) {
            throw new AssertionError();
        }
    }

    public void testMetadata(InvDatasetImpl d) {
        for (InvMetadata invMetadata : d.getMetadata()) {
        }
    }

    public void testContributors(InvDatasetImpl d) {
        for (ThreddsMetadata.Contributor contributor : d.getContributors()) {
        }
    }

    public void testKeywords(InvDatasetImpl d) {
        for (ThreddsMetadata.Vocab vocab : d.getKeywords()) {
        }
    }

    public void testProjects(InvDatasetImpl d) {
        for (ThreddsMetadata.Vocab vocab : d.getProjects()) {
        }
    }

    public void testPublishers(InvDatasetImpl d) {
        for (ThreddsMetadata.Source source : d.getPublishers()) {
        }
    }

    public void testVariables(InvDatasetImpl d) {
        for (ThreddsMetadata.Variables variables : d.getVariables()) {
        }
    }
}

