/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog;

import java.io.OutputStream;
import junit.framework.TestCase;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvDataset;
import thredds.catalog.TestCatalogAll;
import thredds.catalog.ThreddsMetadata;

public class TestSpatialCoverage
extends TestCase {
    private static boolean showValidation = false;
    String urlString = "MissingGCProblem.xml";

    public TestSpatialCoverage(String name) {
        super(name);
    }

    public void testGC() throws Exception {
        InvCatalogImpl cat = TestCatalogAll.open(this.urlString, true);
        StringBuilder buff = new StringBuilder();
        boolean isValid = cat.check(buff, false);
        System.out.println("catalog <" + cat.getName() + "> " + (isValid ? "is" : "is not") + " valid");
        if (showValidation) {
            System.out.println(" validation output=\n" + buff);
            InvCatalogFactory catFactory = InvCatalogFactory.getDefaultFactory((boolean)false);
            catFactory.writeXML(cat, (OutputStream)System.out);
        }
        InvDataset ds = cat.findDatasetByID("hasGC");
        ThreddsMetadata.GeospatialCoverage gc = ds.getGeospatialCoverage();
        assert (null != gc);
        assert (gc.getHeightStart() == 5.0) : gc.getHeightStart();
        assert (gc.getHeightExtent() == 47.0) : gc.getHeightExtent();
        assert (gc.getEastWestRange() == null);
        assert (gc.getNorthSouthRange() == null);
    }
}

