/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog;

import junit.framework.TestCase;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.TestCatalogAll;

public class TestValidate
extends TestCase {
    private static boolean showValidation = false;

    public TestValidate(String name) {
        super(name);
    }

    public String open(String catalogName, boolean shouldValidate) {
        catalogName = "file:///" + TestCatalogAll.dataDir + "/" + catalogName;
        StringBuilder buff = new StringBuilder();
        try {
            InvCatalogFactory catFactory = InvCatalogFactory.getDefaultFactory((boolean)showValidation);
            InvCatalogImpl cat = catFactory.readXML(catalogName);
            boolean validate = cat.check(buff);
            if (showValidation) {
                if (validate) {
                    System.out.println("TestValidate validate OK on " + catalogName + "\n----" + buff.toString() + "\n");
                } else {
                    System.out.println("TestValidate validate FAILED " + catalogName + "\n----" + buff.toString() + "\n");
                }
            }
            if (validate != shouldValidate) {
                System.out.println("TestValidate ERROR validate " + catalogName + " " + shouldValidate);
                TestValidate.assertTrue((boolean)false);
            }
        }
        catch (Exception e) {
            e.printStackTrace();
            TestValidate.assertTrue((boolean)false);
        }
        return buff.toString();
    }

    public void testValid() {
        this.open("InvCatalog.0.6.xml", true);
    }

    public void testInvalid() {
        this.open("ParseFails.xml", false);
        this.open("BadService.xml", false);
    }
}

