/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog;

import java.util.List;
import junit.framework.TestCase;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvDataset;
import thredds.catalog.TestCatalogAll;
import thredds.catalog.ThreddsMetadata;

public class TestVariables
extends TestCase {
    private static boolean showValidation = false;
    String urlString = "TestHarvest.xml";

    public TestVariables(String name) {
        super(name);
    }

    public void testInline() {
        InvCatalogImpl cat = TestCatalogAll.open(this.urlString, true);
        InvDataset ds = cat.findDatasetByID("solve1.dc8");
        assert (ds != null);
        List list = ds.getVariables();
        assert (list != null);
        assert (list.size() >= 2);
        ThreddsMetadata.Variables vars = this.getType(list, "CF-1.0");
        assert (vars != null);
        this.checkVariable(vars, "wv", "Wind Speed");
        this.checkVariable(vars, "o3c", "Ozone Concentration");
        ThreddsMetadata.Variables dif = this.getType(list, "DIF");
        assert (dif != null);
        this.checkVariable(dif, "wind_from_direction", "EARTH SCIENCE > Atmosphere > Atmosphere Winds > Surface Winds > wind_from_direction");
    }

    ThreddsMetadata.Variables getType(List list, String type) {
        for (int i = 0; i < list.size(); ++i) {
            ThreddsMetadata.Variables vars = (ThreddsMetadata.Variables)list.get(i);
            if (!vars.getVocabulary().equals(type)) continue;
            return vars;
        }
        return null;
    }

    void checkVariable(ThreddsMetadata.Variables vars, String name, String vname) {
        List list = vars.getVariableList();
        for (int i = 0; i < list.size(); ++i) {
            ThreddsMetadata.Variable var = (ThreddsMetadata.Variable)list.get(i);
            if (!var.getName().equals(name)) continue;
            assert (var.getVocabularyName().equals(vname));
            return;
        }
        assert (false);
    }
}

