/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog;

import java.util.Iterator;
import java.util.List;
import org.jdom.Document;
import org.jdom.Element;
import org.jdom.input.SAXBuilder;

public class XMLTest {
    private SAXBuilder builder;
    private Document document;
    private List content;
    private String xsd;
    private String xml;
    private Element root;

    XMLTest() {
    }

    public void buildDoc(String xml, String xsd) {
        try {
            this.builder = new SAXBuilder("org.apache.xerces.parsers.SAXParser", true);
            this.builder.setFeature("http://xml.org/sax/features/validation", true);
            this.builder.setFeature("http://apache.org/xml/features/validation/schema", true);
            System.out.println("Feature set...");
            System.out.println("Property set...");
            System.out.println("Building document...");
            this.document = this.builder.build(xml);
            System.out.println(xml + " was parsed and verified against " + xsd + " successfully!");
            this.root = this.document.getRootElement();
        }
        catch (Exception e) {
            System.out.println("Excpetion thrown on load.");
            System.out.println(e);
        }
    }

    public void printDocContent() {
        this.content = this.document.getContent();
        Iterator iter = this.content.iterator();
        System.out.println("\nList Size: " + this.content.size());
        while (iter.hasNext()) {
            System.out.println(iter.next());
        }
    }

    public boolean doesElementExist(String elementName) {
        List children = this.root.getChildren();
        Iterator iter = children.iterator();
        this.printListSize(children);
        this.printList(children);
        System.out.println("Looking for " + elementName);
        System.out.println("Found: " + this.root.getName());
        return this.searchSubTree(this.root, elementName);
    }

    private boolean searchSubTree(Element subRoot, String searchElem) {
        List children = subRoot.getChildren();
        Iterator iter = children.iterator();
        while (iter.hasNext()) {
            System.out.println("Found: '" + subRoot.getName() + "'  Looking for: '" + searchElem + "'");
            if (subRoot.getName().equals(searchElem)) {
                return true;
            }
            if (!this.searchSubTree((Element)iter.next(), searchElem)) continue;
            return true;
        }
        return false;
    }

    private void printListSize(List l) {
        System.out.println("\nList Size: " + l.size());
    }

    private void printList(List l) {
        Iterator iter = l.iterator();
        while (iter.hasNext()) {
            System.out.println(iter.next());
        }
    }

    public static void main(String[] args) throws Exception {
        String elmtToFind = "ELEMENT NAME";
        XMLTest xmlReader = new XMLTest();
        xmlReader.buildDoc("N:/thredds/src/test/catalog/editor.xml", "http://www.xml-schema.com/examples/schema/Editor N:/thredds/src/test/catalog/editor.xsd");
        xmlReader.printDocContent();
        if (xmlReader.doesElementExist(elmtToFind)) {
            System.out.println("ELEMENT FOUND!! : " + elmtToFind);
        } else {
            System.out.println("ELEMENT NOT FOUND!");
        }
    }
}

