/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.simpleImpl;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import junit.framework.TestCase;
import thredds.catalog.DataFormatType;
import thredds.catalog.ServiceType;
import thredds.catalog2.Dataset;
import thredds.catalog2.DatasetNode;
import thredds.catalog2.builder.AccessBuilder;
import thredds.catalog2.builder.BuilderException;
import thredds.catalog2.builder.BuilderIssues;
import thredds.catalog2.builder.CatalogRefBuilder;
import thredds.catalog2.builder.DatasetBuilder;
import thredds.catalog2.builder.DatasetNodeBuilder;
import thredds.catalog2.builder.ServiceBuilder;
import thredds.catalog2.simpleImpl.CatalogImpl;
import thredds.catalog2.simpleImpl.DatasetImpl;

public class TestDatasetImpl
extends TestCase {
    private CatalogImpl parentCatalog;
    private String parentCatName;
    private URI parentCatDocBaseUri;
    private String parentCatVer;
    private DatasetNodeBuilder parentDatasetBldr;
    private DatasetNode parentDataset;
    private String parentDsName;
    private CatalogRefBuilder catRefBldr;
    private String catRefTitle;
    private URI catRefUri;
    private DatasetImpl dsImpl;
    private DatasetBuilder dsBuilder;
    private Dataset ds;
    private String dsName;
    private ServiceBuilder sb1;
    private ServiceBuilder sb2;
    private String sn1;
    private String sn2;
    private URI sbu1;
    private URI sbu2;
    private ServiceType sType1;
    private ServiceType sType2;
    private AccessBuilder ab1;
    private AccessBuilder ab2;
    private String aup1;
    private String aup2;
    private int ads1;
    private int ads2;
    private DataFormatType aft1;
    private DataFormatType aft2;

    public TestDatasetImpl(String name) {
        super(name);
    }

    protected void setUp() {
        this.parentCatName = "parent catalog";
        try {
            this.parentCatDocBaseUri = new URI("http://server/thredds/aCat.xml");
            this.catRefUri = new URI("http://server/thredds/anotherCat.xml");
            this.sbu1 = new URI("http://server/thredds/dodsC/");
            this.sbu2 = new URI("http://server/thredds/wcs/");
        }
        catch (URISyntaxException e) {
            TestDatasetImpl.fail((String)("Bad URI syntax: " + e.getMessage()));
            return;
        }
        this.parentCatVer = "version";
        this.parentCatalog = new CatalogImpl(this.parentCatName, this.parentCatDocBaseUri, this.parentCatVer, null, null);
        this.sn1 = "odap";
        this.sType1 = ServiceType.OPENDAP;
        this.sb1 = this.parentCatalog.addService(this.sn1, this.sType1, this.sbu1);
        this.sn2 = "wcs";
        this.sType2 = ServiceType.WCS;
        this.sb2 = this.parentCatalog.addService(this.sn2, this.sType2, this.sbu2);
        this.parentDsName = "parent dataset";
        this.parentDatasetBldr = this.parentCatalog.addDataset(this.parentDsName);
        this.dsName = "dataset name";
        this.dsBuilder = this.parentDatasetBldr.addDataset("dsName");
        this.catRefTitle = "Catalog Ref";
        this.catRefBldr = this.parentDatasetBldr.addCatalogRef(this.catRefTitle, this.catRefUri);
        this.ab1 = this.dsBuilder.addAccessBuilder();
        this.aup1 = "someData.nc";
        this.ads1 = 5678;
        this.aft1 = DataFormatType.NETCDF;
        this.ab1.setServiceBuilder(this.sb1);
        this.ab1.setUrlPath(this.aup1);
        this.ab1.setDataSize((long)this.ads1);
        this.ab1.setDataFormat(this.aft1);
        this.ab2 = this.dsBuilder.addAccessBuilder();
        this.aup2 = "someData2.nc";
        this.ads2 = 56782;
        this.aft2 = DataFormatType.GRIB2;
        this.ab2.setServiceBuilder(this.sb2);
        this.ab2.setUrlPath(this.aup2);
        this.ab2.setDataSize((long)this.ads2);
        this.ab2.setDataFormat(this.aft2);
    }

    public void testBuilderGet() {
        TestDatasetImpl.assertFalse((boolean)this.parentDatasetBldr.isBuilt());
        TestDatasetImpl.assertFalse((boolean)this.catRefBldr.isBuilt());
        TestDatasetImpl.assertFalse((boolean)this.dsBuilder.isBuilt());
        List abl = this.dsBuilder.getAccessBuilders();
        TestDatasetImpl.assertTrue((abl.size() == 2 ? 1 : 0) != 0);
        TestDatasetImpl.assertTrue((abl.get(0) == this.ab1 ? 1 : 0) != 0);
        TestDatasetImpl.assertTrue((abl.get(1) == this.ab2 ? 1 : 0) != 0);
        List ablOdap = this.dsBuilder.getAccessBuildersByType(ServiceType.OPENDAP);
        TestDatasetImpl.assertTrue((ablOdap.size() == 1 ? 1 : 0) != 0);
        TestDatasetImpl.assertTrue((ablOdap.get(0) == this.ab1 ? 1 : 0) != 0);
        List ablWcs = this.dsBuilder.getAccessBuildersByType(ServiceType.WCS);
        TestDatasetImpl.assertTrue((ablWcs.size() == 1 ? 1 : 0) != 0);
        TestDatasetImpl.assertTrue((ablWcs.get(0) == this.ab2 ? 1 : 0) != 0);
    }

    public void testBuilderRemove() {
        TestDatasetImpl.assertTrue((boolean)this.dsBuilder.removeAccessBuilder(this.ab1));
        List abl = this.dsBuilder.getAccessBuilders();
        TestDatasetImpl.assertTrue((abl.size() == 1 ? 1 : 0) != 0);
        TestDatasetImpl.assertTrue((abl.get(0) == this.ab2 ? 1 : 0) != 0);
        List ablOdap = this.dsBuilder.getAccessBuildersByType(ServiceType.OPENDAP);
        TestDatasetImpl.assertTrue((ablOdap.size() == 0 ? 1 : 0) != 0);
        List ablWcs = this.dsBuilder.getAccessBuildersByType(ServiceType.WCS);
        TestDatasetImpl.assertTrue((ablWcs.size() == 1 ? 1 : 0) != 0);
        TestDatasetImpl.assertTrue((ablWcs.get(0) == this.ab2 ? 1 : 0) != 0);
        TestDatasetImpl.assertFalse((boolean)this.dsBuilder.removeAccessBuilder(this.ab1));
    }

    public void testBuilderIllegalStateException() {
        this.ds = (DatasetImpl)this.dsBuilder;
        try {
            this.ds.getAccesses();
        }
        catch (IllegalStateException ise) {
            try {
                this.ds.getAccessesByType(ServiceType.OPENDAP);
            }
            catch (IllegalStateException ise2) {
                return;
            }
            catch (Exception e) {
                TestDatasetImpl.fail((String)("Unexpected non-IllegalStateException: " + e.getMessage()));
            }
        }
        catch (Exception e) {
            TestDatasetImpl.fail((String)("Unexpected non-IllegalStateException: " + e.getMessage()));
        }
        TestDatasetImpl.fail((String)"Did not throw expected IllegalStateException.");
    }

    public void testBuild() {
        BuilderIssues issues = this.parentDatasetBldr.getIssues();
        if (!issues.isValid()) {
            StringBuilder stringBuilder = new StringBuilder("Invalid dataset: ").append(issues.toString());
            TestDatasetImpl.fail((String)stringBuilder.toString());
        }
        try {
            this.parentDataset = this.parentDatasetBldr.build();
        }
        catch (BuilderException e) {
            TestDatasetImpl.fail((String)("Build failed: " + e.getMessage()));
        }
        TestDatasetImpl.assertTrue((boolean)this.parentDatasetBldr.isBuilt());
        TestDatasetImpl.assertTrue((boolean)this.catRefBldr.isBuilt());
        TestDatasetImpl.assertTrue((boolean)this.dsBuilder.isBuilt());
        this.ds = (Dataset)this.dsBuilder;
        TestDatasetImpl.assertTrue((boolean)this.ds.isAccessible());
        List al = this.ds.getAccesses();
        TestDatasetImpl.assertTrue((al.size() == 2 ? 1 : 0) != 0);
        TestDatasetImpl.assertTrue((al.get(0) == this.ab1 ? 1 : 0) != 0);
        TestDatasetImpl.assertTrue((al.get(1) == this.ab2 ? 1 : 0) != 0);
        al = this.ds.getAccessesByType(ServiceType.OPENDAP);
        TestDatasetImpl.assertTrue((al.size() == 1 ? 1 : 0) != 0);
        TestDatasetImpl.assertTrue((al.get(0) == this.ab1 ? 1 : 0) != 0);
        al = this.ds.getAccessesByType(ServiceType.WCS);
        TestDatasetImpl.assertTrue((al.size() == 1 ? 1 : 0) != 0);
        TestDatasetImpl.assertTrue((al.get(0) == this.ab2 ? 1 : 0) != 0);
        try {
            this.dsBuilder.addAccessBuilder();
        }
        catch (IllegalStateException ise) {
            return;
        }
        catch (Exception e) {
            TestDatasetImpl.fail((String)("Unexpected non-IllegalStateException thrown: " + e.getMessage()));
        }
        TestDatasetImpl.fail((String)"Did not throw expected IllegalStateException.");
    }
}

