/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.simpleImpl;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import junit.framework.TestCase;
import thredds.catalog2.DatasetNode;
import thredds.catalog2.Property;
import thredds.catalog2.builder.BuilderException;
import thredds.catalog2.builder.BuilderIssues;
import thredds.catalog2.builder.CatalogRefBuilder;
import thredds.catalog2.builder.DatasetNodeBuilder;
import thredds.catalog2.builder.MetadataBuilder;
import thredds.catalog2.builder.ThreddsMetadataBuilder;
import thredds.catalog2.simpleImpl.CatalogImpl;
import thredds.catalog2.simpleImpl.DatasetNodeImpl;

public class TestDatasetNodeImpl
extends TestCase {
    private CatalogImpl parentCatalog;
    private String parentCatName;
    private URI parentCatDocBaseUri;
    private String parentCatVer;
    private DatasetNodeBuilder parentDataset;
    private String parentDsName;
    private CatalogRefBuilder catRefBldr;
    private String catRefId;
    private String catRefTitle;
    private URI catRefUri;
    private DatasetNodeImpl dsNodeImpl;
    private DatasetNode dsNode;
    private DatasetNodeBuilder dsNodeBldr;
    private String id;
    private String idAuthority;
    private String name;
    private String p1n;
    private String p1v;
    private String p2n;
    private String p2v;
    private String p3n;
    private String p3v;
    private ThreddsMetadataBuilder thrMdBuilder;
    private MetadataBuilder mdBuilder;
    private DatasetNodeBuilder childDsNodeBuilder1;
    private DatasetNodeBuilder childDsNodeBuilder2;
    private String childDsNodeName1;
    private String childDsNodeName2;
    private String childDsNodeId1;
    private String childDsNodeId2;
    private String childDsNodeId1_new;
    private String childDsNodeId2_new;

    public TestDatasetNodeImpl(String name) {
        super(name);
    }

    protected void setUp() {
        this.parentCatName = "parent catalog";
        this.parentCatDocBaseUri = null;
        try {
            this.parentCatDocBaseUri = new URI("http://server/thredds/aCat.xml");
            this.catRefUri = new URI("http://server/thredds/anotherCat.xml");
        }
        catch (URISyntaxException e) {
            TestDatasetNodeImpl.fail((String)("Bad URI syntax: " + e.getMessage()));
        }
        this.parentCatVer = "version";
        this.parentCatalog = new CatalogImpl(this.parentCatName, this.parentCatDocBaseUri, this.parentCatVer, null, null);
        this.parentDsName = "parent dataset";
        this.parentDataset = this.parentCatalog.addDataset(this.parentDsName);
        this.catRefId = "catRef1";
        this.catRefTitle = "Catalog Ref";
        this.id = "id";
        this.idAuthority = "idAuthority";
        this.name = "name";
        this.p1n = "p1";
        this.p1v = "p1.v";
        this.p2n = "p2";
        this.p2v = "p2.v";
        this.p3n = "p3";
        this.p3v = "p3.v";
        this.childDsNodeName1 = "child ds 1";
        this.childDsNodeName2 = "child ds 2";
        this.childDsNodeId1 = "id1";
        this.childDsNodeId2 = "id2";
        this.childDsNodeId1_new = "id1_new";
        this.childDsNodeId2_new = "id2_new";
    }

    private void initBuilder() {
        TestDatasetNodeImpl.assertFalse((boolean)this.parentDataset.isBuilt());
        TestDatasetNodeImpl.assertFalse((boolean)this.dsNodeBldr.isBuilt());
        this.dsNodeBldr.setId(this.id);
        this.dsNodeBldr.setIdAuthority(this.idAuthority);
        this.dsNodeBldr.addProperty(this.p1n, this.p1v);
        this.dsNodeBldr.addProperty(this.p2n, this.p2v);
        this.dsNodeBldr.addProperty(this.p3n, this.p3v);
        this.childDsNodeBuilder1 = this.dsNodeBldr.addDataset(this.childDsNodeName1);
        this.childDsNodeBuilder2 = this.dsNodeBldr.addDataset(this.childDsNodeName2);
        this.catRefBldr = this.dsNodeBldr.addCatalogRef(this.catRefTitle, this.catRefUri);
    }

    private void checkBuilderGet() {
        String s = this.dsNodeBldr.getId();
        TestDatasetNodeImpl.assertTrue((String)("getId() [" + s + "] not as expected [" + this.id + "]."), (boolean)s.equals(this.id));
        s = this.dsNodeBldr.getIdAuthority();
        TestDatasetNodeImpl.assertTrue((String)("getIdAuthority() [" + s + "] not as expected [" + this.idAuthority + "]."), (boolean)s.equals(this.idAuthority));
        s = this.dsNodeBldr.getName();
        TestDatasetNodeImpl.assertTrue((String)("getName() [" + s + "] not as expected [" + this.name + "]."), (boolean)s.equals(this.name));
        List propertyNameList = this.dsNodeBldr.getPropertyNames();
        TestDatasetNodeImpl.assertTrue((propertyNameList.size() == 3 ? 1 : 0) != 0);
        TestDatasetNodeImpl.assertTrue((boolean)((String)propertyNameList.get(0)).equals(this.p1n));
        TestDatasetNodeImpl.assertTrue((boolean)((String)propertyNameList.get(1)).equals(this.p2n));
        TestDatasetNodeImpl.assertTrue((boolean)((String)propertyNameList.get(2)).equals(this.p3n));
        TestDatasetNodeImpl.assertTrue((boolean)this.dsNodeBldr.getPropertyValue(this.p1n).equals(this.p1v));
        TestDatasetNodeImpl.assertTrue((boolean)this.dsNodeBldr.getPropertyValue(this.p2n).equals(this.p2v));
        TestDatasetNodeImpl.assertTrue((boolean)this.dsNodeBldr.getPropertyValue(this.p3n).equals(this.p3v));
        List dsNodeBuilderList = this.dsNodeBldr.getDatasetNodeBuilders();
        TestDatasetNodeImpl.assertTrue((String)("Number of child datasets [" + dsNodeBuilderList.size() + "] not as expected [2]."), (dsNodeBuilderList.size() == 3 ? 1 : 0) != 0);
        TestDatasetNodeImpl.assertTrue((dsNodeBuilderList.get(0) == this.childDsNodeBuilder1 ? 1 : 0) != 0);
        TestDatasetNodeImpl.assertTrue((dsNodeBuilderList.get(1) == this.childDsNodeBuilder2 ? 1 : 0) != 0);
        TestDatasetNodeImpl.assertTrue((dsNodeBuilderList.get(2) == this.catRefBldr ? 1 : 0) != 0);
        TestDatasetNodeImpl.assertNull((Object)this.dsNodeBldr.getDatasetNodeBuilderById(this.childDsNodeId1));
        TestDatasetNodeImpl.assertNull((Object)this.dsNodeBldr.getDatasetNodeBuilderById(this.childDsNodeId2));
        TestDatasetNodeImpl.assertNull((Object)this.dsNodeBldr.getDatasetNodeBuilderById(this.catRefId));
        String newName = "new name";
        this.dsNodeBldr.setName(newName);
        s = this.dsNodeBldr.getName();
        TestDatasetNodeImpl.assertTrue((String)("Renamed getName() [" + s + "] not as expected [" + newName + "]."), (boolean)s.equals(newName));
    }

    private void checkDsNodeIdSetGetAndGlobal() {
        this.childDsNodeBuilder1.setId(this.childDsNodeId1);
        this.childDsNodeBuilder2.setId(this.childDsNodeId2);
        this.catRefBldr.setId(this.catRefId);
        TestDatasetNodeImpl.assertTrue((boolean)this.childDsNodeBuilder1.getId().equals(this.childDsNodeId1));
        TestDatasetNodeImpl.assertTrue((boolean)this.childDsNodeBuilder2.getId().equals(this.childDsNodeId2));
        TestDatasetNodeImpl.assertTrue((boolean)this.catRefBldr.getId().equals(this.catRefId));
        TestDatasetNodeImpl.assertTrue((boolean)this.childDsNodeBuilder1.isDatasetIdInUseGlobally(this.childDsNodeId1));
        TestDatasetNodeImpl.assertTrue((boolean)this.childDsNodeBuilder1.isDatasetIdInUseGlobally(this.childDsNodeId2));
        TestDatasetNodeImpl.assertTrue((boolean)this.childDsNodeBuilder1.isDatasetIdInUseGlobally(this.catRefId));
        TestDatasetNodeImpl.assertNull((Object)this.childDsNodeBuilder1.getDatasetNodeBuilderById(this.childDsNodeId1));
        TestDatasetNodeImpl.assertNull((Object)this.childDsNodeBuilder1.getDatasetNodeBuilderById(this.childDsNodeId2));
        TestDatasetNodeImpl.assertNull((Object)this.childDsNodeBuilder1.getDatasetNodeBuilderById(this.catRefId));
        TestDatasetNodeImpl.assertTrue((this.childDsNodeBuilder1.findDatasetNodeBuilderByIdGlobally(this.childDsNodeId1) == this.childDsNodeBuilder1 ? 1 : 0) != 0);
        TestDatasetNodeImpl.assertTrue((this.childDsNodeBuilder1.findDatasetNodeBuilderByIdGlobally(this.childDsNodeId2) == this.childDsNodeBuilder2 ? 1 : 0) != 0);
        TestDatasetNodeImpl.assertTrue((this.childDsNodeBuilder1.findDatasetNodeBuilderByIdGlobally(this.catRefId) == this.catRefBldr ? 1 : 0) != 0);
        this.childDsNodeBuilder1.setId(this.childDsNodeId1_new);
        this.childDsNodeBuilder2.setId(this.childDsNodeId2_new);
        TestDatasetNodeImpl.assertTrue((boolean)this.childDsNodeBuilder1.getId().equals(this.childDsNodeId1_new));
        TestDatasetNodeImpl.assertTrue((boolean)this.childDsNodeBuilder2.getId().equals(this.childDsNodeId2_new));
        TestDatasetNodeImpl.assertFalse((boolean)this.childDsNodeBuilder1.isDatasetIdInUseGlobally(this.childDsNodeId1));
        TestDatasetNodeImpl.assertFalse((boolean)this.childDsNodeBuilder1.isDatasetIdInUseGlobally(this.childDsNodeId2));
        TestDatasetNodeImpl.assertTrue((boolean)this.childDsNodeBuilder1.isDatasetIdInUseGlobally(this.childDsNodeId1_new));
        TestDatasetNodeImpl.assertTrue((boolean)this.childDsNodeBuilder1.isDatasetIdInUseGlobally(this.childDsNodeId2_new));
        TestDatasetNodeImpl.assertNull((Object)this.childDsNodeBuilder1.getDatasetNodeBuilderById(this.childDsNodeId1));
        TestDatasetNodeImpl.assertNull((Object)this.childDsNodeBuilder1.getDatasetNodeBuilderById(this.childDsNodeId2));
        TestDatasetNodeImpl.assertTrue((this.childDsNodeBuilder1.findDatasetNodeBuilderByIdGlobally(this.childDsNodeId1_new) == this.childDsNodeBuilder1 ? 1 : 0) != 0);
        TestDatasetNodeImpl.assertTrue((this.childDsNodeBuilder1.findDatasetNodeBuilderByIdGlobally(this.childDsNodeId2_new) == this.childDsNodeBuilder2 ? 1 : 0) != 0);
    }

    private void callBuildOnBuilder() {
        BuilderIssues issues = this.dsNodeBldr.getIssues();
        if (!issues.isValid()) {
            StringBuilder stringBuilder = new StringBuilder("Invalid dsNode: ").append(issues.toString());
            TestDatasetNodeImpl.fail((String)stringBuilder.toString());
        }
        try {
            this.dsNode = this.dsNodeBldr.build();
        }
        catch (BuilderException e) {
            TestDatasetNodeImpl.fail((String)("Build failed: " + e.getMessage()));
        }
        TestDatasetNodeImpl.assertFalse((boolean)this.parentDataset.isBuilt());
        TestDatasetNodeImpl.assertTrue((boolean)this.dsNodeBldr.isBuilt());
        TestDatasetNodeImpl.assertTrue((boolean)this.childDsNodeBuilder1.isBuilt());
        TestDatasetNodeImpl.assertTrue((boolean)this.childDsNodeBuilder2.isBuilt());
        TestDatasetNodeImpl.assertTrue((boolean)this.catRefBldr.isBuilt());
    }

    public void testCtorBuilderSetGet() {
        this.dsNodeImpl = new DatasetNodeImpl(this.name, null, null);
        this.dsNodeBldr = this.dsNodeImpl;
        this.initBuilder();
        this.checkBuilderGet();
        TestDatasetNodeImpl.assertNull((Object)this.dsNodeBldr.getParentCatalogBuilder());
        TestDatasetNodeImpl.assertNull((Object)this.dsNodeBldr.getParentDatasetBuilder());
    }

    public void testCtorBuilderSetId() {
        this.dsNodeImpl = new DatasetNodeImpl(this.name, null, null);
        this.dsNodeBldr = this.dsNodeImpl;
        this.initBuilder();
        this.checkDsNodeIdSetGetAndGlobal();
    }

    public void testChildDatasetNodeBuilderGetSet() {
        this.dsNodeBldr = this.parentDataset.addDataset(this.name);
        this.initBuilder();
        this.checkBuilderGet();
        TestDatasetNodeImpl.assertTrue((this.dsNodeBldr.getParentCatalogBuilder() == this.parentCatalog ? 1 : 0) != 0);
        TestDatasetNodeImpl.assertTrue((this.dsNodeBldr.getParentDatasetBuilder() == this.parentDataset ? 1 : 0) != 0);
    }

    public void testChildDatasetNodeBuilderSetId() {
        this.dsNodeBldr = this.parentDataset.addDataset(this.name);
        this.initBuilder();
        this.checkDsNodeIdSetGetAndGlobal();
    }

    public void testBuilderRemove() {
        this.dsNodeBldr = this.parentDataset.addDataset(this.name);
        this.initBuilder();
        TestDatasetNodeImpl.assertTrue((boolean)this.dsNodeBldr.removeProperty(this.p1n));
        TestDatasetNodeImpl.assertNull((Object)this.dsNodeBldr.getPropertyValue(this.p1n));
        TestDatasetNodeImpl.assertTrue((boolean)this.dsNodeBldr.removeDatasetNode(this.childDsNodeBuilder1));
        TestDatasetNodeImpl.assertNull((Object)this.dsNodeBldr.getDatasetNodeBuilderById(this.childDsNodeId1));
        TestDatasetNodeImpl.assertFalse((boolean)this.dsNodeBldr.isDatasetIdInUseGlobally(this.childDsNodeId1));
        TestDatasetNodeImpl.assertTrue((boolean)this.dsNodeBldr.removeDatasetNode((DatasetNodeBuilder)this.catRefBldr));
        TestDatasetNodeImpl.assertNull((Object)this.dsNodeBldr.getDatasetNodeBuilderById(this.catRefId));
        TestDatasetNodeImpl.assertFalse((boolean)this.dsNodeBldr.isDatasetIdInUseGlobally(this.catRefId));
    }

    public void testBuilderIllegalStateExceptionOnProperty() {
        this.dsNodeBldr = this.parentDataset.addDataset(this.name);
        this.initBuilder();
        this.dsNode = (DatasetNodeImpl)this.dsNodeBldr;
        try {
            this.dsNode.getProperties();
        }
        catch (IllegalStateException ise1) {
            try {
                this.dsNode.getPropertyByName(this.p1n);
            }
            catch (IllegalStateException ise2) {
                return;
            }
            catch (Exception e) {
                TestDatasetNodeImpl.fail((String)("Unexpected non-IllegalStateException: " + e.getMessage()));
            }
        }
        catch (Exception e) {
            TestDatasetNodeImpl.fail((String)("Unexpected non-IllegalStateException: " + e.getMessage()));
        }
        TestDatasetNodeImpl.fail((String)"No IllegalStateException thrown.");
    }

    public void testBuilderIllegalStateExceptionOnDataset() {
        this.dsNodeBldr = this.parentDataset.addDataset(this.name);
        this.initBuilder();
        this.dsNode = (DatasetNodeImpl)this.dsNodeBldr;
        try {
            this.dsNode.getDatasets();
        }
        catch (IllegalStateException ise1) {
            try {
                this.dsNode.getDatasetById(this.childDsNodeId1);
            }
            catch (IllegalStateException ise2) {
                return;
            }
            catch (Exception e) {
                TestDatasetNodeImpl.fail((String)("Unexpected non-IllegalStateException: " + e.getMessage()));
            }
        }
        catch (Exception e) {
            TestDatasetNodeImpl.fail((String)("Unexpected non-IllegalStateException: " + e.getMessage()));
        }
        TestDatasetNodeImpl.fail((String)"No IllegalStateException thrown.");
    }

    public void testBuild() {
        this.dsNodeBldr = this.parentDataset.addDataset(this.name);
        this.initBuilder();
        this.callBuildOnBuilder();
    }

    public void testPostBuildGetters() {
        this.dsNodeBldr = this.parentDataset.addDataset(this.name);
        this.initBuilder();
        this.childDsNodeBuilder1.setId(this.childDsNodeId1);
        this.childDsNodeBuilder2.setId(this.childDsNodeId2);
        this.catRefBldr.setId(this.catRefId);
        this.callBuildOnBuilder();
        List pl = this.dsNode.getProperties();
        TestDatasetNodeImpl.assertTrue((pl.size() == 3 ? 1 : 0) != 0);
        TestDatasetNodeImpl.assertTrue((boolean)((Property)pl.get(0)).getName().equals(this.p1n));
        TestDatasetNodeImpl.assertTrue((boolean)((Property)pl.get(1)).getName().equals(this.p2n));
        TestDatasetNodeImpl.assertTrue((boolean)((Property)pl.get(2)).getName().equals(this.p3n));
        TestDatasetNodeImpl.assertTrue((boolean)this.dsNode.getPropertyByName(this.p1n).getName().equals(this.p1n));
        TestDatasetNodeImpl.assertTrue((boolean)this.dsNode.getPropertyByName(this.p2n).getName().equals(this.p2n));
        TestDatasetNodeImpl.assertTrue((boolean)this.dsNode.getPropertyByName(this.p3n).getName().equals(this.p3n));
        List dl = this.dsNode.getDatasets();
        TestDatasetNodeImpl.assertTrue((dl.size() == 3 ? 1 : 0) != 0);
        TestDatasetNodeImpl.assertTrue((dl.get(0) == this.childDsNodeBuilder1 ? 1 : 0) != 0);
        TestDatasetNodeImpl.assertTrue((dl.get(1) == this.childDsNodeBuilder2 ? 1 : 0) != 0);
        TestDatasetNodeImpl.assertTrue((dl.get(2) == this.catRefBldr ? 1 : 0) != 0);
        TestDatasetNodeImpl.assertTrue((this.dsNode.getDatasetById(this.childDsNodeId1) == this.childDsNodeBuilder1 ? 1 : 0) != 0);
        TestDatasetNodeImpl.assertTrue((this.dsNode.getDatasetById(this.childDsNodeId2) == this.childDsNodeBuilder2 ? 1 : 0) != 0);
        TestDatasetNodeImpl.assertTrue((this.dsNode.getDatasetById(this.catRefId) == this.catRefBldr ? 1 : 0) != 0);
    }

    public void testPostBuildIllegalStateExceptionOnDataset() {
        this.dsNodeBldr = this.parentDataset.addDataset(this.name);
        this.initBuilder();
        this.callBuildOnBuilder();
        try {
            this.dsNodeBldr.getDatasetNodeBuilders();
        }
        catch (IllegalStateException ise1) {
            try {
                this.dsNodeBldr.getDatasetNodeBuilderById(this.childDsNodeId1);
            }
            catch (IllegalStateException ise2) {
                return;
            }
            catch (Exception e) {
                TestDatasetNodeImpl.fail((String)("Unexpected non-IllegalStateException: " + e.getMessage()));
            }
        }
        catch (Exception e) {
            TestDatasetNodeImpl.fail((String)("Unexpected non-IllegalStateException: " + e.getMessage()));
        }
        TestDatasetNodeImpl.fail((String)"No IllegalStateException thrown.");
    }
}

