/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.simpleImpl;

import java.net.URI;
import java.net.URISyntaxException;
import junit.framework.TestCase;
import thredds.catalog2.Metadata;
import thredds.catalog2.builder.BuilderException;
import thredds.catalog2.builder.BuilderIssues;
import thredds.catalog2.simpleImpl.MetadataImpl;

public class TestMetadataImpl
extends TestCase {
    private MetadataImpl mdImpl1;
    private Metadata md1;
    private MetadataImpl mdImpl2;
    private Metadata md2;
    private URI uri;
    private String title;
    private String content;

    public TestMetadataImpl(String name) {
        super(name);
    }

    protected void setUp() {
        try {
            this.uri = new URI("http://server/thredds/md.xml");
        }
        catch (URISyntaxException e) {
            TestMetadataImpl.fail((String)("Bad URI syntax: " + e.getMessage()));
            return;
        }
        this.title = "metadata title";
        this.content = "<x>some content</x>";
        this.mdImpl1 = new MetadataImpl(this.title, this.uri);
        this.mdImpl2 = new MetadataImpl(this.content);
    }

    public void testCtorGet() {
        TestMetadataImpl.assertFalse((boolean)this.mdImpl1.isBuilt());
        TestMetadataImpl.assertFalse((boolean)this.mdImpl1.isContainedContent());
        TestMetadataImpl.assertTrue((boolean)this.mdImpl1.getTitle().equals(this.title));
        TestMetadataImpl.assertTrue((boolean)this.mdImpl1.getExternalReference().equals(this.uri));
        TestMetadataImpl.assertTrue((boolean)this.mdImpl2.isContainedContent());
        TestMetadataImpl.assertTrue((boolean)this.mdImpl2.getContent().equals(this.content));
    }

    public void testBuilderIllegalState() {
        try {
            this.mdImpl1.getContent();
        }
        catch (IllegalStateException ise1) {
            try {
                this.mdImpl2.getTitle();
            }
            catch (IllegalStateException ise2) {
                try {
                    this.mdImpl2.getExternalReference();
                }
                catch (IllegalStateException ise3) {
                    return;
                }
                catch (Exception e) {
                    TestMetadataImpl.fail((String)"Unexpected non-IllegalStateException.");
                }
            }
            catch (Exception e) {
                TestMetadataImpl.fail((String)"Unexpected non-IllegalStateException.");
            }
        }
        catch (Exception e) {
            TestMetadataImpl.fail((String)"Unexpected non-IllegalStateException.");
        }
        TestMetadataImpl.fail((String)"Did not throw expected IllegalStateException.");
    }

    public void testBuild() {
        StringBuilder stringBuilder;
        BuilderIssues issues = this.mdImpl1.getIssues();
        if (!issues.isValid()) {
            stringBuilder = new StringBuilder("Invalid metadata: ").append(issues.toString());
            TestMetadataImpl.fail((String)stringBuilder.toString());
        }
        if (!(issues = this.mdImpl2.getIssues()).isValid()) {
            stringBuilder = new StringBuilder("Invalid metadata: ").append(issues.toString());
            TestMetadataImpl.fail((String)stringBuilder.toString());
        }
        try {
            this.md1 = this.mdImpl1.build();
        }
        catch (BuilderException e) {
            TestMetadataImpl.fail((String)("Build failed: " + e.getMessage()));
        }
        try {
            this.md2 = this.mdImpl2.build();
        }
        catch (BuilderException e) {
            TestMetadataImpl.fail((String)("Build failed: " + e.getMessage()));
        }
    }

    public void testBuiltGet() {
    }

    public void testBuiltGetIllegalState() {
    }
}

