/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.simpleImpl;

import junit.framework.TestCase;
import thredds.catalog2.simpleImpl.PropertyImpl;

public class TestPropertyImpl
extends TestCase {
    public TestPropertyImpl(String name) {
        super(name);
    }

    public void testCtorNullArgs() {
        try {
            new PropertyImpl(null, null);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        catch (Exception e) {
            TestPropertyImpl.fail((String)("Non-IllegalArgumentException: " + e.getMessage()));
        }
        TestPropertyImpl.fail((String)"No IllegalArgumentException.");
    }

    public void testCtorNullName() {
        String value = "a value";
        try {
            new PropertyImpl(null, value);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        catch (Exception e) {
            TestPropertyImpl.fail((String)("Non-IllegalArgumentException: " + e.getMessage()));
        }
        TestPropertyImpl.fail((String)"No IllegalArgumentException.");
    }

    public void testCtorNullValue() {
        String name = "a name";
        try {
            new PropertyImpl(name, null);
        }
        catch (IllegalArgumentException e) {
            return;
        }
        catch (Exception e) {
            TestPropertyImpl.fail((String)("Non-IllegalArgumentException: " + e.getMessage()));
        }
        TestPropertyImpl.fail((String)"No IllegalArgumentException.");
    }

    public void testNormal() {
        String name = "a name";
        String value = "a value";
        PropertyImpl p = null;
        try {
            p = new PropertyImpl(name, value);
        }
        catch (IllegalArgumentException e) {
            TestPropertyImpl.fail((String)("Unexpected IllegalArgumentException: " + e.getMessage()));
        }
        catch (Exception e) {
            TestPropertyImpl.fail((String)("Unexpected Non-IllegalArgumentException: " + e.getMessage()));
        }
        TestPropertyImpl.assertTrue((String)("Property name [" + p.getName() + "] not as expected [" + name + "]."), (boolean)p.getName().equals(name));
        TestPropertyImpl.assertTrue((String)("Property value [" + p.getValue() + "] not as expected [" + value + "]."), (boolean)p.getValue().equals(value));
    }
}

