/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.simpleImpl;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import thredds.catalog.ServiceType;
import thredds.catalog2.builder.BuilderException;
import thredds.catalog2.builder.BuilderIssues;
import thredds.catalog2.simpleImpl.GlobalServiceContainer;
import thredds.catalog2.simpleImpl.ServiceContainer;
import thredds.catalog2.simpleImpl.ServiceImpl;

public class TestServiceContainer {
    private GlobalServiceContainer globalServiceContainer;
    private ServiceContainer serviceContainer;
    private ServiceImpl odapService;
    private ServiceImpl wmsService;
    private ServiceImpl wcsService;

    @Before
    public void setupContainerWithThreeUniquelyNamedServices() throws Exception {
        this.globalServiceContainer = new GlobalServiceContainer();
        this.serviceContainer = new ServiceContainer(this.globalServiceContainer);
        this.odapService = this.serviceContainer.addService("odap", ServiceType.OPENDAP, new URI("http://server/thredds/dodsC/"));
        this.wmsService = this.serviceContainer.addService("wms", ServiceType.WMS, new URI("http://server/thredds/wms/"));
        this.wcsService = this.serviceContainer.addService("wcs", ServiceType.WCS, new URI("http://server/thredds/wcs/"));
    }

    @Test
    public void checkThatNewlyCreatedContainerIsEmpty() {
        GlobalServiceContainer gsc = new GlobalServiceContainer();
        ServiceContainer sc = new ServiceContainer(gsc);
        Assert.assertTrue((boolean)sc.isEmpty());
        Assert.assertNotNull((Object)gsc);
        Assert.assertTrue((boolean)gsc.isEmpty());
    }

    @Test(expected=IllegalStateException.class)
    public void checkExceptionOnPreBuildGetServiceByName() {
        this.serviceContainer.getServiceByName("odap");
    }

    @Test(expected=IllegalStateException.class)
    public void checkExceptionOnPreBuildGetServices() {
        this.serviceContainer.getServices();
    }

    @Test
    public void checkThreeAddedServicesAreContained() {
        this.assertThatThreeAddedServicesAreContained(0);
    }

    private void assertThatThreeAddedServicesAreContained(int numDuplicates) {
        Assert.assertFalse((boolean)this.serviceContainer.isEmpty());
        Assert.assertEquals((long)(3 + numDuplicates), (long)this.serviceContainer.size());
        Assert.assertTrue((boolean)this.serviceContainer.containsServiceName("odap"));
        Assert.assertTrue((boolean)this.serviceContainer.containsServiceName("wms"));
        Assert.assertTrue((boolean)this.serviceContainer.containsServiceName("wcs"));
        Assert.assertEquals((Object)this.odapService, (Object)this.serviceContainer.getServiceBuilderByName("odap"));
        Assert.assertEquals((Object)this.wmsService, (Object)this.serviceContainer.getServiceBuilderByName("wms"));
        Assert.assertEquals((Object)this.wcsService, (Object)this.serviceContainer.getServiceBuilderByName("wcs"));
    }

    @Test
    public void checkThreeAddedServicesAreContainedInOrder() {
        this.assertThatThreeAddedServicesAreContainedInOrder(0);
    }

    private void assertThatThreeAddedServicesAreContainedInOrder(int numDuplicates) {
        List serviceBuilders = this.serviceContainer.getServiceBuilders();
        Assert.assertNotNull((Object)serviceBuilders);
        Assert.assertEquals((long)(3 + numDuplicates), (long)serviceBuilders.size());
        Assert.assertEquals((Object)this.odapService, serviceBuilders.get(0));
        Assert.assertEquals((Object)this.wmsService, serviceBuilders.get(1));
        Assert.assertEquals((Object)this.wcsService, serviceBuilders.get(2));
    }

    @Test
    public void checkThreeAddedServicesAreContainedGlobally() {
        this.assertThatThreeAddedServicesAreContainedGlobally();
    }

    private void assertThatThreeAddedServicesAreContainedGlobally() {
        Assert.assertEquals((Object)this.odapService, (Object)this.serviceContainer.getServiceByGloballyUniqueName("odap"));
        Assert.assertEquals((Object)this.wmsService, (Object)this.serviceContainer.getServiceByGloballyUniqueName("wms"));
        Assert.assertEquals((Object)this.wcsService, (Object)this.serviceContainer.getServiceByGloballyUniqueName("wcs"));
        Assert.assertTrue((boolean)this.globalServiceContainer.isServiceNameInUseGlobally("odap"));
        Assert.assertTrue((boolean)this.globalServiceContainer.isServiceNameInUseGlobally("wms"));
        Assert.assertTrue((boolean)this.globalServiceContainer.isServiceNameInUseGlobally("wcs"));
        Assert.assertEquals((Object)this.odapService, (Object)this.globalServiceContainer.getServiceByGloballyUniqueName("odap"));
        Assert.assertEquals((Object)this.wmsService, (Object)this.globalServiceContainer.getServiceByGloballyUniqueName("wms"));
        Assert.assertEquals((Object)this.wcsService, (Object)this.globalServiceContainer.getServiceByGloballyUniqueName("wcs"));
    }

    @Test
    public void checkThatThreeUniqueOneDup() throws URISyntaxException {
        ServiceImpl dupWmsService = this.serviceContainer.addService("wms", ServiceType.WCS, new URI("http://server/thredds/wcs/"));
        this.assertThatThreeAddedServicesAreContained(1);
        this.assertThatThreeAddedServicesAreContainedInOrder(1);
        this.assertThatThreeAddedServicesAreContainedGlobally();
        Assert.assertEquals((Object)dupWmsService, this.serviceContainer.getServiceBuilders().get(3));
        Assert.assertFalse((boolean)this.globalServiceContainer.isEmpty());
        Assert.assertEquals((long)3L, (long)this.globalServiceContainer.numberOfServicesWithGloballyUniqueNames());
        Assert.assertEquals((long)1L, (long)this.globalServiceContainer.numberOfServicesWithDuplicateNames());
    }

    @Test
    public void checkThatThreeUniqueOneDupAfterRemoveDup() throws URISyntaxException {
        ServiceImpl dupWmsService = this.serviceContainer.addService("wms", ServiceType.WCS, new URI("http://server/thredds/wcs/"));
        this.serviceContainer.removeService(dupWmsService);
        this.assertThatThreeAddedServicesAreContained(0);
        this.assertThatThreeAddedServicesAreContainedInOrder(0);
        this.assertThatThreeAddedServicesAreContainedGlobally();
        Assert.assertFalse((boolean)this.globalServiceContainer.isEmpty());
        Assert.assertEquals((long)3L, (long)this.globalServiceContainer.numberOfServicesWithGloballyUniqueNames());
        Assert.assertEquals((long)0L, (long)this.globalServiceContainer.numberOfServicesWithDuplicateNames());
    }

    @Test
    public void checkThatThreeUniqueOneDupAfterRemoveVarious() throws URISyntaxException {
        ServiceImpl dupWmsService = this.serviceContainer.addService("wms", ServiceType.WCS, new URI("http://server/thredds/wcs/"));
        this.serviceContainer.removeService(this.wmsService);
        Assert.assertEquals((Object)dupWmsService, (Object)this.serviceContainer.getServiceBuilderByName("wms"));
        Assert.assertEquals((Object)dupWmsService, (Object)this.serviceContainer.getServiceByGloballyUniqueName("wms"));
        Assert.assertFalse((boolean)this.globalServiceContainer.isEmpty());
        Assert.assertEquals((long)3L, (long)this.globalServiceContainer.numberOfServicesWithGloballyUniqueNames());
        Assert.assertEquals((long)0L, (long)this.globalServiceContainer.numberOfServicesWithDuplicateNames());
        this.serviceContainer.removeService(this.wcsService);
        Assert.assertEquals((Object)this.odapService, (Object)this.serviceContainer.getServiceBuilderByName("odap"));
        Assert.assertEquals((Object)this.odapService, (Object)this.serviceContainer.getServiceByGloballyUniqueName("odap"));
        Assert.assertFalse((boolean)this.globalServiceContainer.isEmpty());
        Assert.assertEquals((long)2L, (long)this.globalServiceContainer.numberOfServicesWithGloballyUniqueNames());
        Assert.assertEquals((long)0L, (long)this.globalServiceContainer.numberOfServicesWithDuplicateNames());
    }

    @Test
    public void checkThatThreeUniqueServicesContainerBuilds() throws BuilderException {
        BuilderIssues issues = this.serviceContainer.getIssues();
        Assert.assertTrue((String)issues.toString(), (boolean)issues.isValid());
        Assert.assertTrue((String)issues.toString(), (boolean)issues.isEmpty());
        this.serviceContainer.build();
        Assert.assertTrue((boolean)this.serviceContainer.isBuilt());
    }

    @Test
    public void checkThatNewContainerBuilds() throws BuilderException {
        GlobalServiceContainer gsc = new GlobalServiceContainer();
        ServiceContainer sc = new ServiceContainer(gsc);
        BuilderIssues issues = sc.getIssues();
        Assert.assertTrue((String)issues.toString(), (boolean)issues.isValid());
        sc.build();
        Assert.assertTrue((boolean)sc.isBuilt());
    }
}

