/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.simpleImpl;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import thredds.catalog.ServiceType;
import thredds.catalog2.Property;
import thredds.catalog2.Service;
import thredds.catalog2.builder.BuilderException;
import thredds.catalog2.builder.BuilderIssues;
import thredds.catalog2.builder.ServiceBuilder;
import thredds.catalog2.simpleImpl.ServiceImpl;

public class TestServiceImpl {
    private String allName;
    private String odapName;
    private String wcsName;
    private String wmsName;
    private ServiceType allType;
    private ServiceType odapType;
    private ServiceType wcsType;
    private ServiceType wmsType;
    private URI allBaseUri;
    private URI odapBaseUri;
    private URI wcsBaseUri;
    private URI wmsBaseUri;
    private ServiceImpl allService;
    private ServiceImpl odapService;
    private ServiceImpl wcsService;
    private ServiceImpl wmsService;

    @Before
    public void setupCompoundService() throws URISyntaxException {
        this.allName = "all";
        this.allType = ServiceType.COMPOUND;
        this.allBaseUri = new URI("");
        this.allService = new ServiceImpl(this.allName, this.allType, this.allBaseUri, null);
        this.odapName = "odap";
        this.odapType = ServiceType.OPENDAP;
        this.odapBaseUri = new URI("http://server/thredds/dodsC/");
        this.odapService = (ServiceImpl)this.allService.addService(this.odapName, this.odapType, this.odapBaseUri);
        this.wcsName = "wcs";
        this.wcsType = ServiceType.WCS;
        this.wcsBaseUri = new URI("http://server/thredds/wcs/");
        this.wcsService = (ServiceImpl)this.allService.addService(this.wcsName, this.wcsType, this.wcsBaseUri);
        this.wmsName = "wms";
        this.wmsType = ServiceType.WMS;
        this.wmsBaseUri = new URI("http://server/thredds/wms/");
        this.wmsService = (ServiceImpl)this.allService.addService(this.wmsName, this.wmsType, this.wmsBaseUri);
    }

    @Test
    public void checkNewServiceAsExpectedAndBuildIssues() {
        ServiceImpl si = new ServiceImpl(this.odapName, this.odapType, this.odapBaseUri, null);
        Assert.assertEquals((Object)this.odapName, (Object)si.getName());
        Assert.assertEquals((Object)this.odapType, (Object)si.getType());
        Assert.assertEquals((Object)this.odapBaseUri, (Object)si.getBaseUri());
        BuilderIssues issues = si.getIssues();
        Assert.assertTrue((String)issues.toString(), (boolean)issues.isValid());
        Assert.assertTrue((String)issues.toString(), (boolean)issues.isEmpty());
    }

    @Test
    public void checkChangedServiceAsExpectedAndBuilderIssues() throws URISyntaxException {
        ServiceImpl service = new ServiceImpl(this.odapName, this.odapType, this.odapBaseUri, null);
        service.setType(this.wcsType);
        Assert.assertEquals((Object)this.wcsType, (Object)service.getType());
        service.setBaseUri(this.wcsBaseUri);
        Assert.assertEquals((Object)this.wcsBaseUri, (Object)service.getBaseUri());
        String descrip = "description";
        service.setDescription(descrip);
        Assert.assertEquals((Object)descrip, (Object)service.getDescription());
        String suffix = ".suffix";
        service.setSuffix(suffix);
        Assert.assertEquals((Object)suffix, (Object)service.getSuffix());
        BuilderIssues issues = service.getIssues();
        Assert.assertTrue((String)issues.toString(), (boolean)issues.isValid());
        Assert.assertTrue((String)issues.toString(), (boolean)issues.isEmpty());
    }

    @Test(expected=IllegalArgumentException.class)
    public void checkExceptionOnConstructorWithNullName() {
        new ServiceImpl(null, this.odapType, this.odapBaseUri, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void checkExceptionOnConstructorWithNullType() {
        new ServiceImpl(this.odapName, null, this.odapBaseUri, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void checkExceptionOnConstructorWithNullBaseUri() {
        new ServiceImpl(this.odapName, this.odapType, null, null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void checkExceptionOnChangeToNullType() {
        this.odapService.setType(null);
    }

    @Test(expected=IllegalArgumentException.class)
    public void checkExceptionOnChangeToNullBaseUri() {
        this.odapService.setBaseUri(null);
    }

    @Test
    public void checkCompoundServiceAsExpected() {
        this.assertCompoundServiceAsExpected(0);
    }

    private void assertCompoundServiceAsExpected(int numExtraServices) {
        Assert.assertEquals((Object)this.allName, (Object)this.allService.getName());
        Assert.assertEquals((Object)this.allType, (Object)this.allService.getType());
        Assert.assertEquals((Object)this.allBaseUri, (Object)this.allService.getBaseUri());
        Assert.assertEquals((Object)this.odapService, (Object)this.allService.getServiceBuilderByName(this.odapName));
        Assert.assertEquals((Object)this.wcsService, (Object)this.allService.getServiceBuilderByName(this.wcsName));
        Assert.assertEquals((Object)this.wmsService, (Object)this.allService.getServiceBuilderByName(this.wmsName));
        Assert.assertEquals((Object)this.odapService, (Object)this.allService.findServiceBuilderByNameGlobally(this.odapName));
        Assert.assertEquals((Object)this.wcsService, (Object)this.allService.findServiceBuilderByNameGlobally(this.wcsName));
        Assert.assertEquals((Object)this.wmsService, (Object)this.allService.findServiceBuilderByNameGlobally(this.wmsName));
        List serviceBuilders = this.allService.getServiceBuilders();
        Assert.assertFalse((boolean)serviceBuilders.isEmpty());
        Assert.assertEquals((long)(3 + numExtraServices), (long)serviceBuilders.size());
        Assert.assertEquals((Object)this.odapService, serviceBuilders.get(0));
        Assert.assertEquals((Object)this.wcsService, serviceBuilders.get(1));
        Assert.assertEquals((Object)this.wmsService, serviceBuilders.get(2));
    }

    @Test
    public void checkCompoundServiceWhenContainingServiceWithNonuniqueName() {
        ServiceBuilder dupService = this.allService.addService(this.odapName, this.wcsType, this.wcsBaseUri);
        this.assertCompoundServiceAsExpected(1);
        Assert.assertEquals((Object)dupService, this.allService.getServiceBuilders().get(3));
    }

    @Test
    public void testAddGetRemoveServices() throws URISyntaxException {
        ServiceBuilder sb1 = this.allService.addService("one", ServiceType.HTTPServer, new URI("http://server/thredds/httpServer/"));
        ServiceBuilder sb2 = this.allService.addService("two", ServiceType.HTTP, new URI("http://server/thredds/two/"));
        this.assertCompoundServiceAsExpected(2);
        Assert.assertEquals((Object)sb1, (Object)this.allService.getServiceBuilderByName("one"));
        Assert.assertEquals((Object)sb2, (Object)this.allService.getServiceBuilderByName("two"));
        Assert.assertEquals((Object)sb1, (Object)this.allService.findServiceBuilderByNameGlobally("one"));
        Assert.assertEquals((Object)sb2, (Object)this.allService.findServiceBuilderByNameGlobally("two"));
        Assert.assertTrue((boolean)this.allService.removeService(sb1));
        this.assertCompoundServiceAsExpected(1);
        Assert.assertNull((Object)this.allService.getServiceBuilderByName("one"));
        Assert.assertNull((Object)this.allService.findServiceBuilderByNameGlobally("one"));
        Assert.assertEquals((Object)sb2, (Object)this.allService.getServiceBuilderByName("two"));
        Assert.assertEquals((Object)sb2, (Object)this.allService.findServiceBuilderByNameGlobally("two"));
        Assert.assertTrue((boolean)this.allService.removeService((ServiceBuilder)this.odapService));
        Assert.assertNull((Object)this.allService.getServiceBuilderByName(this.odapName));
        Assert.assertNull((Object)this.allService.findServiceBuilderByNameGlobally(this.odapName));
        List serviceBuilders = this.allService.getServiceBuilders();
        Assert.assertFalse((boolean)serviceBuilders.isEmpty());
        Assert.assertEquals((long)3L, (long)serviceBuilders.size());
        Assert.assertEquals((Object)this.wcsService, serviceBuilders.get(0));
        Assert.assertEquals((Object)this.wmsService, serviceBuilders.get(1));
        Assert.assertEquals((Object)sb2, serviceBuilders.get(2));
    }

    @Test
    public void testAddGetReplaceRemoveProperties() {
        String colorPropName = "color";
        String colorPropValue = "red";
        this.odapService.addProperty(colorPropName, colorPropValue);
        String texturePropName = "texture";
        String texturePropValue = "rough";
        this.odapService.addProperty(texturePropName, texturePropValue);
        String tastePropName = "taste";
        String tastePropValue = "sweet";
        this.odapService.addProperty(tastePropName, tastePropValue);
        List propNames = this.odapService.getPropertyNames();
        Assert.assertEquals((long)3L, (long)propNames.size());
        Assert.assertEquals((Object)colorPropName, propNames.get(0));
        Assert.assertEquals((Object)texturePropName, propNames.get(1));
        Assert.assertEquals((Object)tastePropName, propNames.get(2));
        Assert.assertEquals((Object)colorPropValue, (Object)this.odapService.getPropertyValue(colorPropName));
        Assert.assertEquals((Object)texturePropValue, (Object)this.odapService.getPropertyValue(texturePropName));
        Assert.assertEquals((Object)tastePropValue, (Object)this.odapService.getPropertyValue(tastePropName));
        String colorPropNewValue = "orange";
        this.odapService.addProperty(colorPropName, colorPropNewValue);
        Assert.assertEquals((Object)colorPropNewValue, (Object)this.odapService.getPropertyValue(colorPropName));
        Assert.assertTrue((boolean)this.odapService.removeProperty(colorPropName));
        Assert.assertNull((Object)this.odapService.getPropertyValue(colorPropName));
    }

    @Test(expected=IllegalStateException.class)
    public void checkExceptionOnPreBuildGetProperties() {
        this.odapService.getProperties();
    }

    @Test(expected=IllegalStateException.class)
    public void checkExceptionOnPreBuildGetPropertyByNAme() {
        this.odapService.getPropertyByName("name");
    }

    @Test(expected=IllegalStateException.class)
    public void checkExceptionOnPreBuildGetServices() {
        this.odapService.getServices();
    }

    @Test(expected=IllegalStateException.class)
    public void checkExceptionOnPreBuildGetServiceByName() {
        this.odapService.getServiceByName("name");
    }

    @Test
    public void checkBuildAndGet() throws BuilderException {
        this.allService.addProperty("propName1", "propValue1");
        this.allService.addProperty("propName2", "propValue2");
        BuilderIssues issues = this.allService.getIssues();
        Assert.assertTrue((String)issues.toString(), (boolean)issues.isValid());
        Assert.assertTrue((String)issues.toString(), (boolean)issues.isEmpty());
        Service s = this.allService.build();
        Assert.assertNotNull((Object)s);
        Assert.assertTrue((boolean)this.allService.isBuilt());
        Assert.assertEquals((Object)this.allName, (Object)s.getName());
        Assert.assertEquals((Object)this.allType, (Object)s.getType());
        Assert.assertEquals((Object)this.allBaseUri, (Object)s.getBaseUri());
        Assert.assertEquals((Object)this.odapService, (Object)s.getServiceByName(this.odapName));
        Assert.assertEquals((Object)this.wcsService, (Object)s.getServiceByName(this.wcsName));
        Assert.assertEquals((Object)this.wmsService, (Object)s.getServiceByName(this.wmsName));
        Assert.assertEquals((Object)this.odapService, (Object)s.findServiceByNameGlobally(this.odapName));
        Assert.assertEquals((Object)this.wcsService, (Object)s.findServiceByNameGlobally(this.wcsName));
        Assert.assertEquals((Object)this.wmsService, (Object)s.findServiceByNameGlobally(this.wmsName));
        List services = s.getServices();
        Assert.assertFalse((boolean)services.isEmpty());
        Assert.assertEquals((long)3L, (long)services.size());
        Assert.assertEquals((Object)this.odapService, services.get(0));
        Assert.assertEquals((Object)this.wcsService, services.get(1));
        Assert.assertEquals((Object)this.wmsService, services.get(2));
        List propList = s.getProperties();
        Assert.assertEquals((long)2L, (long)propList.size());
        Property prop1 = (Property)propList.get(0);
        Property prop2 = (Property)propList.get(1);
        Assert.assertEquals((Object)"propName1", (Object)prop1.getName());
        Assert.assertEquals((Object)"propName2", (Object)prop2.getName());
        Assert.assertEquals((Object)"propValue1", (Object)prop1.getValue());
        Assert.assertEquals((Object)"propValue2", (Object)prop2.getValue());
    }

    @Test(expected=IllegalStateException.class)
    public void checkExceptionOnPostBuildsetType() throws BuilderException {
        this.allService.build();
        this.allService.setType(this.odapType);
    }

    @Test(expected=IllegalStateException.class)
    public void checkExceptionOnPostBuildSetBaseUri() throws BuilderException {
        this.allService.build();
        this.allService.setBaseUri(this.odapBaseUri);
    }

    @Test(expected=IllegalStateException.class)
    public void checkExceptionOnPostBuildSetDescription() throws BuilderException {
        this.allService.build();
        this.allService.setDescription("desc");
    }

    @Test(expected=IllegalStateException.class)
    public void checkExceptionOnPostBuildSetSuffix() throws BuilderException {
        this.allService.build();
        this.allService.setSuffix(".suffix");
    }

    @Test(expected=IllegalStateException.class)
    public void checkExceptionOnPostBuildAddProperty() throws BuilderException {
        this.allService.build();
        this.allService.addProperty("propName1", "propVal1");
    }

    @Test(expected=IllegalStateException.class)
    public void checkExceptionOnPostBuildAddService() throws BuilderException, URISyntaxException {
        this.allService.build();
        this.allService.addService("newService", ServiceType.FILE, new URI("http://server/thredds/new/"));
    }

    @Test(expected=IllegalStateException.class)
    public void checkExceptionOnPostBuildGetPropertyNames() throws BuilderException {
        this.allService.build();
        this.allService.getPropertyNames();
    }

    @Test(expected=IllegalStateException.class)
    public void checkExceptionOnPostBuildGetPropertyValue() throws BuilderException {
        this.allService.build();
        this.allService.getPropertyValue("name");
    }

    @Test(expected=IllegalStateException.class)
    public void checkExceptionOnPostBuildGetServiceBuilders() throws BuilderException {
        this.allService.build();
        this.allService.getServiceBuilders();
    }

    @Test(expected=IllegalStateException.class)
    public void checkExceptionOnPostBuildGetServiceBuilderByName() throws BuilderException {
        this.allService.build();
        this.allService.getServiceBuilderByName("name");
    }

    @Test
    public void checkBuildIssuesOnCompoundServiceWhenContainingServiceWithNonuniqueName() {
        ServiceBuilder dupService = this.allService.addService(this.odapName, this.wcsType, this.wcsBaseUri);
        BuilderIssues issues = this.allService.getIssues();
        Assert.assertTrue((String)issues.toString(), (boolean)issues.isValid());
        Assert.assertFalse((String)issues.toString(), (boolean)issues.isEmpty());
    }
}

