/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.xml.parser;

import java.io.OutputStream;
import java.io.Reader;
import java.io.StringReader;
import java.net.URI;
import java.util.List;
import org.junit.Assert;
import thredds.catalog.ServiceType;
import thredds.catalog2.Catalog;
import thredds.catalog2.builder.AccessBuilder;
import thredds.catalog2.builder.CatalogBuilder;
import thredds.catalog2.builder.DatasetBuilder;
import thredds.catalog2.builder.DatasetNodeBuilder;
import thredds.catalog2.builder.ServiceBuilder;
import thredds.catalog2.xml.parser.ThreddsXmlParser;
import thredds.catalog2.xml.parser.ThreddsXmlParserException;
import thredds.catalog2.xml.parser.ThreddsXmlParserFactory;
import thredds.catalog2.xml.writer.ThreddsXmlWriter;
import thredds.catalog2.xml.writer.ThreddsXmlWriterException;
import thredds.catalog2.xml.writer.ThreddsXmlWriterFactory;
import ucar.nc2.units.DateType;

public class CatalogXmlUtils {
    private static final String catName = "thredds.catalog2.xml.parser.CatalogXmlUtils";
    private static final String catVersion = "1.0.2";

    private CatalogXmlUtils() {
    }

    public static CatalogBuilder parseCatalogIntoBuilder(URI docBaseUri, String catalogXml) throws ThreddsXmlParserException {
        ThreddsXmlParserFactory fac = ThreddsXmlParserFactory.newFactory();
        ThreddsXmlParser cp = fac.getCatalogParser();
        return cp.parseIntoBuilder((Reader)new StringReader(catalogXml), docBaseUri);
    }

    public static void writeCatalogXml(Catalog cat) {
        ThreddsXmlWriter txw = ThreddsXmlWriterFactory.newInstance().createThreddsXmlWriter();
        try {
            txw.writeCatalog(cat, (OutputStream)System.out);
        }
        catch (ThreddsXmlWriterException e) {
            e.printStackTrace();
            Assert.fail((String)("Failed writing catalog to sout: " + e.getMessage()));
        }
    }

    public static String getCatalog(DateType expires) {
        return CatalogXmlUtils.wrapThreddsXmlInCatalog("", expires);
    }

    public static String wrapThreddsXmlInCatalog(String threddsXml, DateType expires) {
        StringBuilder sb = new StringBuilder().append("<?xml version='1.0' encoding='UTF-8'?>\n").append("<catalog xmlns='http://www.unidata.ucar.edu/namespaces/thredds/InvCatalog/v1.0'\n").append("         xmlns:xlink='http://www.w3.org/1999/xlink'\n");
        if (expires != null) {
            sb.append("         expires='").append(expires.toString()).append("'\n");
        }
        sb.append("         name='").append(catName).append("'\n").append("         version='").append(catVersion).append("'>\n").append(threddsXml).append("</catalog>");
        return sb.toString();
    }

    public static void assertCatalogAsExpected(CatalogBuilder catBuilder, URI docBaseUri, DateType expires) {
        Assert.assertNotNull((String)"DocBase URI is null.", (Object)docBaseUri);
        Assert.assertNotNull((String)("CatalogBuilder [" + docBaseUri + "] is null."), (Object)catBuilder);
        Assert.assertEquals((Object)catBuilder.getDocBaseUri(), (Object)docBaseUri);
        Assert.assertEquals((Object)catBuilder.getName(), (Object)catName);
        if (expires != null) {
            Assert.assertEquals((Object)catBuilder.getExpires().toString(), (Object)expires.toString());
        }
    }

    public static String getCatalogWithService(DateType expires) {
        return CatalogXmlUtils.wrapThreddsXmlInCatalogWithService("", expires);
    }

    public static String wrapThreddsXmlInCatalogWithService(String threddsXml, DateType expires) {
        StringBuilder sb = new StringBuilder().append("  <service name='odap' serviceType='OPENDAP' base='/thredds/dodsC/' />\n").append(threddsXml);
        return CatalogXmlUtils.wrapThreddsXmlInCatalog(sb.toString(), expires);
    }

    public static void assertCatalogWithServiceAsExpected(CatalogBuilder catBuilder, URI docBaseUri, DateType expires) {
        CatalogXmlUtils.assertCatalogAsExpected(catBuilder, docBaseUri, expires);
        List serviceBldrs = catBuilder.getServiceBuilders();
        Assert.assertFalse((boolean)serviceBldrs.isEmpty());
        Assert.assertTrue((serviceBldrs.size() == 1 ? 1 : 0) != 0);
        ServiceBuilder serviceBldr = (ServiceBuilder)serviceBldrs.get(0);
        Assert.assertEquals((Object)serviceBldr.getName(), (Object)"odap");
        Assert.assertEquals((Object)serviceBldr.getType(), (Object)ServiceType.OPENDAP);
        Assert.assertEquals((Object)serviceBldr.getBaseUri().toString(), (Object)"/thredds/dodsC/");
    }

    public static String getCatalogWithCompoundService(DateType expires) {
        return CatalogXmlUtils.wrapThreddsXmlInCatalogWithCompoundService("", expires);
    }

    public static String wrapThreddsXmlInCatalogWithCompoundService(String threddsXml, DateType expires) {
        StringBuilder sb = new StringBuilder().append("  <service name='all' serviceType='Compound' base=''>\n").append("    <service name='odap' serviceType='OPENDAP' base='/thredds/dodsC/' />\n").append("    <service name='wcs' serviceType='WCS' base='/thredds/wcs/' />\n").append("    <service name='wms' serviceType='WMS' base='/thredds/wms/' />\n").append("  </service>\n").append(threddsXml);
        return CatalogXmlUtils.wrapThreddsXmlInCatalog(sb.toString(), expires);
    }

    public static void assertCatalogWithCompoundServiceAsExpected(CatalogBuilder catBuilder, URI docBaseUri, DateType expires) {
        CatalogXmlUtils.assertCatalogAsExpected(catBuilder, docBaseUri, expires);
        List serviceBldrs = catBuilder.getServiceBuilders();
        Assert.assertFalse((boolean)serviceBldrs.isEmpty());
        Assert.assertTrue((serviceBldrs.size() == 1 ? 1 : 0) != 0);
        ServiceBuilder serviceBldr = (ServiceBuilder)serviceBldrs.get(0);
        Assert.assertEquals((Object)serviceBldr.getName(), (Object)"all");
        Assert.assertEquals((Object)serviceBldr.getType(), (Object)ServiceType.COMPOUND);
        Assert.assertEquals((Object)serviceBldr.getBaseUri().toString(), (Object)"");
        serviceBldrs = serviceBldr.getServiceBuilders();
        Assert.assertFalse((boolean)serviceBldrs.isEmpty());
        Assert.assertEquals((long)serviceBldrs.size(), (long)3L);
        serviceBldr = (ServiceBuilder)serviceBldrs.get(0);
        Assert.assertEquals((Object)serviceBldr.getName(), (Object)"odap");
        Assert.assertEquals((Object)serviceBldr.getType(), (Object)ServiceType.OPENDAP);
        Assert.assertEquals((Object)serviceBldr.getBaseUri().toString(), (Object)"/thredds/dodsC/");
        serviceBldr = (ServiceBuilder)serviceBldrs.get(1);
        Assert.assertEquals((Object)serviceBldr.getName(), (Object)"wcs");
        Assert.assertEquals((Object)serviceBldr.getType(), (Object)ServiceType.WCS);
        Assert.assertEquals((Object)serviceBldr.getBaseUri().toString(), (Object)"/thredds/wcs/");
        serviceBldr = (ServiceBuilder)serviceBldrs.get(2);
        Assert.assertEquals((Object)serviceBldr.getName(), (Object)"wms");
        Assert.assertEquals((Object)serviceBldr.getType(), (Object)ServiceType.WMS);
        Assert.assertEquals((Object)serviceBldr.getBaseUri().toString(), (Object)"/thredds/wms/");
    }

    public static String getCatalogWithSingleAccessDatasetWithRawServiceName() {
        StringBuilder sb = new StringBuilder().append("  <dataset name='Test1' urlPath='test/test1.nc'>\n").append("    <serviceName>odap</serviceName>\n").append("  </dataset>\n");
        return CatalogXmlUtils.wrapThreddsXmlInCatalogWithCompoundService(sb.toString(), null);
    }

    public static String getCatalogWithSingleAccessDatasetWithMetadataServiceName() {
        StringBuilder sb = new StringBuilder().append("  <dataset name='Test1' urlPath='test/test1.nc'>\n").append("    <metadata>\n").append("      <serviceName>odap</serviceName>\n").append("    </metadata>\n").append("  </dataset>\n");
        return CatalogXmlUtils.wrapThreddsXmlInCatalogWithCompoundService(sb.toString(), null);
    }

    public static String getCatalogWithSingleAccessDatasetWithInheritedMetadataServiceName() {
        StringBuilder sb = new StringBuilder().append("  <dataset name='Test1' urlPath='test/test1.nc'>\n").append("    <metadata inherited='true'>\n").append("      <serviceName>odap</serviceName>\n").append("    </metadata>\n").append("  </dataset>\n");
        return CatalogXmlUtils.wrapThreddsXmlInCatalogWithCompoundService(sb.toString(), null);
    }

    public static String getCatalogWithSingleAccessDatasetOldStyle() {
        String sb = "<dataset name='Test1' urlPath='test/test1.nc' serviceName='odap' />\n";
        return CatalogXmlUtils.wrapThreddsXmlInCatalogWithCompoundService(sb, null);
    }

    public static void assertCatalogHasSingleAccessDataset(CatalogBuilder catBuilder, URI docBaseUri) {
        CatalogXmlUtils.assertCatalogWithCompoundServiceAsExpected(catBuilder, docBaseUri, null);
        List dsBuilders = catBuilder.getDatasetNodeBuilders();
        Assert.assertTrue((dsBuilders.size() == 1 ? 1 : 0) != 0);
        DatasetNodeBuilder dsnBuilder = (DatasetNodeBuilder)dsBuilders.get(0);
        if (!(dsnBuilder instanceof DatasetBuilder)) {
            Assert.fail((String)("DatasetNode [" + dsnBuilder.getName() + "] not a Dataset."));
            return;
        }
        DatasetBuilder dsBldr = (DatasetBuilder)dsnBuilder;
        List accesses = dsBldr.getAccessBuilders();
        Assert.assertFalse((String)("Dataset [" + dsBldr.getName() + "] not accessible."), (boolean)accesses.isEmpty());
        Assert.assertTrue((accesses.size() == 1 ? 1 : 0) != 0);
        AccessBuilder access = (AccessBuilder)accesses.get(0);
        Assert.assertEquals((Object)access.getUrlPath(), (Object)"test/test1.nc");
        Assert.assertEquals((Object)access.getServiceBuilder().getType(), (Object)ServiceType.OPENDAP);
        Assert.assertEquals((Object)access.getServiceBuilder().getBaseUri().toString(), (Object)"/thredds/dodsC/");
    }

    public static String wrapThreddsXmlInContainerDataset(String threddsXml) {
        StringBuilder sb = new StringBuilder().append("  <dataset name='container dataset' ID='containerDs'>\n").append(threddsXml).append("  </dataset>\n");
        return CatalogXmlUtils.wrapThreddsXmlInCatalogWithCompoundService(sb.toString(), null);
    }

    public static DatasetBuilder assertCatalogWithContainerDatasetAsExpected(CatalogBuilder catBuilder, URI docBaseUri) {
        CatalogXmlUtils.assertCatalogWithCompoundServiceAsExpected(catBuilder, docBaseUri, null);
        List dsBuilders = catBuilder.getDatasetNodeBuilders();
        Assert.assertTrue((dsBuilders.size() == 1 ? 1 : 0) != 0);
        DatasetNodeBuilder dsnBuilder = (DatasetNodeBuilder)dsBuilders.get(0);
        Assert.assertNotNull((Object)dsnBuilder);
        if (!(dsnBuilder instanceof DatasetBuilder)) {
            Assert.fail((String)("DatasetNode [" + dsnBuilder.getName() + "] not a Dataset."));
            return null;
        }
        DatasetBuilder dsBldr = (DatasetBuilder)dsnBuilder;
        Assert.assertFalse((boolean)dsBldr.isAccessible());
        List accesses = dsBldr.getAccessBuilders();
        Assert.assertTrue((boolean)accesses.isEmpty());
        Assert.assertEquals((Object)dsBldr.getName(), (Object)"container dataset");
        Assert.assertEquals((Object)dsBldr.getId(), (Object)"containerDs");
        Assert.assertFalse((boolean)dsBldr.isCollection());
        Assert.assertFalse((boolean)dsBldr.isBuilt());
        return dsBldr;
    }

    public static String wrapThreddsXmlInCatalogDatasetMetadata(String threddsXml) {
        return CatalogXmlUtils.wrapThreddsXmlInContainerDataset("<metadata>" + threddsXml + "</metadata>\n");
    }

    public static String wrapThreddsXmlInCatalogDatasetMetadataInherited(String threddsXml) {
        return CatalogXmlUtils.wrapThreddsXmlInContainerDataset("<metadata inherited='true'>" + threddsXml + "</metadata>\n");
    }

    public static String getNestedDatasetWithRawServiceName() {
        StringBuilder sb = new StringBuilder().append("  <dataset name='ds1'>\n").append("    <serviceName>odap</serviceName>\n").append("    <dataset name='ds2' urlPath='test/test1.nc' />\n").append("  </dataset>\n");
        return CatalogXmlUtils.wrapThreddsXmlInCatalogWithCompoundService(sb.toString(), null);
    }

    public static String getNestedDatasetWithMetadataServiceName() {
        StringBuilder sb = new StringBuilder().append("  <dataset name='ds1'>\n").append("    <metadata><serviceName>odap</serviceName></metadata>\n").append("    <dataset name='ds2' urlPath='test/test1.nc' />\n").append("  </dataset>\n");
        return CatalogXmlUtils.wrapThreddsXmlInCatalogWithCompoundService(sb.toString(), null);
    }

    public static String getNestedDatasetWithUninheritedMetadataServiceName() {
        StringBuilder sb = new StringBuilder().append("  <dataset name='ds1'>\n").append("    <metadata inherited='false'><serviceName>odap</serviceName></metadata>\n").append("    <dataset name='ds2' urlPath='test/test1.nc' />\n").append("  </dataset>\n");
        return CatalogXmlUtils.wrapThreddsXmlInCatalogWithCompoundService(sb.toString(), null);
    }

    public static String getNestedDatasetWithInheritedMetadataServiceName() {
        StringBuilder sb = new StringBuilder().append("  <dataset name='ds1'>\n").append("    <metadata inherited='true'><serviceName>odap</serviceName></metadata>\n").append("    <dataset name='ds2' urlPath='test/test1.nc' />\n").append("  </dataset>\n");
        return CatalogXmlUtils.wrapThreddsXmlInCatalogWithCompoundService(sb.toString(), null);
    }

    public static void assertNestedDatasetIsAccessible(CatalogBuilder catBuilder, URI docBaseUri) {
        DatasetBuilder dsBldr = CatalogXmlUtils.getAndAssertNestedDataset(catBuilder, docBaseUri);
        List accesses = dsBldr.getAccessBuilders();
        Assert.assertFalse((boolean)accesses.isEmpty());
        Assert.assertTrue((accesses.size() == 1 ? 1 : 0) != 0);
        AccessBuilder access = (AccessBuilder)accesses.get(0);
        Assert.assertEquals((Object)access.getUrlPath(), (Object)"test/test1.nc");
        Assert.assertEquals((Object)access.getServiceBuilder().getType(), (Object)ServiceType.OPENDAP);
        Assert.assertEquals((Object)access.getServiceBuilder().getBaseUri().toString(), (Object)"/thredds/dodsC/");
    }

    public static void assertNestedDatasetIsNotAccessible(CatalogBuilder catBuilder, URI docBaseUri) {
        DatasetBuilder dsBldr = CatalogXmlUtils.getAndAssertNestedDataset(catBuilder, docBaseUri);
        List accesses = dsBldr.getAccessBuilders();
        Assert.assertTrue((boolean)accesses.isEmpty());
    }

    public static DatasetBuilder getAndAssertNestedDataset(CatalogBuilder catBuilder, URI docBaseUri) {
        CatalogXmlUtils.assertCatalogWithCompoundServiceAsExpected(catBuilder, docBaseUri, null);
        List dsBuilders = catBuilder.getDatasetNodeBuilders();
        Assert.assertTrue((dsBuilders.size() == 1 ? 1 : 0) != 0);
        DatasetNodeBuilder dsnBuilder = (DatasetNodeBuilder)dsBuilders.get(0);
        dsBuilders = dsnBuilder.getDatasetNodeBuilders();
        Assert.assertTrue((dsBuilders.size() == 1 ? 1 : 0) != 0);
        dsnBuilder = (DatasetNodeBuilder)dsBuilders.get(0);
        if (!(dsnBuilder instanceof DatasetBuilder)) {
            Assert.fail((String)("DatasetNode [" + dsnBuilder.getName() + "] not a Dataset."));
            return null;
        }
        return (DatasetBuilder)dsnBuilder;
    }

    public static String getCatalogWithNestedDatasetInheritedMetadata() {
        StringBuilder sb = new StringBuilder().append("  <dataset name='ds1'>\n").append("    <metadata inherited='true'><serviceName>odap</serviceName></metadata>\n").append("    <dataset name='ds2'>\n").append("      <serviceName>wcs</serviceName>\n").append("      <dataset name='Test1' urlPath='test/test1.nc' />\n").append("      <dataset name='Test2' urlPath='test/test2.nc'>\n").append("        <serviceName>wms</serviceName>\n").append("      </dataset>\n").append("    </dataset>").append("  </dataset>");
        return CatalogXmlUtils.wrapThreddsXmlInCatalogWithCompoundService(sb.toString(), null);
    }
}

