/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.xml.parser;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import org.junit.Assert;
import org.junit.Test;
import thredds.catalog.ServiceType;
import thredds.catalog2.builder.AccessBuilder;
import thredds.catalog2.builder.CatalogBuilder;
import thredds.catalog2.builder.DatasetBuilder;
import thredds.catalog2.xml.parser.CatalogXmlUtils;
import thredds.catalog2.xml.parser.ThreddsXmlParserException;

public class ServiceNameInheritanceTest {
    @Test
    public void checkDatasetWithServiceNameAttribute() throws URISyntaxException, ThreddsXmlParserException {
        String docBaseUriString = "http://test/thredds/catalog2/xml/parser/ServiceNameInheritanceTest/attribute.xml";
        URI docBaseUri = new URI(docBaseUriString);
        String catalogAsString = ServiceNameInheritanceTest.setupDatasetWithServiceNameAttribute();
        CatalogBuilder catBuilder = CatalogXmlUtils.parseCatalogIntoBuilder(docBaseUri, catalogAsString);
        CatalogXmlUtils.assertCatalogWithCompoundServiceAsExpected(catBuilder, docBaseUri, null);
        ServiceNameInheritanceTest.assertDatasetOneHasOdapAccess(catBuilder);
    }

    private static String setupDatasetWithServiceNameAttribute() {
        StringBuilder sb = new StringBuilder().append("<dataset name='ds1' ID='DS1' urlPath='dir/file1.nc' serviceName='odap' />");
        return CatalogXmlUtils.wrapThreddsXmlInCatalogWithCompoundService(sb.toString(), null);
    }

    @Test
    public void checkDatasetWithServiceNameInChildElement() throws URISyntaxException, ThreddsXmlParserException {
        String docBaseUriString = "http://test/thredds/catalog2/xml/parser/ServiceNameInheritanceTest/childElement.xml";
        URI docBaseUri = new URI(docBaseUriString);
        String catalogAsString = ServiceNameInheritanceTest.setupDatasetWithServiceNameInChildElement();
        CatalogBuilder catBuilder = CatalogXmlUtils.parseCatalogIntoBuilder(docBaseUri, catalogAsString);
        CatalogXmlUtils.assertCatalogWithCompoundServiceAsExpected(catBuilder, docBaseUri, null);
        ServiceNameInheritanceTest.assertDatasetOneHasOdapAccess(catBuilder);
    }

    private static String setupDatasetWithServiceNameInChildElement() {
        StringBuilder sb = new StringBuilder().append("<dataset name='ds1' ID='DS1' urlPath='dir/file1.nc'>").append("    <serviceName>odap</serviceName>").append("</dataset>");
        return CatalogXmlUtils.wrapThreddsXmlInCatalogWithCompoundService(sb.toString(), null);
    }

    @Test
    public void checkDatasetWithServiceNameInMetadataElement() throws URISyntaxException, ThreddsXmlParserException {
        String docBaseUriString = "http://test/thredds/catalog2/xml/parser/ServiceNameInheritanceTest/metadataElement.xml";
        URI docBaseUri = new URI(docBaseUriString);
        String catalogAsString = ServiceNameInheritanceTest.setupDatasetWithServiceNameInMetadataElement();
        CatalogBuilder catBuilder = CatalogXmlUtils.parseCatalogIntoBuilder(docBaseUri, catalogAsString);
        CatalogXmlUtils.assertCatalogWithCompoundServiceAsExpected(catBuilder, docBaseUri, null);
        ServiceNameInheritanceTest.assertDatasetOneHasOdapAccess(catBuilder);
    }

    private static String setupDatasetWithServiceNameInMetadataElement() {
        StringBuilder sb = new StringBuilder().append("<dataset name='ds1' ID='DS1' urlPath='dir/file1.nc'>").append("  <metadata>").append("    <serviceName>odap</serviceName>").append("  </metadata>").append("</dataset>");
        return CatalogXmlUtils.wrapThreddsXmlInCatalogWithCompoundService(sb.toString(), null);
    }

    @Test
    public void checkDatasetWithServiceNameInInheritedMetadataElement() throws URISyntaxException, ThreddsXmlParserException {
        String docBaseUriString = "http://test/thredds/catalog2/xml/parser/ServiceNameInheritanceTest/inheritedMetadataElement.xml";
        URI docBaseUri = new URI(docBaseUriString);
        String catalogAsString = ServiceNameInheritanceTest.setupDatasetWithServiceNameInInheritedMetadataElement();
        CatalogBuilder catBuilder = CatalogXmlUtils.parseCatalogIntoBuilder(docBaseUri, catalogAsString);
        CatalogXmlUtils.assertCatalogWithCompoundServiceAsExpected(catBuilder, docBaseUri, null);
        ServiceNameInheritanceTest.assertDatasetOneHasOdapAccess(catBuilder);
    }

    private static String setupDatasetWithServiceNameInInheritedMetadataElement() {
        StringBuilder sb = new StringBuilder().append("<dataset name='ds1' ID='DS1' urlPath='dir/file1.nc'>").append("  <metadata inherited='true'>").append("    <serviceName>odap</serviceName>").append("  </metadata>").append("</dataset>");
        return CatalogXmlUtils.wrapThreddsXmlInCatalogWithCompoundService(sb.toString(), null);
    }

    @Test
    public void checkDatasetNotInheritingServiceNameFromParentAuthorityAttribute() throws URISyntaxException, ThreddsXmlParserException {
        String docBaseUriString = "http://test/thredds/catalog2/xml/parser/ServiceNameInheritanceTest/notInheritAttribute.xml";
        URI docBaseUri = new URI(docBaseUriString);
        String catalogAsString = ServiceNameInheritanceTest.setupDatasetNotInheritingServiceNameFromParentAuthorityAttribute();
        CatalogBuilder catBuilder = CatalogXmlUtils.parseCatalogIntoBuilder(docBaseUri, catalogAsString);
        CatalogXmlUtils.assertCatalogWithCompoundServiceAsExpected(catBuilder, docBaseUri, null);
        ServiceNameInheritanceTest.assertDatasetOneHasOdapAccess(catBuilder);
        ServiceNameInheritanceTest.assertDatasetTwoHasNoAccess(catBuilder);
    }

    private static String setupDatasetNotInheritingServiceNameFromParentAuthorityAttribute() {
        StringBuilder sb = new StringBuilder().append("<dataset name='ds1' ID='DS1' urlPath='dir/file1.nc' serviceName='odap'>").append("  <dataset name='dataset 2' ID='DS2' />").append("</dataset>");
        return CatalogXmlUtils.wrapThreddsXmlInCatalogWithCompoundService(sb.toString(), null);
    }

    @Test
    public void checkDatasetNotInheritingServiceNameFromSiblingServiceElement() throws URISyntaxException, ThreddsXmlParserException {
        String docBaseUriString = "http://test/thredds/catalog2/xml/parser/ServiceNameInheritanceTest/notInheritFromSiblingElement.xml";
        URI docBaseUri = new URI(docBaseUriString);
        String catalogAsString = ServiceNameInheritanceTest.setupDatasetNotInheritingServiceNameFromSiblingServiceElement();
        CatalogBuilder catBuilder = CatalogXmlUtils.parseCatalogIntoBuilder(docBaseUri, catalogAsString);
        CatalogXmlUtils.assertCatalogWithCompoundServiceAsExpected(catBuilder, docBaseUri, null);
        ServiceNameInheritanceTest.assertDatasetOneHasOdapAccess(catBuilder);
        ServiceNameInheritanceTest.assertDatasetTwoHasNoAccess(catBuilder);
    }

    private static String setupDatasetNotInheritingServiceNameFromSiblingServiceElement() {
        StringBuilder sb = new StringBuilder().append("<dataset name='ds1' ID='DS1' urlPath='dir/file1.nc'>").append("    <serviceName>odap</serviceName>").append("  <dataset name='dataset 2' ID='DS2' />").append("</dataset>");
        return CatalogXmlUtils.wrapThreddsXmlInCatalogWithCompoundService(sb.toString(), null);
    }

    @Test
    public void checkDatasetNotInheritingServiceNameFromParentMetadataElement() throws URISyntaxException, ThreddsXmlParserException {
        String docBaseUriString = "http://test/thredds/catalog2/xml/parser/ServiceNameInheritanceTest/notInheritFromParentMetadataElement.xml";
        URI docBaseUri = new URI(docBaseUriString);
        String catalogAsString = ServiceNameInheritanceTest.setupDatasetNotInheritingServiceNameFromParentMetadataElement();
        CatalogBuilder catBuilder = CatalogXmlUtils.parseCatalogIntoBuilder(docBaseUri, catalogAsString);
        CatalogXmlUtils.assertCatalogWithCompoundServiceAsExpected(catBuilder, docBaseUri, null);
        ServiceNameInheritanceTest.assertDatasetOneHasOdapAccess(catBuilder);
        ServiceNameInheritanceTest.assertDatasetTwoHasNoAccess(catBuilder);
    }

    private static String setupDatasetNotInheritingServiceNameFromParentMetadataElement() {
        StringBuilder sb = new StringBuilder().append("<dataset name='ds1' ID='DS1' urlPath='dir/file1.nc'>").append("  <metadata>").append("    <serviceName>odap</serviceName>").append("  </metadata>").append("  <dataset name='dataset 2' ID='DS2' />").append("</dataset>");
        return CatalogXmlUtils.wrapThreddsXmlInCatalogWithCompoundService(sb.toString(), null);
    }

    @Test
    public void checkDatasetInheritingServiceNameFromParentInheritedMetadataElement() throws URISyntaxException, ThreddsXmlParserException {
        String docBaseUriString = "http://test/thredds/catalog2/xml/parser/ServiceNameInheritanceTest/notInheritFromParentInheritedMetadataElement.xml";
        URI docBaseUri = new URI(docBaseUriString);
        String catalogAsString = ServiceNameInheritanceTest.setupDatasetInheritingServiceNameFromParentInheritedMetadataElement();
        CatalogBuilder catBuilder = CatalogXmlUtils.parseCatalogIntoBuilder(docBaseUri, catalogAsString);
        CatalogXmlUtils.assertCatalogWithCompoundServiceAsExpected(catBuilder, docBaseUri, null);
        ServiceNameInheritanceTest.assertDatasetOneHasOdapAccess(catBuilder);
        ServiceNameInheritanceTest.assertDatasetTwoHasOdapAccess(catBuilder);
    }

    private static String setupDatasetInheritingServiceNameFromParentInheritedMetadataElement() {
        StringBuilder sb = new StringBuilder().append("<dataset name='ds1' ID='DS1' urlPath='dir/file1.nc'>").append("  <metadata inherited='true'>").append("    <serviceName>odap</serviceName>").append("  </metadata>").append("  <dataset name='ds2' ID='DS2' urlPath='dir/file2.nc' />").append("</dataset>");
        return CatalogXmlUtils.wrapThreddsXmlInCatalogWithCompoundService(sb.toString(), null);
    }

    @Test
    public void checkDatasetOverridingInheritedServiceNameWithAttribute() throws URISyntaxException, ThreddsXmlParserException {
        String docBaseUriString = "http://test/thredds/catalog2/xml/parser/ServiceNameInheritanceTest/overrideInheritedServiceNameWithAttribute.xml";
        URI docBaseUri = new URI(docBaseUriString);
        String catalogAsString = ServiceNameInheritanceTest.setupDatasetOverridingInheritedServiceNameWithAttribute();
        CatalogBuilder catBuilder = CatalogXmlUtils.parseCatalogIntoBuilder(docBaseUri, catalogAsString);
        CatalogXmlUtils.assertCatalogWithCompoundServiceAsExpected(catBuilder, docBaseUri, null);
        ServiceNameInheritanceTest.assertDatasetOneHasOdapAccess(catBuilder);
        ServiceNameInheritanceTest.assertDatasetTwoHasWcsAccess(catBuilder);
    }

    private static String setupDatasetOverridingInheritedServiceNameWithAttribute() {
        StringBuilder sb = new StringBuilder().append("<dataset name='ds1' ID='DS1' urlPath='dir/file1.nc'>").append("  <metadata inherited='true'>").append("    <serviceName>odap</serviceName>").append("  </metadata>").append("  <dataset name='ds2' ID='DS2' urlPath='dir/file2.nc' serviceName='wcs' />").append("</dataset>");
        return CatalogXmlUtils.wrapThreddsXmlInCatalogWithCompoundService(sb.toString(), null);
    }

    @Test
    public void checkDatasetOverridingInheritedServiceNameWithChildElement() throws URISyntaxException, ThreddsXmlParserException {
        String docBaseUriString = "http://test/thredds/catalog2/xml/parser/ServiceNameInheritanceTest/overrideInheritedServiceNameWithChildElement.xml";
        URI docBaseUri = new URI(docBaseUriString);
        String catalogAsString = ServiceNameInheritanceTest.setupDatasetOverridingInheritedServiceNameWithChildElement();
        CatalogBuilder catBuilder = CatalogXmlUtils.parseCatalogIntoBuilder(docBaseUri, catalogAsString);
        CatalogXmlUtils.assertCatalogWithCompoundServiceAsExpected(catBuilder, docBaseUri, null);
        ServiceNameInheritanceTest.assertDatasetOneHasOdapAccess(catBuilder);
        ServiceNameInheritanceTest.assertDatasetTwoHasWcsAccess(catBuilder);
    }

    private static String setupDatasetOverridingInheritedServiceNameWithChildElement() {
        StringBuilder sb = new StringBuilder().append("<dataset name='ds1' ID='DS1' urlPath='dir/file1.nc'>").append("  <metadata inherited='true'>").append("    <serviceName>odap</serviceName>").append("  </metadata>").append("  <dataset name='ds2' ID='DS2' urlPath='dir/file2.nc'>").append("    <serviceName>wcs</serviceName>").append("  </dataset>").append("</dataset>");
        return CatalogXmlUtils.wrapThreddsXmlInCatalogWithCompoundService(sb.toString(), null);
    }

    @Test
    public void checkDatasetOverridingInheritedServiceNameWithChildMetadataElement() throws URISyntaxException, ThreddsXmlParserException {
        String docBaseUriString = "http://test/thredds/catalog2/xml/parser/ServiceNameInheritanceTest/overrideInheritedServiceNameWithChildMetadataElement.xml";
        URI docBaseUri = new URI(docBaseUriString);
        String catalogAsString = ServiceNameInheritanceTest.setupDatasetOverridingInheritedServiceNameWithChildMetadataElement();
        CatalogBuilder catBuilder = CatalogXmlUtils.parseCatalogIntoBuilder(docBaseUri, catalogAsString);
        CatalogXmlUtils.assertCatalogWithCompoundServiceAsExpected(catBuilder, docBaseUri, null);
        ServiceNameInheritanceTest.assertDatasetOneHasOdapAccess(catBuilder);
        ServiceNameInheritanceTest.assertDatasetTwoHasWcsAccess(catBuilder);
    }

    private static String setupDatasetOverridingInheritedServiceNameWithChildMetadataElement() {
        StringBuilder sb = new StringBuilder().append("<dataset name='ds1' ID='DS1' urlPath='dir/file1.nc'>").append("  <metadata inherited='true'>").append("    <serviceName>odap</serviceName>").append("  </metadata>").append("  <dataset name='ds2' ID='DS2' urlPath='dir/file2.nc'>").append("    <metadata>").append("      <serviceName>wcs</serviceName>").append("    </metadata>").append("  </dataset>").append("</dataset>");
        return CatalogXmlUtils.wrapThreddsXmlInCatalogWithCompoundService(sb.toString(), null);
    }

    @Test
    public void checkDatasetOverridingInheritedServiceWithChildInheritedMetadataElement() throws URISyntaxException, ThreddsXmlParserException {
        String docBaseUriString = "http://test/thredds/catalog2/xml/parser/ServiceNameInheritanceTest/overrideInheritedServiceNameWithChildInheritedMetadataElement.xml";
        URI docBaseUri = new URI(docBaseUriString);
        String catalogAsString = ServiceNameInheritanceTest.setupDatasetOverridingInheritedServiceWithChildInheritedMetadataElement();
        CatalogBuilder catBuilder = CatalogXmlUtils.parseCatalogIntoBuilder(docBaseUri, catalogAsString);
        CatalogXmlUtils.assertCatalogWithCompoundServiceAsExpected(catBuilder, docBaseUri, null);
        ServiceNameInheritanceTest.assertDatasetOneHasOdapAccess(catBuilder);
        ServiceNameInheritanceTest.assertDatasetTwoHasWcsAccess(catBuilder);
    }

    private static String setupDatasetOverridingInheritedServiceWithChildInheritedMetadataElement() {
        StringBuilder sb = new StringBuilder().append("<dataset name='ds1' ID='DS1' urlPath='dir/file1.nc'>").append("  <metadata inherited='true'>").append("    <serviceName>odap</serviceName>").append("  </metadata>").append("  <dataset name='ds2' ID='DS2' urlPath='dir/file2.nc'>").append("    <metadata inherited='true'>").append("      <serviceName>wcs</serviceName>").append("    </metadata>").append("  </dataset>").append("</dataset>");
        return CatalogXmlUtils.wrapThreddsXmlInCatalogWithCompoundService(sb.toString(), null);
    }

    @Test
    public void checkDatasetAccessWithLocalServiceNameAttribute() throws URISyntaxException, ThreddsXmlParserException {
        String docBaseUriString = "http://test/thredds/catalog2/xml/parser/ServiceNameInheritanceTest/dsAccessWithLocalAttribute.xml";
        URI docBaseUri = new URI(docBaseUriString);
        String catalogAsString = ServiceNameInheritanceTest.setupDatasetAccessWithLocalServiceNameAttribute();
        CatalogBuilder catBuilder = CatalogXmlUtils.parseCatalogIntoBuilder(docBaseUri, catalogAsString);
        CatalogXmlUtils.assertCatalogWithCompoundServiceAsExpected(catBuilder, docBaseUri, null);
        ServiceNameInheritanceTest.assertDatasetOneHasOdapAccess(catBuilder);
    }

    private static String setupDatasetAccessWithLocalServiceNameAttribute() {
        StringBuilder sb = new StringBuilder().append("<dataset name='ds1' ID='DS1'>").append("  <access urlPath='dir/file1.nc' serviceName='odap' />").append("</dataset>");
        return CatalogXmlUtils.wrapThreddsXmlInCatalogWithCompoundService(sb.toString(), null);
    }

    @Test
    public void checkDatasetAccessWithParentServiceNameAttribute() throws URISyntaxException, ThreddsXmlParserException {
        String docBaseUriString = "http://test/thredds/catalog2/xml/parser/ServiceNameInheritanceTest/dsAccessWithParentAttribute.xml";
        URI docBaseUri = new URI(docBaseUriString);
        String catalogAsString = ServiceNameInheritanceTest.setupDatasetAccessWithParentServiceNameAttribute();
        CatalogBuilder catBuilder = CatalogXmlUtils.parseCatalogIntoBuilder(docBaseUri, catalogAsString);
        CatalogXmlUtils.assertCatalogWithCompoundServiceAsExpected(catBuilder, docBaseUri, null);
        ServiceNameInheritanceTest.assertDatasetOneHasOdapAccess(catBuilder);
    }

    private static String setupDatasetAccessWithParentServiceNameAttribute() {
        StringBuilder sb = new StringBuilder().append("<dataset name='ds1' ID='DS1' serviceName='odap'>").append("  <access urlPath='dir/file1.nc' />").append("</dataset>");
        return CatalogXmlUtils.wrapThreddsXmlInCatalogWithCompoundService(sb.toString(), null);
    }

    @Test
    public void checkDatasetAccessWithServiceNameElement() throws URISyntaxException, ThreddsXmlParserException {
        String docBaseUriString = "http://test/thredds/catalog2/xml/parser/ServiceNameInheritanceTest/dsAccessWithServiceNameElement.xml";
        URI docBaseUri = new URI(docBaseUriString);
        String catalogAsString = ServiceNameInheritanceTest.setupDatasetAccessWithServiceNameElement();
        CatalogBuilder catBuilder = CatalogXmlUtils.parseCatalogIntoBuilder(docBaseUri, catalogAsString);
        CatalogXmlUtils.assertCatalogWithCompoundServiceAsExpected(catBuilder, docBaseUri, null);
        ServiceNameInheritanceTest.assertDatasetOneHasOdapAccess(catBuilder);
    }

    private static String setupDatasetAccessWithServiceNameElement() {
        StringBuilder sb = new StringBuilder().append("<dataset name='ds1' ID='DS1'>").append("  <serviceName>odap</serviceName>").append("  <access urlPath='dir/file1.nc' />").append("</dataset>");
        return CatalogXmlUtils.wrapThreddsXmlInCatalogWithCompoundService(sb.toString(), null);
    }

    @Test
    public void checkDatasetAccessWithMetadataServiceNameElement() throws URISyntaxException, ThreddsXmlParserException {
        String docBaseUriString = "http://test/thredds/catalog2/xml/parser/ServiceNameInheritanceTest/dsAccessWithMetadataServiceNameElement.xml";
        URI docBaseUri = new URI(docBaseUriString);
        String catalogAsString = ServiceNameInheritanceTest.setupDatasetAccessWithMetadataServiceNameElement();
        CatalogBuilder catBuilder = CatalogXmlUtils.parseCatalogIntoBuilder(docBaseUri, catalogAsString);
        CatalogXmlUtils.assertCatalogWithCompoundServiceAsExpected(catBuilder, docBaseUri, null);
        ServiceNameInheritanceTest.assertDatasetOneHasOdapAccess(catBuilder);
    }

    private static String setupDatasetAccessWithMetadataServiceNameElement() {
        StringBuilder sb = new StringBuilder().append("<dataset name='ds1' ID='DS1'>").append("  <metadata>").append("    <serviceName>odap</serviceName>").append("  </metadata>").append("  <access urlPath='dir/file1.nc' />").append("</dataset>");
        return CatalogXmlUtils.wrapThreddsXmlInCatalogWithCompoundService(sb.toString(), null);
    }

    @Test
    public void checkDatasetAccessWithInheritedMetadataServiceNameElement() throws URISyntaxException, ThreddsXmlParserException {
        String docBaseUriString = "http://test/thredds/catalog2/xml/parser/ServiceNameInheritanceTest/dsAccessWithInheritedMetadataServiceNameElement.xml";
        URI docBaseUri = new URI(docBaseUriString);
        String catalogAsString = ServiceNameInheritanceTest.setupDatasetAccessWithInheritedMetadataServiceNameElement();
        CatalogBuilder catBuilder = CatalogXmlUtils.parseCatalogIntoBuilder(docBaseUri, catalogAsString);
        CatalogXmlUtils.assertCatalogWithCompoundServiceAsExpected(catBuilder, docBaseUri, null);
        ServiceNameInheritanceTest.assertDatasetOneHasOdapAccess(catBuilder);
    }

    private static String setupDatasetAccessWithInheritedMetadataServiceNameElement() {
        StringBuilder sb = new StringBuilder().append("<dataset name='ds1' ID='DS1'>").append("  <metadata inherited='true'>").append("    <serviceName>odap</serviceName>").append("  </metadata>").append("  <access urlPath='dir/file1.nc' />").append("</dataset>");
        return CatalogXmlUtils.wrapThreddsXmlInCatalogWithCompoundService(sb.toString(), null);
    }

    private static void assertDatasetOneHasOdapAccess(CatalogBuilder catBuilder) {
        DatasetBuilder dsBldr = ServiceNameInheritanceTest.assertGetDatasetOne(catBuilder);
        List accessBldrs = dsBldr.getAccessBuilders();
        Assert.assertEquals((long)1L, (long)accessBldrs.size());
        AccessBuilder access = (AccessBuilder)accessBldrs.get(0);
        ServiceNameInheritanceTest.assertOdapAccessToFile1(access);
    }

    private static void assertDatasetTwoHasOdapAccess(CatalogBuilder catBuilder) {
        DatasetBuilder dsBldr = ServiceNameInheritanceTest.assertGetDatasetTwo(catBuilder);
        List accessBldrs = dsBldr.getAccessBuilders();
        Assert.assertEquals((long)1L, (long)accessBldrs.size());
        AccessBuilder access = (AccessBuilder)accessBldrs.get(0);
        ServiceNameInheritanceTest.assertOdapAccessToFile2(access);
    }

    private static void assertDatasetTwoHasWcsAccess(CatalogBuilder catBuilder) {
        DatasetBuilder dsBldr = ServiceNameInheritanceTest.assertGetDatasetTwo(catBuilder);
        List accessBldrs = dsBldr.getAccessBuilders();
        Assert.assertEquals((long)1L, (long)accessBldrs.size());
        AccessBuilder access = (AccessBuilder)accessBldrs.get(0);
        ServiceNameInheritanceTest.assertWcsAccess(access);
    }

    private static void assertDatasetTwoHasNoAccess(CatalogBuilder catBuilder) {
        DatasetBuilder dsBldr = ServiceNameInheritanceTest.assertGetDatasetTwo(catBuilder);
        Assert.assertEquals((long)0L, (long)dsBldr.getAccessBuilders().size());
    }

    private static void assertOdapAccessToFile1(AccessBuilder access) {
        Assert.assertEquals((Object)"dir/file1.nc", (Object)access.getUrlPath());
        Assert.assertEquals((Object)"odap", (Object)access.getServiceBuilder().getName());
        Assert.assertEquals((Object)ServiceType.OPENDAP, (Object)access.getServiceBuilder().getType());
        Assert.assertEquals((Object)"/thredds/dodsC/", (Object)access.getServiceBuilder().getBaseUri().toString());
    }

    private static void assertOdapAccessToFile2(AccessBuilder access) {
        Assert.assertEquals((Object)"dir/file2.nc", (Object)access.getUrlPath());
        Assert.assertEquals((Object)"odap", (Object)access.getServiceBuilder().getName());
        Assert.assertEquals((Object)ServiceType.OPENDAP, (Object)access.getServiceBuilder().getType());
        Assert.assertEquals((Object)"/thredds/dodsC/", (Object)access.getServiceBuilder().getBaseUri().toString());
    }

    private static void assertWcsAccess(AccessBuilder access) {
        Assert.assertEquals((Object)"dir/file2.nc", (Object)access.getUrlPath());
        Assert.assertEquals((Object)"wcs", (Object)access.getServiceBuilder().getName());
        Assert.assertEquals((Object)ServiceType.WCS, (Object)access.getServiceBuilder().getType());
        Assert.assertEquals((Object)"/thredds/wcs/", (Object)access.getServiceBuilder().getBaseUri().toString());
    }

    private static DatasetBuilder assertGetDatasetOne(CatalogBuilder catBuilder) {
        List datasetNodes = catBuilder.getDatasetNodeBuilders();
        Assert.assertEquals((long)1L, (long)datasetNodes.size());
        DatasetBuilder dsBldr = (DatasetBuilder)datasetNodes.get(0);
        Assert.assertEquals((Object)"DS1", (Object)dsBldr.getId());
        return dsBldr;
    }

    private static DatasetBuilder assertGetDatasetTwo(CatalogBuilder catBuilder) {
        DatasetBuilder dsBldr = ServiceNameInheritanceTest.assertGetDatasetOne(catBuilder);
        List datasetNodes = dsBldr.getDatasetNodeBuilders();
        Assert.assertEquals((long)1L, (long)datasetNodes.size());
        dsBldr = (DatasetBuilder)datasetNodes.get(0);
        Assert.assertEquals((Object)"DS2", (Object)dsBldr.getId());
        return dsBldr;
    }
}

