/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.xml.parser.stax;

import java.util.HashMap;
import javax.xml.namespace.QName;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import org.junit.Assert;
import org.junit.Test;
import thredds.catalog2.xml.names.CatalogNamespace;
import thredds.catalog2.xml.parser.ThreddsXmlParserException;
import thredds.catalog2.xml.parser.stax.DateTypeParser;
import thredds.catalog2.xml.parser.stax.StaxParserUtils;

public class DateTypeParserTest {
    @Test
    public void checkCompleteDateElement() throws XMLStreamException, ThreddsXmlParserException {
        String elemName = "date";
        String date = "2009-09-15T12:15";
        String format = "format";
        String type = "type";
        QName elemQualName = new QName(CatalogNamespace.CATALOG_1_0.getNamespaceUri(), elemName);
        String xml = this.getDateTypeElement(elemName, date, format, type);
        this.assertDateTypeXmlAsExpected(elemQualName, date, format, type, xml);
    }

    @Test
    public void checkCompleteAltNamedDateElement() throws XMLStreamException, ThreddsXmlParserException {
        String elemName = "myDate";
        String date = "2009-09-15T12:15";
        String format = "format";
        String type = "type";
        QName elemQualName = new QName(CatalogNamespace.CATALOG_1_0.getNamespaceUri(), elemName);
        String xml = this.getDateTypeElement(elemName, date, format, type);
        this.assertDateTypeXmlAsExpected(elemQualName, date, format, type, xml);
    }

    @Test
    public void checkFormattedDateElement() throws XMLStreamException, ThreddsXmlParserException {
        String elemName = "date";
        String date = "2009-09-15T12:15";
        String format = "format";
        QName elemQualName = new QName(CatalogNamespace.CATALOG_1_0.getNamespaceUri(), elemName);
        String xml = this.getDateTypeElement(elemName, date, format, null);
        this.assertDateTypeXmlAsExpected(elemQualName, date, format, null, xml);
    }

    @Test
    public void checkBareDateElement() throws XMLStreamException, ThreddsXmlParserException {
        String elemName = "date";
        String date = "2009-09-15T12:15";
        QName elemQualName = new QName(CatalogNamespace.CATALOG_1_0.getNamespaceUri(), elemName);
        String xml = this.getDateTypeElement(elemName, date, null, null);
        this.assertDateTypeXmlAsExpected(elemQualName, date, null, null, xml);
    }

    @Test
    public void checkEmptyDateElement() throws XMLStreamException, ThreddsXmlParserException {
        String elemName = "date";
        String format = "format";
        String type = "type";
        QName elemQualName = new QName(CatalogNamespace.CATALOG_1_0.getNamespaceUri(), elemName);
        String xml = this.getDateTypeElement(elemName, null, format, type);
        this.assertDateTypeXmlAsExpected(elemQualName, "", format, type, xml);
    }

    private String getDateTypeElement(String dateElementName, String dateString, String format, String type) {
        HashMap<String, String> attributes = new HashMap<String, String>();
        if (format != null) {
            attributes.put("format", format);
        }
        if (type != null) {
            attributes.put("type", type);
        }
        return StaxParserUtils.wrapContentXmlInXmlDocRootElement(dateElementName, attributes, dateString);
    }

    private void assertDateTypeXmlAsExpected(QName elemName, String date, String format, String type, String xml) throws XMLStreamException, ThreddsXmlParserException {
        XMLEventReader reader = StaxParserUtils.createXmlEventReaderOnXmlString(xml, "http://test.catalog2.thredds/DateTypeParserTest/someTest.xml");
        DateTypeParser.Factory fac = new DateTypeParser.Factory(elemName);
        StaxParserUtils.advanceReaderToFirstStartElement(reader);
        Assert.assertTrue((boolean)fac.isEventMyStartElement(reader.peek()));
        DateTypeParser dateTypeParser = fac.getNewDateTypeParser();
        Assert.assertNotNull((Object)dateTypeParser);
        dateTypeParser.parseElement(reader);
        Assert.assertEquals((Object)date, (Object)dateTypeParser.getValue());
        Assert.assertEquals((Object)format, (Object)dateTypeParser.getFormat());
        Assert.assertEquals((Object)type, (Object)dateTypeParser.getType());
    }
}

