/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.xml.parser.stax;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import thredds.catalog2.builder.CatalogBuilder;
import thredds.catalog2.builder.DatasetBuilder;
import thredds.catalog2.builder.ThreddsBuilderFactory;
import thredds.catalog2.builder.ThreddsMetadataBuilder;
import thredds.catalog2.simpleImpl.ThreddsBuilderFactoryImpl;
import thredds.catalog2.xml.names.ThreddsMetadataElementNames;
import thredds.catalog2.xml.parser.CatalogXmlUtils;
import thredds.catalog2.xml.parser.ThreddsXmlParserException;
import thredds.catalog2.xml.parser.stax.KeyphraseElementParser;
import thredds.catalog2.xml.parser.stax.StaxParserUtils;

public class KeyphraseParserTest {
    private ThreddsBuilderFactory fac;
    private ThreddsMetadataBuilder tmBldr;

    @Before
    public void createMockObjects() {
        this.fac = new ThreddsBuilderFactoryImpl();
        this.tmBldr = this.fac.newThreddsMetadataBuilder();
    }

    @Test
    public void checkParseCompleteKeywordElement() throws XMLStreamException, ThreddsXmlParserException {
        String elemName = ThreddsMetadataElementNames.KeywordElement.getLocalPart();
        String authorityAttName = ThreddsMetadataElementNames.ControlledVocabType_Authority.getLocalPart();
        String authorityAttValue = "GCMD";
        String phrase = "some keyphrase";
        HashMap<String, String> attributes = new HashMap<String, String>();
        if (authorityAttValue != null) {
            attributes.put(authorityAttName, authorityAttValue);
        }
        String xml = StaxParserUtils.wrapContentXmlInXmlDocRootElement(elemName, attributes, phrase);
        XMLEventReader reader = StaxParserUtils.createXmlEventReaderOnXmlString(xml, "http://test.catalog2.thredds/DateTypeParserTest/someTest.xml");
        KeyphraseElementParser.Factory fac = new KeyphraseElementParser.Factory();
        StaxParserUtils.advanceReaderToFirstStartElement(reader);
        Assert.assertTrue((boolean)fac.isEventMyStartElement(reader.peek()));
        KeyphraseElementParser keyphraseParser = fac.getNewParser(reader, this.fac, this.tmBldr);
        ThreddsMetadataBuilder.KeyphraseBuilder keyphraseBldr = (ThreddsMetadataBuilder.KeyphraseBuilder)keyphraseParser.parse();
        Assert.assertNotNull((Object)keyphraseBldr);
        Assert.assertEquals((Object)authorityAttValue, (Object)keyphraseBldr.getAuthority());
        Assert.assertEquals((Object)phrase, (Object)keyphraseBldr.getPhrase());
    }

    @Test
    public void checkCatalogDatasetWrappedKeyphraseElement() throws URISyntaxException, ThreddsXmlParserException {
        String docBaseUriString = "http://cat2.stax.KeyphraseParserTest/checkCatDsWrappedKeyphrase.xml";
        String elemName = ThreddsMetadataElementNames.KeywordElement.getLocalPart();
        String authorityAttName = ThreddsMetadataElementNames.ControlledVocabType_Authority.getLocalPart();
        String authorityAttValue = "GCMD";
        String phrase = "some keyphrase";
        String kpXml = "<" + elemName + " " + authorityAttName + "='" + authorityAttValue + "'>" + phrase + "</" + elemName + ">";
        this.assertCatalogDatasetWrappedKeyphraseAsExpected(docBaseUriString, kpXml, authorityAttValue, phrase);
    }

    private void assertCatalogDatasetWrappedKeyphraseAsExpected(String docBaseUriString, String kpXml, String authority, String phrase) throws URISyntaxException, ThreddsXmlParserException {
        URI docBaseUri = new URI(docBaseUriString);
        String catalogXml = CatalogXmlUtils.wrapThreddsXmlInContainerDataset(kpXml);
        CatalogBuilder catBuilder = CatalogXmlUtils.parseCatalogIntoBuilder(docBaseUri, catalogXml);
        Assert.assertNotNull((Object)catBuilder);
        DatasetBuilder dsBldr = CatalogXmlUtils.assertCatalogWithContainerDatasetAsExpected(catBuilder, docBaseUri);
        ThreddsMetadataBuilder tmdBldr = dsBldr.getThreddsMetadataBuilder();
        tmdBldr.getKeyphraseBuilders();
        List kpBldrs = tmdBldr.getKeyphraseBuilders();
        Assert.assertNotNull((Object)kpBldrs);
        Assert.assertFalse((boolean)kpBldrs.isEmpty());
        Assert.assertEquals((long)1L, (long)kpBldrs.size());
        ThreddsMetadataBuilder.KeyphraseBuilder kpBldr = (ThreddsMetadataBuilder.KeyphraseBuilder)kpBldrs.get(0);
        Assert.assertNotNull((Object)kpBldr);
        Assert.assertEquals((Object)authority, (Object)kpBldr.getAuthority());
        Assert.assertEquals((Object)phrase, (Object)kpBldr.getPhrase());
    }
}

