/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.xml.parser.stax;

import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.stream.XMLStreamException;
import org.junit.Assert;
import org.junit.Test;
import thredds.catalog.DataFormatType;
import thredds.catalog2.ThreddsMetadata;
import thredds.catalog2.builder.CatalogBuilder;
import thredds.catalog2.builder.DatasetBuilder;
import thredds.catalog2.builder.ThreddsMetadataBuilder;
import thredds.catalog2.xml.parser.CatalogXmlUtils;
import thredds.catalog2.xml.parser.ThreddsXmlParserException;
import ucar.nc2.constants.FeatureType;

public class ParseMetadataTest {
    @Test
    public void parseDataFormat() throws URISyntaxException, XMLStreamException, ThreddsXmlParserException {
        String docBaseUriString = "http://cat2.stax.ParseMetadataTest/parseDataFormat.xml";
        String mdXml = "<dataFormat>NEXRAD2</dataFormat>";
        this.parseDataFormatHelper(docBaseUriString, mdXml);
    }

    @Test
    public void parseDataFormatWrapped() throws URISyntaxException, ThreddsXmlParserException {
        String docBaseUriString = "http://cat2.stax.ParseMetadataTest/parseDataFormatWrapped.xml";
        String mdXml = "<metadata><dataFormat>NEXRAD2</dataFormat></metadata>";
        this.parseDataFormatHelper(docBaseUriString, mdXml);
    }

    @Test
    public void parseDataFormatInherited() throws URISyntaxException, ThreddsXmlParserException {
        String docBaseUriString = "http://cat2.stax.ParseMetadataTest/parseDataFormatInherited.xml";
        String mdXml = "<metadata inherited='true'><dataFormat>NEXRAD2</dataFormat></metadata>";
        this.parseDataFormatHelper(docBaseUriString, mdXml);
    }

    private void parseDataFormatHelper(String docBaseUriString, String mdXml) throws URISyntaxException, ThreddsXmlParserException {
        URI docBaseUri = new URI(docBaseUriString);
        String catalogXml = CatalogXmlUtils.wrapThreddsXmlInContainerDataset(mdXml);
        CatalogBuilder catBuilder = CatalogXmlUtils.parseCatalogIntoBuilder(docBaseUri, catalogXml);
        Assert.assertNotNull((Object)catBuilder);
        DatasetBuilder dsBldr = CatalogXmlUtils.assertCatalogWithContainerDatasetAsExpected(catBuilder, docBaseUri);
        ThreddsMetadataBuilder tmdBldr = dsBldr.getThreddsMetadataBuilder();
        DataFormatType dataFormat = tmdBldr.getDataFormat();
        Assert.assertEquals((Object)dataFormat, (Object)DataFormatType.NEXRAD2);
    }

    @Test
    public void parseDataType() throws URISyntaxException, XMLStreamException, ThreddsXmlParserException {
        String docBaseUriString = "http://cat2.stax.ParseMetadataTest/parseDataType.xml";
        String mdXml = "<dataType>Radial</dataType>";
        this.parseDataTypeHelper(docBaseUriString, mdXml);
    }

    private void parseDataTypeHelper(String docBaseUriString, String mdXml) throws URISyntaxException, ThreddsXmlParserException {
        URI docBaseUri = new URI(docBaseUriString);
        String catalogXml = CatalogXmlUtils.wrapThreddsXmlInContainerDataset(mdXml);
        CatalogBuilder catBuilder = CatalogXmlUtils.parseCatalogIntoBuilder(docBaseUri, catalogXml);
        Assert.assertNotNull((Object)catBuilder);
        DatasetBuilder dsBldr = CatalogXmlUtils.assertCatalogWithContainerDatasetAsExpected(catBuilder, docBaseUri);
        ThreddsMetadataBuilder tmdBldr = dsBldr.getThreddsMetadataBuilder();
        FeatureType dataType = tmdBldr.getDataType();
        Assert.assertEquals((Object)dataType, (Object)FeatureType.RADIAL);
    }

    @Test
    public void checkCreateDate() throws URISyntaxException, ThreddsXmlParserException {
        String docBaseUriString = "http://cat2.stax.ParseMetadataTest/parseCreatedDate.xml";
        URI docBaseUri = new URI(docBaseUriString);
        String date = "2009-08-25T12:00";
        String type = ThreddsMetadata.DatePointType.Created.toString();
        String mdXml = "<date type='" + type + "'>" + date + "</date>";
        String catalogXml = CatalogXmlUtils.wrapThreddsXmlInContainerDataset(mdXml);
        CatalogBuilder catBuilder = CatalogXmlUtils.parseCatalogIntoBuilder(docBaseUri, catalogXml);
        Assert.assertNotNull((Object)catBuilder);
        DatasetBuilder dsBldr = CatalogXmlUtils.assertCatalogWithContainerDatasetAsExpected(catBuilder, docBaseUri);
        ThreddsMetadataBuilder tmdBldr = dsBldr.getThreddsMetadataBuilder();
        ThreddsMetadataBuilder.DatePointBuilder datePointBuilder = tmdBldr.getCreatedDatePointBuilder();
        Assert.assertEquals((Object)datePointBuilder.getDate(), (Object)date);
        Assert.assertNull((Object)datePointBuilder.getDateFormat());
        Assert.assertEquals((Object)ThreddsMetadata.DatePointType.getTypeForLabel((String)datePointBuilder.getType()), (Object)ThreddsMetadata.DatePointType.Created);
    }
}

