/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.xml.parser.stax;

import java.net.URI;
import java.net.URISyntaxException;
import javax.xml.stream.XMLStreamException;
import org.junit.Assert;
import org.junit.Test;
import thredds.catalog.DataFormatType;
import thredds.catalog2.builder.CatalogBuilder;
import thredds.catalog2.builder.DatasetBuilder;
import thredds.catalog2.builder.ThreddsMetadataBuilder;
import thredds.catalog2.xml.parser.CatalogXmlUtils;
import thredds.catalog2.xml.parser.ThreddsXmlParserException;

public class ParseThreddsMetadataCreatedDate {
    @Test
    public void parseDataFormat() throws URISyntaxException, XMLStreamException, ThreddsXmlParserException {
        String docBaseUriString = "http://cat2.stax.ParseMetadataTest/parseDataFormat.xml";
        String mdXml = "<dataFormat>NEXRAD2</dataFormat>";
        this.parseDataFormatHelper(docBaseUriString, mdXml);
    }

    @Test
    public void parseDataFormatWrapped() throws URISyntaxException, ThreddsXmlParserException {
        String docBaseUriString = "http://cat2.stax.ParseMetadataTest/parseDataFormatWrapped.xml";
        String mdXml = "<metadata><dataFormat>NEXRAD2</dataFormat></metadata>";
        this.parseDataFormatHelper(docBaseUriString, mdXml);
    }

    @Test
    public void parseDataFormatInherited() throws URISyntaxException, ThreddsXmlParserException {
        String docBaseUriString = "http://cat2.stax.ParseMetadataTest/parseDataFormatInherited.xml";
        String mdXml = "<metadata inherited='true'><dataFormat>NEXRAD2</dataFormat></metadata>";
        this.parseDataFormatHelper(docBaseUriString, mdXml);
    }

    private void assertCreatDateAsExpected(ThreddsMetadataBuilder.DatePointBuilder datePointBuilder) {
    }

    private void parseDataFormatHelper(String docBaseUriString, String mdXml) throws URISyntaxException, ThreddsXmlParserException {
        URI docBaseUri = new URI(docBaseUriString);
        String catalogXml = CatalogXmlUtils.wrapThreddsXmlInContainerDataset(mdXml);
        CatalogBuilder catBuilder = CatalogXmlUtils.parseCatalogIntoBuilder(docBaseUri, catalogXml);
        Assert.assertNotNull((Object)catBuilder);
        DatasetBuilder dsBldr = CatalogXmlUtils.assertCatalogWithContainerDatasetAsExpected(catBuilder, docBaseUri);
        ThreddsMetadataBuilder tmdBldr = dsBldr.getThreddsMetadataBuilder();
        DataFormatType dataFormat = tmdBldr.getDataFormat();
        Assert.assertEquals((Object)dataFormat, (Object)DataFormatType.NEXRAD2);
    }
}

