/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.xml.parser.stax;

import java.net.URI;
import java.net.URISyntaxException;
import java.util.HashMap;
import java.util.List;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import thredds.catalog2.builder.CatalogBuilder;
import thredds.catalog2.builder.DatasetBuilder;
import thredds.catalog2.builder.ThreddsBuilderFactory;
import thredds.catalog2.builder.ThreddsMetadataBuilder;
import thredds.catalog2.simpleImpl.ThreddsBuilderFactoryImpl;
import thredds.catalog2.xml.names.ThreddsMetadataElementNames;
import thredds.catalog2.xml.parser.CatalogXmlUtils;
import thredds.catalog2.xml.parser.ThreddsXmlParserException;
import thredds.catalog2.xml.parser.stax.ProjectElementParser;
import thredds.catalog2.xml.parser.stax.StaxParserUtils;

public class ProjectParserTest {
    private ThreddsBuilderFactory fac;
    private ThreddsMetadataBuilder tmBldr;

    @Before
    public void createMockObjects() {
        this.fac = new ThreddsBuilderFactoryImpl();
        this.tmBldr = this.fac.newThreddsMetadataBuilder();
    }

    @Test
    public void checkParseCompleteProjectElement() throws XMLStreamException, ThreddsXmlParserException {
        String docBaseUriString = "http://test.catalog2.thredds/ProjectParserTest/completeProjectElement.xml";
        String elemName = ThreddsMetadataElementNames.ProjectElement.getLocalPart();
        String authorityAttName = ThreddsMetadataElementNames.ControlledVocabType_Authority.getLocalPart();
        String authorityAttValue = "GCMD";
        String projName = "some proj name";
        HashMap<String, String> attributes = new HashMap<String, String>();
        if (authorityAttValue != null) {
            attributes.put(authorityAttName, authorityAttValue);
        }
        String xml = StaxParserUtils.wrapContentXmlInXmlDocRootElement(elemName, attributes, projName);
        XMLEventReader reader = StaxParserUtils.createXmlEventReaderOnXmlString(xml, docBaseUriString);
        ProjectElementParser.Factory fac = new ProjectElementParser.Factory();
        StaxParserUtils.advanceReaderToFirstStartElement(reader);
        Assert.assertTrue((boolean)fac.isEventMyStartElement(reader.peek()));
        ProjectElementParser projectNameParser = fac.getNewParser(reader, this.fac, this.tmBldr);
        ThreddsMetadataBuilder.ProjectNameBuilder projNameBldr = (ThreddsMetadataBuilder.ProjectNameBuilder)projectNameParser.parse();
        Assert.assertNotNull((Object)projNameBldr);
        Assert.assertEquals((Object)authorityAttValue, (Object)projNameBldr.getNamingAuthority());
        Assert.assertEquals((Object)projName, (Object)projNameBldr.getName());
    }

    @Test
    public void checkCatalogDatasetWrappedProjectElement() throws URISyntaxException, ThreddsXmlParserException {
        String docBaseUriString = "http://test.catalog2.thredds/ProjectParserTest/wrappedProjectElement.xml";
        String elemName = ThreddsMetadataElementNames.ProjectElement.getLocalPart();
        String authorityAttName = ThreddsMetadataElementNames.ControlledVocabType_Authority.getLocalPart();
        String authorityAttValue = "GCMD";
        String projName = "some proj name";
        String kpXml = "<" + elemName + " " + authorityAttName + "='" + authorityAttValue + "'>" + projName + "</" + elemName + ">";
        this.assertCatalogDatasetWrappedProjectNameAsExpected(docBaseUriString, kpXml, authorityAttValue, projName);
    }

    private void assertCatalogDatasetWrappedProjectNameAsExpected(String docBaseUriString, String kpXml, String authority, String projName) throws URISyntaxException, ThreddsXmlParserException {
        URI docBaseUri = new URI(docBaseUriString);
        String catalogXml = CatalogXmlUtils.wrapThreddsXmlInContainerDataset(kpXml);
        CatalogBuilder catBuilder = CatalogXmlUtils.parseCatalogIntoBuilder(docBaseUri, catalogXml);
        Assert.assertNotNull((Object)catBuilder);
        DatasetBuilder dsBldr = CatalogXmlUtils.assertCatalogWithContainerDatasetAsExpected(catBuilder, docBaseUri);
        ThreddsMetadataBuilder tmdBldr = dsBldr.getThreddsMetadataBuilder();
        Assert.assertNotNull((Object)tmdBldr);
        List projNameBldrs = tmdBldr.getProjectNameBuilders();
        Assert.assertNotNull((Object)projNameBldrs);
        Assert.assertFalse((boolean)projNameBldrs.isEmpty());
        Assert.assertEquals((long)1L, (long)projNameBldrs.size());
        ThreddsMetadataBuilder.ProjectNameBuilder projNameBldr = (ThreddsMetadataBuilder.ProjectNameBuilder)projNameBldrs.get(0);
        Assert.assertNotNull((Object)projNameBldr);
        Assert.assertEquals((Object)authority, (Object)projNameBldr.getNamingAuthority());
        Assert.assertEquals((Object)projName, (Object)projNameBldr.getName());
    }
}

