/*
 * Decompiled with CFR 0.152.
 */
package thredds.catalog2.xml.parser.stax;

import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLStreamException;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import thredds.catalog2.builder.ThreddsBuilder;
import thredds.catalog2.builder.ThreddsBuilderFactory;
import thredds.catalog2.builder.ThreddsMetadataBuilder;
import thredds.catalog2.simpleImpl.ThreddsBuilderFactoryImpl;
import thredds.catalog2.xml.parser.ThreddsXmlParserException;
import thredds.catalog2.xml.parser.stax.StaxParserUtils;
import thredds.catalog2.xml.parser.stax.TimeCoverageElementParser;

public class TimeCoverageElementParserTest {
    private ThreddsBuilderFactory fac;
    private ThreddsMetadataBuilder tmBldr;

    @Before
    public void createMockObjects() {
        this.fac = new ThreddsBuilderFactoryImpl();
        this.tmBldr = this.fac.newThreddsMetadataBuilder();
    }

    @Test
    public void checkFullySpecifiedTimeCoverageElement() throws XMLStreamException, ThreddsXmlParserException {
        String elemName = "timeCoverage";
        String startDate = "2009-09-17T12:00";
        String endDate = "2009-09-18T00:00";
        String duration = "12 hours";
        String resolution = "1 hours";
        StringBuilder sb = new StringBuilder().append("  <start>").append(startDate).append("</start>\n").append("  <end>").append(endDate).append("</end>\n").append("  <duration>").append(duration).append("</duration>\n").append("  <resolution>").append(resolution).append("</resolution>\n");
        String xml = StaxParserUtils.wrapContentXmlInXmlDocRootElement(elemName, null, sb.toString());
        this.assertDateTypeXmlAsExpected(startDate, endDate, duration, resolution, xml);
    }

    @Test
    public void checkFullySpecifiedNoResolutionTimeCoverageElement() throws XMLStreamException, ThreddsXmlParserException {
        String elemName = "timeCoverage";
        String startDate = "2009-09-17T12:00";
        String endDate = "2009-09-18T00:00";
        String duration = "12 hours";
        StringBuilder sb = new StringBuilder().append("  <start>").append(startDate).append("</start>\n").append("  <end>").append(endDate).append("</end>\n").append("  <duration>").append(duration).append("</duration>\n");
        String xml = StaxParserUtils.wrapContentXmlInXmlDocRootElement(elemName, null, sb.toString());
        this.assertDateTypeXmlAsExpected(startDate, endDate, duration, null, xml);
    }

    @Test
    public void checkNoDurationTimeCoverageElement() throws XMLStreamException, ThreddsXmlParserException {
        String elemName = "timeCoverage";
        String startDate = "2009-09-17T12:00";
        String endDate = "2009-09-18T00:00";
        String resolution = "1 hours";
        StringBuilder sb = new StringBuilder().append("  <start>").append(startDate).append("</start>\n").append("  <end>").append(endDate).append("</end>\n").append("  <resolution>").append(resolution).append("</resolution>\n");
        String xml = StaxParserUtils.wrapContentXmlInXmlDocRootElement(elemName, null, sb.toString());
        this.assertDateTypeXmlAsExpected(startDate, endDate, null, resolution, xml);
    }

    @Test
    public void checkNoEndTimeCoverageElement() throws XMLStreamException, ThreddsXmlParserException {
        String elemName = "timeCoverage";
        String startDate = "2009-09-17T12:00";
        String duration = "12 hours";
        String resolution = "1 hours";
        StringBuilder sb = new StringBuilder().append("  <start>").append(startDate).append("</start>\n").append("  <duration>").append(duration).append("</duration>\n").append("  <resolution>").append(resolution).append("</resolution>\n");
        String xml = StaxParserUtils.wrapContentXmlInXmlDocRootElement(elemName, null, sb.toString());
        this.assertDateTypeXmlAsExpected(startDate, null, duration, resolution, xml);
    }

    @Test
    public void checkNoStartSpecifiedTimeCoverageElement() throws XMLStreamException, ThreddsXmlParserException {
        String elemName = "timeCoverage";
        String endDate = "present";
        String duration = "12 days";
        String resolution = "1 hours";
        StringBuilder sb = new StringBuilder().append("  <end>").append(endDate).append("</end>\n").append("  <duration>").append(duration).append("</duration>\n").append("  <resolution>").append(resolution).append("</resolution>\n");
        String xml = StaxParserUtils.wrapContentXmlInXmlDocRootElement(elemName, null, sb.toString());
        this.assertDateTypeXmlAsExpected(null, endDate, duration, resolution, xml);
    }

    private void assertDateTypeXmlAsExpected(String startDate, String endDate, String duration, String resolution, String xml) throws XMLStreamException, ThreddsXmlParserException {
        XMLEventReader reader = StaxParserUtils.createXmlEventReaderOnXmlString(xml, "http://test.catalog2.thredds/DateTypeParserTest/someTest.xml");
        StaxParserUtils.advanceReaderToFirstStartElement(reader);
        TimeCoverageElementParser.Factory timeCovParserFactory = new TimeCoverageElementParser.Factory();
        Assert.assertTrue((boolean)timeCovParserFactory.isEventMyStartElement(reader.peek()));
        TimeCoverageElementParser parser = timeCovParserFactory.getNewParser(reader, this.fac, this.tmBldr);
        ThreddsBuilder bldr = parser.parse();
        Assert.assertNotNull((Object)bldr);
        Assert.assertTrue((boolean)(bldr instanceof ThreddsMetadataBuilder.DateRangeBuilder));
        ThreddsMetadataBuilder.DateRangeBuilder tmBldr = (ThreddsMetadataBuilder.DateRangeBuilder)bldr;
        Assert.assertEquals((Object)startDate, (Object)tmBldr.getStartDate());
        Assert.assertNull((Object)tmBldr.getStartDateFormat());
        Assert.assertEquals((Object)endDate, (Object)tmBldr.getEndDate());
        Assert.assertNull((Object)tmBldr.getEndDateFormat());
        Assert.assertEquals((Object)duration, (Object)tmBldr.getDuration());
        Assert.assertEquals((Object)resolution, (Object)tmBldr.getResolution());
    }
}

