/*
 * Decompiled with CFR 0.152.
 */
package thredds.cataloggen;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvService;
import thredds.cataloggen.CatGenAndWrite;
import thredds.crawlabledataset.CrawlableDataset;
import thredds.crawlabledataset.CrawlableDatasetFile;
import thredds.crawlabledataset.CrawlableDatasetFilter;
import ucar.nc2.TestAll;
import ucar.unidata.util.TestFileDirUtils;

public class TestCatGenAndWrite
extends TestCase {
    private File tmpDir;

    public TestCatGenAndWrite(String name) {
        super(name);
    }

    protected void setUp() {
        this.tmpDir = TestFileDirUtils.addDirectory(new File(TestAll.temporaryLocalDataDir), "TestCatGenAndWrite");
    }

    protected void tearDown() {
        TestFileDirUtils.deleteDirectoryAndContent(this.tmpDir);
    }

    public void testLocalDataFiles() {
        String startPath = "dataDir";
        File dataDir = TestFileDirUtils.addDirectory(this.tmpDir, startPath);
        File eta211Dir = TestFileDirUtils.addDirectory(dataDir, "eta_211");
        TestFileDirUtils.addFile(eta211Dir, "2004050300_eta_211.nc");
        TestFileDirUtils.addFile(eta211Dir, "2004050312_eta_211.nc");
        TestFileDirUtils.addFile(eta211Dir, "2004050400_eta_211.nc");
        TestFileDirUtils.addFile(eta211Dir, "2004050412_eta_211.nc");
        File gfs211Dir = TestFileDirUtils.addDirectory(dataDir, "gfs_211");
        TestFileDirUtils.addFile(gfs211Dir, "2004050300_gfs_211.nc");
        TestFileDirUtils.addFile(gfs211Dir, "2004050306_gfs_211.nc");
        TestFileDirUtils.addFile(gfs211Dir, "2004050312_gfs_211.nc");
        TestFileDirUtils.addFile(gfs211Dir, "2004050318_gfs_211.nc");
        File catWriteDir = new File(this.tmpDir, "catWriteDir");
        CrawlableDatasetFile collectionCrDs = new CrawlableDatasetFile(this.tmpDir);
        InvService service = new InvService("myServer", "File", collectionCrDs.getPath() + "/", null, null);
        CrawlableDatasetFilter filter = null;
        CrawlableDataset topCatCrDs = collectionCrDs.getDescendant(startPath);
        CatGenAndWrite cgaw = null;
        try {
            cgaw = new CatGenAndWrite("DATA", "My data", "", service, (CrawlableDataset)collectionCrDs, topCatCrDs, filter, null, catWriteDir);
        }
        catch (IllegalArgumentException e) {
            TestCatGenAndWrite.fail((String)("Bad argument: " + e.getMessage()));
            return;
        }
        try {
            cgaw.genAndWriteCatalogTree();
        }
        catch (IOException e) {
            TestCatGenAndWrite.fail((String)("I/O error generating and writing catalogs at and under \"" + topCatCrDs.getPath() + "\": " + e.getMessage()));
            return;
        }
        this.crawlCatalogs(new File(new File(catWriteDir, startPath), "catalog.xml"));
    }

    public void testLocalDataFilesOnTds() {
        String startPath = "dataDir";
        File dataDir = TestFileDirUtils.addDirectory(this.tmpDir, startPath);
        File eta211Dir = TestFileDirUtils.addDirectory(dataDir, "eta_211");
        TestFileDirUtils.addFile(eta211Dir, "2004050300_eta_211.nc");
        TestFileDirUtils.addFile(eta211Dir, "2004050312_eta_211.nc");
        TestFileDirUtils.addFile(eta211Dir, "2004050400_eta_211.nc");
        TestFileDirUtils.addFile(eta211Dir, "2004050412_eta_211.nc");
        File gfs211Dir = TestFileDirUtils.addDirectory(dataDir, "gfs_211");
        TestFileDirUtils.addFile(gfs211Dir, "2004050300_gfs_211.nc");
        TestFileDirUtils.addFile(gfs211Dir, "2004050306_gfs_211.nc");
        TestFileDirUtils.addFile(gfs211Dir, "2004050312_gfs_211.nc");
        TestFileDirUtils.addFile(gfs211Dir, "2004050318_gfs_211.nc");
        File catWriteDir = new File(this.tmpDir, "catWriteDir");
        CrawlableDatasetFile collectionCrDs = new CrawlableDatasetFile(this.tmpDir);
        InvService service = new InvService("myServer", "OPeNDAP", "/thredds/dodsC/", null, null);
        CrawlableDatasetFilter filter = null;
        CrawlableDataset topCatCrDs = collectionCrDs.getDescendant(startPath);
        CatGenAndWrite cgaw = null;
        try {
            cgaw = new CatGenAndWrite("DATA", "My data", "tdr", service, (CrawlableDataset)collectionCrDs, topCatCrDs, filter, null, catWriteDir);
        }
        catch (IllegalArgumentException e) {
            TestCatGenAndWrite.fail((String)("Bad argument: " + e.getMessage()));
            return;
        }
        try {
            cgaw.genAndWriteCatalogTree();
        }
        catch (IOException e) {
            TestCatGenAndWrite.fail((String)("I/O error generating and writing catalogs at and under \"" + topCatCrDs.getPath() + "\": " + e.getMessage()));
            return;
        }
        this.crawlCatalogs(new File(new File(catWriteDir, startPath), "catalog.xml"));
    }

    private void crawlCatalogs(File topCatalogFile) {
        InvCatalogFactory fac = InvCatalogFactory.getDefaultFactory((boolean)false);
        InvCatalogImpl topCatalog = fac.readXML(topCatalogFile.toURI());
    }
}

