/*
 * Decompiled with CFR 0.152.
 */
package thredds.cataloggen;

import java.io.BufferedInputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import java.io.InputStream;
import java.net.MalformedURLException;
import java.net.URI;
import java.net.URISyntaxException;
import junit.framework.TestCase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.InvCatalog;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.cataloggen.CatalogGen;

public class TestCatalogGen
extends TestCase {
    private static Logger log = LoggerFactory.getLogger(TestCatalogGen.class);
    private String configResourcePath = "/thredds/cataloggen/config";
    private String test1CatGenConf_0_6_ResourceName = "test1CatGenConfig0.6.xml";
    private String test1CatGenConf_1_0_ResourceName = "test1CatGenConfig1.0.xml";
    private String test1ResultCatalog_0_6_ResourceName = "test1ResultCatalog0.6.xml";
    private String test1ResultCatalog_1_0_ResourceName = "test1ResultCatalog1.0.xml";
    private String test1Catalog_0_6File = "test1Catalog0.6.ToFile.xml";
    private String test1Catalog_1_0File = "test1Catalog1.0.ToFile.xml";
    private String test2CatGenConf_0_6_ResourceName = "test2CatGenConfig0.6.xml";
    private String test2CatGenConf_1_0_ResourceName = "test2CatGenConfig1.0.xml";
    private String test2Catalog_0_6File = "test2Catalog0.6.ToFile.xml";
    private String test2Catalog_1_0File = "test2Catalog1.0.ToFile.xml";
    private String test2ResultCatalog_0_6_ResourceName = "test2ResultCatalog0.6.xml";
    private String test2ResultCatalog_1_0_ResourceName = "test2ResultCatalog1.0.xml";
    private String test3CatGenConf_0_6_ResourceName = "test3CatGenConfig0.6.xml";
    private String test3ResultCatalog_0_6_ResourceName = "test3ResultCatalog0.6.xml";
    private String test3Catalog_0_6File = "test3Catalog0.6.ToFile.xml";
    private CatalogGen me;
    private InvCatalogFactory factory;
    private InvCatalogImpl justWrittenCatalog;
    private boolean displayComparedCatalogs = false;

    public TestCatalogGen(String name) {
        super(name);
    }

    protected void setUp() {
        this.factory = new InvCatalogFactory("default", true);
    }

    public void testCreateCatalogRefs() {
        String configDocName = "src/test/data/thredds/cataloggen/testCatGen.createCatalogRefs.xml";
        String expectedDocResourceName = "/thredds/cataloggen/testCatGen.createCatalogRefs.result.xml";
        this.expandConfigDoc(configDocName);
        TestCatalogGen.compareCatalogToCatalogResource(this.me.getCatalog(), expectedDocResourceName, this.displayComparedCatalogs);
    }

    public void testRejectFilter() {
        String configDocName = "src/test/data/thredds/cataloggen/testCatGen.rejectFilter.xml";
        String expectedDocResourceName = "/thredds/cataloggen/testCatGen.rejectFilter.result.xml";
        this.expandConfigDoc(configDocName);
        TestCatalogGen.compareCatalogToCatalogResource(this.me.getCatalog(), expectedDocResourceName, this.displayComparedCatalogs);
    }

    public void testDirTreeInvCat1_0() {
        String configDocName = "src/test/data/thredds/cataloggen/testCatGen.dirTree.InvCat1.0.xml";
        String expectedDocResourceName = "/thredds/cataloggen/testCatGen.dirTree.InvCat1.0.result.xml";
        this.expandConfigDoc(configDocName);
        TestCatalogGen.compareCatalogToCatalogResource(this.me.getCatalog(), expectedDocResourceName, this.displayComparedCatalogs);
    }

    public void testUahRadarLevelII() {
        String configDocName = "src/test/data/thredds/cataloggen/testCatGen.uahRadarLevelII.xml";
        String expectedDocResourceName = "/thredds/cataloggen/testCatGen.uahRadarLevelII.result.xml";
        this.expandConfigDoc(configDocName);
        TestCatalogGen.compareCatalogToCatalogResource(this.me.getCatalog(), expectedDocResourceName, this.displayComparedCatalogs);
    }

    public void testBadAccessPoint() {
        String configDocName = "src/test/data/thredds/cataloggen/testCatGen.badAccessPoint.xml";
        String expectedDocResourceName = "/thredds/cataloggen/testCatGen.badAccessPoint.result.xml";
        this.expandConfigDoc(configDocName);
        TestCatalogGen.compareCatalogToCatalogResource(this.me.getCatalog(), expectedDocResourceName, this.displayComparedCatalogs);
    }

    public void testExpandTest1InvCat_1_0() {
        String catGenConfResourceName = this.configResourcePath + "/" + this.test1CatGenConf_1_0_ResourceName;
        String expectedCatalogResourceName = this.configResourcePath + "/" + this.test1ResultCatalog_1_0_ResourceName;
        log.debug("testExpandTest1InvCat_1_0(): expand catalog <" + catGenConfResourceName + "> and compare to expected catalog <" + expectedCatalogResourceName + ">.");
        this.expandCatalogGenTest(catGenConfResourceName, expectedCatalogResourceName);
        log.debug("testExpandTest1InvCat_1_0(): compare expanded catalog to itself after writing to and reading from a file.");
        String expandedCatalogFileName = this.test1Catalog_1_0File;
        this.writeCatalogGenTest(expandedCatalogFileName);
    }

    public void testExpandTest2InvCat_1_0() {
        String catGenConfResourceName = this.configResourcePath + "/" + this.test2CatGenConf_1_0_ResourceName;
        String expectedCatalogResourceName = this.configResourcePath + "/" + this.test2ResultCatalog_1_0_ResourceName;
        log.debug("testExpandTest2InvCat_1_0(): expand catalog <" + catGenConfResourceName + "> and compare to expected catalog <" + expectedCatalogResourceName + ">.");
        this.expandCatalogGenTest(catGenConfResourceName, expectedCatalogResourceName);
        log.debug("testExpandTest2InvCat_1_0(): compare expanded catalog to itself after writing to and reading from a file.");
        String expandedCatalogFileName = this.test2Catalog_1_0File;
        this.writeCatalogGenTest(expandedCatalogFileName);
    }

    private void expandCatalogGenTest(String catGenConfResourceName, String expectedCatalogResourceName) {
        String tmpMsg = null;
        String catGenConfURIName = "http://TestCatalogGen.resource" + catGenConfResourceName;
        URI catGenConfURI = null;
        try {
            catGenConfURI = new URI(catGenConfURIName);
        }
        catch (URISyntaxException e) {
            tmpMsg = "URISyntaxException thrown creating URI w/ " + catGenConfURIName + ": " + e.getMessage();
            log.debug("expandCatalogGenTest(): " + tmpMsg, (Throwable)e);
            TestCatalogGen.assertTrue((String)tmpMsg, (boolean)false);
        }
        InputStream catGenConfInputStream = ((Object)((Object)this)).getClass().getResourceAsStream(catGenConfResourceName);
        try {
            this.me = new CatalogGen(catGenConfInputStream, catGenConfURI.toURL());
        }
        catch (MalformedURLException e) {
            tmpMsg = "MalformedURLException thrown creating URL w/ resource URI <" + catGenConfURI.toString() + ">: " + e.getMessage();
            log.debug("expandCatalogGenTest(): " + tmpMsg, (Throwable)e);
            TestCatalogGen.assertTrue((String)tmpMsg, (boolean)false);
        }
        try {
            catGenConfInputStream.close();
        }
        catch (IOException e) {
            tmpMsg = "IOException thrown closing catGenConfInputStream: " + e.getMessage();
            log.debug("expandCatalogGenTest(): " + tmpMsg, (Throwable)e);
            TestCatalogGen.assertTrue((String)tmpMsg, (boolean)false);
        }
        StringBuilder validationMsg = new StringBuilder();
        TestCatalogGen.assertTrue((String)("CatalogGen did not validate: " + validationMsg.toString()), (boolean)this.me.isValid(validationMsg));
        this.me.expand();
        TestCatalogGen.compareCatalogToCatalogResource(this.me.getCatalog(), expectedCatalogResourceName, this.displayComparedCatalogs);
    }

    private void writeCatalogGenTest(String expandedCatalogFileName) {
        String tmpMsg = null;
        URI expandedCatalogFileURI = null;
        File expandedCatalogFile = null;
        try {
            this.factory.writeXML((InvCatalogImpl)this.me.getCatalog(), expandedCatalogFileName);
        }
        catch (IOException e) {
            tmpMsg = "IOException writing catalog to file <" + expandedCatalogFileName + ">: " + e.getMessage();
            log.debug("writeCatalogGenTest(): " + tmpMsg);
            TestCatalogGen.assertTrue((String)tmpMsg, (boolean)false);
        }
        expandedCatalogFile = new File(expandedCatalogFileName);
        expandedCatalogFileURI = expandedCatalogFile.toURI();
        BufferedInputStream is = null;
        try {
            is = new BufferedInputStream(new FileInputStream(expandedCatalogFile));
        }
        catch (FileNotFoundException e) {
            tmpMsg = "FileNotFoundException thrown while reading file <" + expandedCatalogFileURI.toString() + ">: " + e.getMessage();
            log.debug("writeCatalogGenTest(): " + tmpMsg, (Throwable)e);
            TestCatalogGen.assertTrue((String)tmpMsg, (boolean)false);
        }
        this.justWrittenCatalog = this.factory.readXML((InputStream)is, expandedCatalogFileURI);
        try {
            is.close();
        }
        catch (IOException e) {
            tmpMsg = "IOException thrown while closing file input stream <" + expandedCatalogFileURI.toString() + ">: " + e.getMessage();
            log.debug("writeCatalogGenTest(): " + tmpMsg, (Throwable)e);
            TestCatalogGen.assertTrue((String)tmpMsg, (boolean)false);
        }
        TestCatalogGen.assertTrue((String)"Expanded catalog does not equal the expected catalog after writing to and reading from a file.", (boolean)((InvCatalogImpl)this.me.getCatalog()).equals((Object)this.justWrittenCatalog));
    }

    private void expandConfigDoc(String configDocFilename) {
        String tmpMsg;
        File configDocFile = new File(configDocFilename);
        URI configDocUri = configDocFile.toURI();
        FileInputStream configDocIs = null;
        try {
            configDocIs = new FileInputStream(configDocFile);
        }
        catch (FileNotFoundException e) {
            tmpMsg = "FileNotFoundException when creating InputStream on file <" + configDocFile.getAbsolutePath() + ">: " + e.getMessage();
            log.debug("expandConfigDoc(): " + tmpMsg, (Throwable)e);
            TestCatalogGen.assertTrue((String)tmpMsg, (boolean)false);
        }
        try {
            this.me = new CatalogGen((InputStream)configDocIs, configDocUri.toURL());
        }
        catch (MalformedURLException e) {
            tmpMsg = "MalformedURLException thrown creating URL w/ resource URI <" + configDocUri.toString() + ">: " + e.getMessage();
            log.debug("expandConfigDoc(): " + tmpMsg, (Throwable)e);
            TestCatalogGen.assertTrue((String)tmpMsg, (boolean)false);
        }
        StringBuilder validationMsg = new StringBuilder();
        TestCatalogGen.assertTrue((String)("CatalogGen did not validate: " + validationMsg.toString()), (boolean)this.me.isValid(validationMsg));
        this.me.expand();
    }

    public static void compareCatalogToCatalogResource(InvCatalog expandedCatalog, String expectedCatalogResourceName, boolean display) {
        String expectedCatalogURIName = "http://TestCatalogGen.resource" + expectedCatalogResourceName;
        URI expectedCatalogURI = null;
        try {
            expectedCatalogURI = new URI(expectedCatalogURIName);
        }
        catch (URISyntaxException e) {
            String tmpMsg = "URISyntaxException thrown creating URI w/ " + expectedCatalogURIName + ": " + e.getMessage();
            log.debug("compareCatalogToCatalogResource(): " + tmpMsg, (Throwable)e);
            TestCatalogGen.assertTrue((String)tmpMsg, (boolean)false);
        }
        InputStream expectedCatalogInputStream = expectedCatalogURIName.getClass().getResourceAsStream(expectedCatalogResourceName);
        InvCatalogFactory factory = new InvCatalogFactory("default", true);
        InvCatalogImpl expectedCatalog = factory.readXML(expectedCatalogInputStream, expectedCatalogURI);
        try {
            expectedCatalogInputStream.close();
        }
        catch (IOException e) {
            String tmpMsg = "IOException thrown closing InputStream: " + e.getMessage();
            log.debug("compareCatalogToCatalogResource(): " + tmpMsg, (Throwable)e);
            TestCatalogGen.assertTrue((String)tmpMsg, (boolean)false);
        }
        if (display) {
            String catalogAsString;
            String expectedCatalogAsString;
            try {
                expectedCatalogAsString = factory.writeXML(expectedCatalog);
                catalogAsString = factory.writeXML((InvCatalogImpl)expandedCatalog);
            }
            catch (IOException e) {
                System.out.println("IOException trying to write catalog to sout: " + e.getMessage());
                return;
            }
            System.out.println("Expected catalog (" + expectedCatalogResourceName + "):");
            System.out.println("--------------------");
            System.out.println(expectedCatalogAsString);
            System.out.println("--------------------");
            System.out.println("Resulting catalog (" + expandedCatalog.getUriString() + "):");
            System.out.println("--------------------");
            System.out.println(catalogAsString);
            System.out.println("--------------------\n");
        }
        TestCatalogGen.assertTrue((String)"Expanded catalog does not equal expected catalog.", (boolean)((InvCatalogImpl)expandedCatalog).equals((Object)expectedCatalog));
    }
}

