/*
 * Decompiled with CFR 0.152.
 */
package thredds.cataloggen;

import java.io.IOException;
import junit.framework.TestCase;
import thredds.catalog.InvCatalog;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvService;
import thredds.catalog.ServiceType;
import thredds.cataloggen.CollectionLevelScanner;
import thredds.cataloggen.TestCatalogGen;
import thredds.crawlabledataset.CrawlableDataset;
import thredds.crawlabledataset.CrawlableDatasetFactory;

public class TestCollectionLevelScanner
extends TestCase {
    private boolean debugShowCatalogs = true;
    private String resourcePath = "/thredds/cataloggen";
    private String resource_simpleWithEmptyServiceBase_result = "testCollectionScanner.simpleWithEmptyServiceBase.result.xml";
    private String resource_simpleWithNotEmptyServiceBase_result = "testCollectionScanner.simpleWithNotEmptyServiceBase.result.xml";
    private String resource_namedForDirWithNotEmptyServiceBase_result = "testCollectionScanner.namedForDirWithNotEmptyServiceBase.result.xml";

    public TestCollectionLevelScanner(String name) {
        super(name);
    }

    protected void setUp() {
    }

    public void testSimpleWithEmptyServiceBase() {
        InvCatalogImpl cat;
        CrawlableDataset catCrDs;
        CrawlableDataset collCrDs;
        String resultResourceName = this.resourcePath + "/" + this.resource_simpleWithEmptyServiceBase_result;
        String collectionPath = "src/test/data/thredds/cataloggen/testData/modelNotFlat";
        String catalogPath = "src/test/data/thredds/cataloggen/testData/modelNotFlat/eta_211";
        try {
            collCrDs = CrawlableDatasetFactory.createCrawlableDataset((String)collectionPath, null, null);
            catCrDs = CrawlableDatasetFactory.createCrawlableDataset((String)catalogPath, null, null);
        }
        catch (Exception e) {
            TestCollectionLevelScanner.assertTrue((String)("Failed to create CrawlableDataset for given collectionPath <" + collectionPath + "> or catalogPath <" + catalogPath + ">: " + e.getMessage()), (boolean)false);
            return;
        }
        CollectionLevelScanner me = new CollectionLevelScanner("myModelData", collCrDs, catCrDs, null, null, new InvService("service", ServiceType.DODS.toString(), "", null, null));
        TestCollectionLevelScanner.assertTrue((me != null ? 1 : 0) != 0);
        try {
            me.scan();
            cat = me.generateCatalog();
        }
        catch (IOException e) {
            TestCollectionLevelScanner.assertTrue((String)("Failed to generate catalog: " + e.getMessage()), (boolean)false);
            return;
        }
        TestCatalogGen.compareCatalogToCatalogResource((InvCatalog)cat, resultResourceName, this.debugShowCatalogs);
    }

    public void testSimpleWithNotEmptyServiceBase() {
        InvCatalogImpl cat;
        CrawlableDataset catCrDs;
        CrawlableDataset collCrDs;
        String resultResourceName = this.resourcePath + "/" + this.resource_simpleWithNotEmptyServiceBase_result;
        String collectionPath = "src/test/data/thredds/cataloggen/testData/modelNotFlat";
        String catalogPath = "src/test/data/thredds/cataloggen/testData/modelNotFlat/eta_211";
        try {
            collCrDs = CrawlableDatasetFactory.createCrawlableDataset((String)collectionPath, null, null);
            catCrDs = CrawlableDatasetFactory.createCrawlableDataset((String)catalogPath, null, null);
        }
        catch (Exception e) {
            TestCollectionLevelScanner.assertTrue((String)("Failed to create CrawlableDataset for given collectionPath <" + collectionPath + "> or catalogPath <" + catalogPath + ">: " + e.getMessage()), (boolean)false);
            return;
        }
        CollectionLevelScanner me = new CollectionLevelScanner("myModelData", collCrDs, catCrDs, null, null, new InvService("service", ServiceType.DODS.toString(), "/thredds/dodsC", null, null));
        TestCollectionLevelScanner.assertTrue((me != null ? 1 : 0) != 0);
        try {
            me.scan();
            cat = me.generateCatalog();
        }
        catch (IOException e) {
            TestCollectionLevelScanner.assertTrue((String)("Failed to generate catalog: " + e.getMessage()), (boolean)false);
            return;
        }
        TestCatalogGen.compareCatalogToCatalogResource((InvCatalog)cat, resultResourceName, this.debugShowCatalogs);
    }

    public void testNamedForDirWithNotEmptyServiceBase() {
        InvCatalogImpl cat;
        CrawlableDataset catCrDs;
        CrawlableDataset collCrDs;
        String resultResourceName = this.resourcePath + "/" + this.resource_namedForDirWithNotEmptyServiceBase_result;
        String collectionPath = "src/test/data/thredds/cataloggen/testData/modelNotFlat";
        String catalogPath = "src/test/data/thredds/cataloggen/testData/modelNotFlat/eta_211";
        try {
            collCrDs = CrawlableDatasetFactory.createCrawlableDataset((String)collectionPath, null, null);
            catCrDs = CrawlableDatasetFactory.createCrawlableDataset((String)catalogPath, null, null);
        }
        catch (Exception e) {
            TestCollectionLevelScanner.assertTrue((String)("Failed to create CrawlableDataset for given collectionPath <" + collectionPath + "> or catalogPath <" + catalogPath + ">: " + e.getMessage()), (boolean)false);
            return;
        }
        CollectionLevelScanner me = new CollectionLevelScanner("", collCrDs, catCrDs, null, null, new InvService("service", ServiceType.DODS.toString(), "/thredds/dodsC", null, null));
        TestCollectionLevelScanner.assertTrue((me != null ? 1 : 0) != 0);
        try {
            me.scan();
            cat = me.generateCatalog();
        }
        catch (IOException e) {
            TestCollectionLevelScanner.assertTrue((String)("Failed to generate catalog: " + e.getMessage()), (boolean)false);
            return;
        }
        TestCatalogGen.compareCatalogToCatalogResource((InvCatalog)cat, resultResourceName, this.debugShowCatalogs);
    }
}

