/*
 * Decompiled with CFR 0.152.
 */
package thredds.cataloggen;

import java.io.IOException;
import junit.framework.TestCase;
import thredds.catalog.InvCatalog;
import thredds.catalog.InvCatalogImpl;
import thredds.cataloggen.SimpleCatalogBuilder;
import thredds.cataloggen.TestCatalogGen;
import thredds.crawlabledataset.CrawlableDataset;
import thredds.crawlabledataset.CrawlableDatasetFactory;

public class TestSimpleCatalogBuilder
extends TestCase {
    private boolean debugShowCatalogs = true;

    public TestSimpleCatalogBuilder(String name) {
        super(name);
    }

    protected void setUp() {
    }

    public void testBasic() {
        String collectionPath = "src/test/data/thredds/cataloggen/testData/modelNotFlat";
        String catalogPath = "src/test/data/thredds/cataloggen/testData/modelNotFlat/eta_211";
        CrawlableDataset collectionCrDs = null;
        try {
            collectionCrDs = CrawlableDatasetFactory.createCrawlableDataset((String)collectionPath, null, null);
        }
        catch (Exception e) {
            TestSimpleCatalogBuilder.assertTrue((String)("Failed to create collection level dataset <" + collectionPath + ">: " + e.getMessage()), (boolean)false);
            return;
        }
        SimpleCatalogBuilder builder = new SimpleCatalogBuilder("", collectionCrDs, "server", "OPENDAP", "http://my.server/opendap/");
        TestSimpleCatalogBuilder.assertTrue((String)"SimpleCatalogBuilder is null.", (builder != null ? 1 : 0) != 0);
        CrawlableDataset catalogCrDs = null;
        try {
            catalogCrDs = CrawlableDatasetFactory.createCrawlableDataset((String)catalogPath, null, null);
        }
        catch (Exception e) {
            TestSimpleCatalogBuilder.assertTrue((String)("Failed to create collection level dataset <" + catalogPath + ">: " + e.getMessage()), (boolean)false);
            return;
        }
        InvCatalogImpl catalog = null;
        try {
            catalog = builder.generateCatalog(catalogCrDs);
        }
        catch (IOException e) {
            TestSimpleCatalogBuilder.assertTrue((String)("IOException generating catalog for given path <" + catalogPath + ">: " + e.getMessage()), (boolean)false);
        }
        TestCatalogGen.compareCatalogToCatalogResource((InvCatalog)catalog, "/thredds/cataloggen/testSimpleCatBuilder.basic.result.xml", this.debugShowCatalogs);
    }
}

