/*
 * Decompiled with CFR 0.152.
 */
package thredds.cataloggen.config;

import java.io.IOException;
import java.io.InputStream;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.List;
import junit.framework.TestCase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.InvCatalog;
import thredds.catalog.InvCatalogFactory;
import thredds.catalog.InvCatalogImpl;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.InvMetadata;
import thredds.catalog.MetadataConverterIF;
import thredds.catalog.MetadataType;
import thredds.catalog.ThreddsMetadata;
import thredds.cataloggen.config.CatGenConfigMetadataFactory;
import thredds.cataloggen.config.CatalogGenConfig;
import thredds.cataloggen.config.DatasetFilter;
import thredds.cataloggen.config.DatasetNamer;
import thredds.cataloggen.config.DatasetSource;
import thredds.cataloggen.config.ResultService;

public class TestCatGenConfigMetadataFactory
extends TestCase {
    private static Logger log = LoggerFactory.getLogger(TestCatGenConfigMetadataFactory.class);
    private String configResourcePath = "/thredds/cataloggen/config";
    private String catGenConf_0_6_ResourceName = "test1CatGenConfig0.6.xml";
    private String catGenConf_1_0_ResourceName = "test1CatGenConfig1.0.xml";
    private String catName = "THREDDS CatalogGen test config file";
    private String dsSourceName = "model data source";
    private String resultServiceName = "mlode";
    private String resultServiceType = "DODS";
    private String resultServiceBase = "http://localhost:8080/thredds/cataloggen/";
    private String resultServiceAccessPointHeader = "./test/data/thredds/cataloggen/";
    private String dsFilterName = "Accept netCDF files only";
    private String dsFilterType = "RegExp";
    private String dsFilterMatchPattern = "/[0-9][^/]*_eta_211\\.nc$";
    private String dsNamerName = "NCEP Eta 80km CONUS model data";
    private String dsNamerType = "RegExp";
    private String dsNamerAddLevel = "false";
    private String dsNamerMatchPattern = "([0-9][0-9][0-9][0-9])([0-9][0-9])([0-9][0-9])([0-9][0-9])_eta_211.nc$";
    private String dsNamerSubstitutePattern = "NCEP Eta 80km CONUS $1-$2-$3 $4:00:00 GMT";
    private InvCatalogFactory factory = null;

    public TestCatGenConfigMetadataFactory(String name) {
        super(name);
    }

    protected void setUp() {
        log.debug("setUp(): starting.");
        this.factory = new InvCatalogFactory("default", true);
        CatGenConfigMetadataFactory catGenConfMdataFactory = new CatGenConfigMetadataFactory();
        this.factory.registerMetadataConverter(MetadataType.CATALOG_GEN_CONFIG.toString(), (MetadataConverterIF)catGenConfMdataFactory);
        this.factory.registerMetadataConverter("http://www.unidata.ucar.edu/namespaces/thredds/CatalogGenConfig/v0.5", (MetadataConverterIF)catGenConfMdataFactory);
    }

    public void testParse_1_0() {
        String tmpMsg = "Test InvCatalog 1.0 parsing of metadata content.";
        log.debug("testParse(): " + tmpMsg);
        String resourceName = this.configResourcePath + "/" + this.catGenConf_1_0_ResourceName;
        String resourceURIName = "http://TestCatGenConfigMetadataFactory.resource/" + resourceName;
        URI resourceURI = null;
        try {
            resourceURI = new URI(resourceURIName);
        }
        catch (URISyntaxException e) {
            tmpMsg = "URISyntaxException thrown creating URI w/ " + resourceURIName + ": " + e.getMessage();
            log.debug("testParse(): " + tmpMsg, (Throwable)e);
            TestCatGenConfigMetadataFactory.assertTrue((String)tmpMsg, (boolean)false);
        }
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(resourceName);
        InvCatalogImpl catalog = this.factory.readXML(is, resourceURI);
        try {
            is.close();
        }
        catch (IOException e) {
            tmpMsg = "IOException thrown while closing input stream to resource <" + resourceName + ">: " + e.getMessage();
            log.debug("testParse(): " + tmpMsg, (Throwable)e);
            TestCatGenConfigMetadataFactory.assertTrue((String)tmpMsg, (boolean)false);
        }
        this.parsedCatalogTests((InvCatalog)catalog);
    }

    public void testParse_0_6() {
        String tmpMsg = "Test InvCatalog 0.6 parsing of metadata content.";
        log.debug("testParse(): " + tmpMsg);
        String resourceName = this.configResourcePath + "/" + this.catGenConf_0_6_ResourceName;
        String resourceURIName = "http://TestCatGenConfigMetadataFactory.resource/" + resourceName;
        URI resourceURI = null;
        try {
            resourceURI = new URI(resourceURIName);
        }
        catch (URISyntaxException e) {
            tmpMsg = "URISyntaxException thrown creating URI w/ " + resourceURIName + ": " + e.getMessage();
            log.debug("testParse(): " + tmpMsg, (Throwable)e);
            TestCatGenConfigMetadataFactory.assertTrue((String)tmpMsg, (boolean)false);
        }
        InputStream is = ((Object)((Object)this)).getClass().getResourceAsStream(resourceName);
        InvCatalogImpl catalog = this.factory.readXML(is, resourceURI);
        try {
            is.close();
        }
        catch (IOException e) {
            tmpMsg = "IOException thrown while closing input stream to resource <" + resourceName + ">: " + e.getMessage();
            log.debug("testParse(): " + tmpMsg, (Throwable)e);
            TestCatGenConfigMetadataFactory.assertTrue((String)tmpMsg, (boolean)false);
        }
        this.parsedCatalogTests((InvCatalog)catalog);
    }

    private void parsedCatalogTests(InvCatalog catalog) {
        TestCatGenConfigMetadataFactory.assertTrue((String)("Catalog name <" + catalog.getName() + "> != expected name <" + this.catName + ">."), (boolean)catalog.getName().equals(this.catName));
        List list = catalog.getDatasets();
        TestCatGenConfigMetadataFactory.assertTrue((String)("Catalog does not contain one and only one dataset (" + list.size() + ")."), (list.size() == 1 ? 1 : 0) != 0);
        InvDataset topDs = (InvDataset)list.get(0);
        TestCatGenConfigMetadataFactory.assertTrue((String)("Top level dataset name <" + topDs.getName() + "> != expected name <" + this.catName + ">."), (boolean)topDs.getName().equals(this.catName));
        list = topDs.getDatasets();
        TestCatGenConfigMetadataFactory.assertTrue((String)("Top level dataset does not contain two and only two datasets (" + list.size() + ")."), (list.size() == 2 ? 1 : 0) != 0);
        List list2 = null;
        InvDataset curDs = (InvDataset)list.get(0);
        ThreddsMetadata curDsTm = ((InvDatasetImpl)curDs).getLocalMetadata();
        list2 = curDsTm.getMetadata();
        TestCatGenConfigMetadataFactory.assertTrue((String)"Top level dataset does not contain one and only one InvMetadata.", (list2.size() == 1 ? 1 : 0) != 0);
        InvMetadata mdata = (InvMetadata)list2.get(0);
        TestCatGenConfigMetadataFactory.assertTrue((String)"InvMetadata is not of type CATALOG_GEN_CONFIG.", (boolean)mdata.getMetadataType().equals(MetadataType.CATALOG_GEN_CONFIG.toString()));
        list2 = (List)mdata.getContentObject();
        TestCatGenConfigMetadataFactory.assertTrue((String)"Metadata record does not contain one and only one CatalogGenConfig.", (list2.size() == 1 ? 1 : 0) != 0);
        CatalogGenConfig catGenConfig = (CatalogGenConfig)list2.get(0);
        TestCatGenConfigMetadataFactory.assertTrue((String)"CatalogGenConfig is not of type CATALOG.", (boolean)catGenConfig.getType().equals((Object)CatalogGenConfig.Type.CATALOG));
        DatasetSource dsSource = catGenConfig.getDatasetSource();
        TestCatGenConfigMetadataFactory.assertTrue((String)("DatasetSource name <" + dsSource.getName() + "> != expected name <" + this.dsSourceName + ">."), (boolean)dsSource.getName().equals(this.dsSourceName));
        ResultService resultService = dsSource.getResultService();
        TestCatGenConfigMetadataFactory.assertTrue((String)("ResultService name <" + resultService.getName() + "> != expected name <" + this.resultServiceName + ">."), (boolean)resultService.getName().equals(this.resultServiceName));
        TestCatGenConfigMetadataFactory.assertTrue((String)("ResultService type <" + resultService.getServiceType().toString() + "> != expected type <" + this.resultServiceType + ">."), (boolean)resultService.getServiceType().toString().equals(this.resultServiceType));
        TestCatGenConfigMetadataFactory.assertTrue((String)("ResultService base URL <" + resultService.getBase() + "> != expected base URL <" + this.resultServiceBase + ">."), (boolean)resultService.getBase().equals(this.resultServiceBase));
        TestCatGenConfigMetadataFactory.assertTrue((String)("ResultService access point header <" + resultService.getAccessPointHeader() + "> != expected access point header <" + this.resultServiceAccessPointHeader + ">."), (boolean)resultService.getAccessPointHeader().equals(this.resultServiceAccessPointHeader));
        list2 = dsSource.getDatasetFilterList();
        TestCatGenConfigMetadataFactory.assertTrue((String)"DatasetSource does not contain one and only one DatasetFilter.", (list2.size() == 1 ? 1 : 0) != 0);
        DatasetFilter dsFilter = (DatasetFilter)list2.get(0);
        TestCatGenConfigMetadataFactory.assertTrue((String)("DatasetFilter name <" + dsFilter.getName() + "> != expected name <" + this.dsFilterName + ">."), (boolean)dsFilter.getName().equals(this.dsFilterName));
        TestCatGenConfigMetadataFactory.assertTrue((String)("DatasetFilter type <" + dsFilter.getType().toString() + "> != expected type <" + this.dsFilterType + ">."), (boolean)dsFilter.getType().toString().equals(this.dsFilterType));
        TestCatGenConfigMetadataFactory.assertTrue((String)("DatasetFilter match pattern <" + dsFilter.getMatchPattern() + "> != expected match pattern <" + this.dsFilterMatchPattern + ">."), (boolean)dsFilter.getMatchPattern().equals(this.dsFilterMatchPattern));
        list2 = dsSource.getDatasetNamerList();
        TestCatGenConfigMetadataFactory.assertTrue((String)"DatasetSource does not contain one and only one DatasetNamer.", (list2.size() == 1 ? 1 : 0) != 0);
        DatasetNamer dsNamer = (DatasetNamer)list2.get(0);
        TestCatGenConfigMetadataFactory.assertTrue((String)("DatasetNamer name <" + dsNamer.getName() + "> != expected name <" + this.dsNamerName + ">."), (boolean)dsNamer.getName().equals(this.dsNamerName));
        TestCatGenConfigMetadataFactory.assertTrue((String)("DatasetNamer type <" + dsNamer.getType().toString() + "> != expected type <" + this.dsNamerType + ">."), (boolean)dsNamer.getType().toString().equals(this.dsNamerType));
        TestCatGenConfigMetadataFactory.assertTrue((String)("DatasetNamer addLevel <" + dsNamer.getAddLevel() + "> != expected addLevel <" + this.dsNamerAddLevel + ">."), (boolean)Boolean.toString(dsNamer.getAddLevel()).equals(this.dsNamerAddLevel));
        TestCatGenConfigMetadataFactory.assertTrue((String)("DatasetNamer match pattern <" + dsNamer.getMatchPattern() + "> != expected match pattern <" + this.dsNamerMatchPattern + ">."), (boolean)dsNamer.getMatchPattern().equals(this.dsNamerMatchPattern));
        TestCatGenConfigMetadataFactory.assertTrue((String)("DatasetNamer substitute pattern <" + dsNamer.getSubstitutePattern() + "> != expected substitute pattern <" + this.dsNamerSubstitutePattern + ">."), (boolean)dsNamer.getSubstitutePattern().equals(this.dsNamerSubstitutePattern));
    }
}

