/*
 * Decompiled with CFR 0.152.
 */
package thredds.cataloggen.config;

import java.io.IOException;
import junit.framework.TestCase;
import thredds.catalog.InvCatalog;
import thredds.catalog.InvDataset;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.ServiceType;
import thredds.cataloggen.DatasetEnhancer1;
import thredds.cataloggen.TestCatalogGen;
import thredds.cataloggen.config.DatasetFilter;
import thredds.cataloggen.config.DatasetNamer;
import thredds.cataloggen.config.DatasetNamerType;
import thredds.cataloggen.config.DatasetSource;
import thredds.cataloggen.config.DatasetSourceStructure;
import thredds.cataloggen.config.DatasetSourceType;
import thredds.cataloggen.config.ResultService;

public class TestDatasetSource
extends TestCase {
    private boolean debugShowCatalogs = true;
    private String configResourcePath = "/thredds/cataloggen/config";
    private String test1DatasetSourceResultCatalog_1_0_ResourceName = "test1ResultCatalog1.0.dss.xml";
    private String testDsfDirFilter1_ResultCatalog_1_0_ResourceName = "testDsfDirFilter1.ResultCatalog1.0.xml";
    private String testDatasetSource_allCatalogRef_ResultCatalog_ResourceName = "testDatasetSource.allCatalogRef.result.xml";
    private String testDsSource_expandFlatAddTimecoverage_ResourceName = "testDsSource.expandFlatAddTimecoverage.result.xml";
    private DatasetSource me1 = null;
    private DatasetSource me2 = null;
    private DatasetSource me3 = null;
    private InvDatasetImpl parentDs1 = null;
    private String name1 = null;
    private String name2 = null;
    private String typeName1 = null;
    private String typeName2 = null;
    private String typeName3 = null;
    private String structName1 = null;
    private String structName2 = null;
    private String accessPoint1 = null;
    private String accessPoint2 = null;
    private StringBuilder out = null;

    public TestDatasetSource(String name) {
        super(name);
    }

    protected void setUp() {
        String parentDsName1 = "parent dataset 1";
        this.parentDs1 = new InvDatasetImpl(null, parentDsName1);
        this.name1 = "name 1";
        this.name2 = "name 2";
        this.typeName1 = "Local";
        this.typeName2 = "DodsFileServer";
        this.typeName3 = "DodsDir";
        DatasetSourceType type1 = DatasetSourceType.getType((String)this.typeName1);
        DatasetSourceType type2 = DatasetSourceType.getType((String)this.typeName2);
        DatasetSourceType type3 = DatasetSourceType.getType((String)this.typeName3);
        this.structName1 = "Flat";
        this.structName2 = "DirTree";
        DatasetSourceStructure structure1 = DatasetSourceStructure.getStructure((String)this.structName1);
        this.accessPoint1 = "access point 1";
        this.accessPoint2 = "access point 2";
        this.out = new StringBuilder();
        ResultService rService = new ResultService("fred", ServiceType.DODS, "http://server/dods", null, "access point header 1");
        this.me1 = DatasetSource.newDatasetSource((String)this.name1, (DatasetSourceType)type1, (DatasetSourceStructure)structure1, (String)this.accessPoint1, (ResultService)rService);
        this.me2 = DatasetSource.newDatasetSource((String)this.name1, (DatasetSourceType)type2, (DatasetSourceStructure)structure1, (String)this.accessPoint1, (ResultService)rService);
        this.me3 = DatasetSource.newDatasetSource((String)this.name1, (DatasetSourceType)type3, (DatasetSourceStructure)structure1, (String)this.accessPoint1, (ResultService)rService);
    }

    public void testExpandFlat() {
        String expectedCatalogResourceName = this.configResourcePath + "/" + this.test1DatasetSourceResultCatalog_1_0_ResourceName;
        String service1Name = "myServer";
        String service1Type = "DODS";
        String service1Base = "/dods/";
        String service1Suffix = null;
        String service1AccessPointHeader = "./build/test/classes/thredds/cataloggen/";
        ResultService service1 = new ResultService(service1Name, ServiceType.getType((String)service1Type), service1Base, service1Suffix, service1AccessPointHeader);
        String accessPoint = "./build/test/classes/thredds/cataloggen/testData/model";
        this.me1 = DatasetSource.newDatasetSource((String)"NCEP Eta 80km CONUS model data", (DatasetSourceType)DatasetSourceType.LOCAL, (DatasetSourceStructure)DatasetSourceStructure.FLAT, (String)accessPoint, (ResultService)service1);
        DatasetFilter dsF = new DatasetFilter(this.me1, "Accept netCDF Eta 211 files only", DatasetFilter.Type.REGULAR_EXPRESSION, "/[0-9][^/]*_eta_211\\.nc$");
        this.me1.addDatasetFilter(dsF);
        InvDataset ds = null;
        try {
            ds = this.me1.expand();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Given directory is not a collection dataset <" + accessPoint + ">.");
        }
        TestCatalogGen.compareCatalogToCatalogResource(ds.getParentCatalog(), expectedCatalogResourceName, this.debugShowCatalogs);
    }

    public void testExpandNotFlatWithDirFilter() {
        String expectedCatalogResourceName = this.configResourcePath + "/" + this.testDsfDirFilter1_ResultCatalog_1_0_ResourceName;
        String service1Name = "myServer";
        String service1Type = "DODS";
        String service1Base = "/dods/";
        String service1Suffix = null;
        String service1AccessPointHeader = "./build/test/classes/thredds/cataloggen/";
        ResultService service1 = new ResultService(service1Name, ServiceType.getType((String)service1Type), service1Base, service1Suffix, service1AccessPointHeader);
        String service1AccessPoint = "./build/test/classes/thredds/cataloggen/testData/modelNotFlat";
        this.me1 = DatasetSource.newDatasetSource((String)"NCEP Eta 80km CONUS model data", (DatasetSourceType)DatasetSourceType.LOCAL, (DatasetSourceStructure)DatasetSourceStructure.FLAT, (String)service1AccessPoint, (ResultService)service1);
        DatasetFilter dsF = new DatasetFilter(this.me1, "Accept netCDF Eta 211 files only", DatasetFilter.Type.REGULAR_EXPRESSION, "/[0-9][^/]*_eta_211\\.nc$");
        this.me1.addDatasetFilter(dsF);
        DatasetFilter dsF2 = new DatasetFilter(this.me1, "Accept Eta 211 directory only", DatasetFilter.Type.REGULAR_EXPRESSION, "eta_211$", true, false, false);
        dsF2.setApplyToCollectionDatasets(true);
        dsF2.setApplyToAtomicDatasets(false);
        this.me1.addDatasetFilter(dsF2);
        InvDataset ds = null;
        try {
            ds = this.me1.expand();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Given directory is not a collection dataset <" + service1AccessPoint + ">.");
        }
        TestCatalogGen.compareCatalogToCatalogResource(ds.getParentCatalog(), expectedCatalogResourceName, this.debugShowCatalogs);
    }

    public void testExpandNotFlatWithAllCatalogRef() {
        String expectedCatalogResourceName = this.configResourcePath + "/" + this.testDatasetSource_allCatalogRef_ResultCatalog_ResourceName;
        String service1Name = "myServer";
        String service1Type = "DODS";
        String service1Base = "/dods/";
        String service1Suffix = null;
        String service1AccessPointHeader = "./build/test/classes/thredds/cataloggen/";
        ResultService service1 = new ResultService(service1Name, ServiceType.getType((String)service1Type), service1Base, service1Suffix, service1AccessPointHeader);
        String service1AccessPoint = "./build/test/classes/thredds/cataloggen/testData/modelNotFlat";
        this.me1 = DatasetSource.newDatasetSource((String)"NCEP Eta 80km CONUS model data", (DatasetSourceType)DatasetSourceType.LOCAL, (DatasetSourceStructure)DatasetSourceStructure.FLAT, (String)service1AccessPoint, (ResultService)service1);
        this.me1.setCreateCatalogRefs(true);
        InvDataset ds = null;
        try {
            ds = this.me1.expand();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Given directory is not a collection dataset <" + service1AccessPoint + ">.");
        }
        TestCatalogGen.compareCatalogToCatalogResource(ds.getParentCatalog(), expectedCatalogResourceName, this.debugShowCatalogs);
    }

    public void testExpandFlatAddTimecoverage() {
        String expectedCatalogResourceName = this.configResourcePath + "/" + this.testDsSource_expandFlatAddTimecoverage_ResourceName;
        String serviceName = "localServer";
        String serviceType = "DODS";
        String serviceBase = "http://localhost:8080/thredds/dodsC/";
        String serviceSuffix = null;
        String serviceAccessPointHeader = "./test/data/thredds/cataloggen/testData";
        ResultService service = new ResultService(serviceName, ServiceType.getType((String)serviceType), serviceBase, serviceSuffix, serviceAccessPointHeader);
        String service1AccessPoint = "./test/data/thredds/cataloggen/testData/model";
        this.me1 = DatasetSource.newDatasetSource((String)"NCEP Eta 80km CONUS model data", (DatasetSourceType)DatasetSourceType.LOCAL, (DatasetSourceStructure)DatasetSourceStructure.FLAT, (String)service1AccessPoint, (ResultService)service);
        this.me1.setCreateCatalogRefs(true);
        this.me1.addDatasetFilter(new DatasetFilter(this.me1, "no CVS", DatasetFilter.Type.REGULAR_EXPRESSION, "CVS", true, false, true));
        this.me1.addDatasetEnhancer(DatasetEnhancer1.createAddTimeCoverageEnhancer((String)"([0-9][0-9][0-9][0-9])([0-9][0-9])([0-9][0-9])([0-9][0-9])", (String)"$1-$2-$3T$4:00:00", (String)"60 hours"));
        InvCatalog cat = null;
        try {
            cat = this.me1.fullExpand();
        }
        catch (IOException e) {
            throw new IllegalArgumentException("Given directory is not a collection dataset <" + service1AccessPoint + ">.");
        }
        TestCatalogGen.compareCatalogToCatalogResource(cat, expectedCatalogResourceName, this.debugShowCatalogs);
    }

    public void testGetSet() {
        TestDatasetSource.assertTrue((boolean)this.me1.getName().equals(this.name1));
        this.me1.setName(this.name2);
        TestDatasetSource.assertTrue((boolean)this.me1.getName().equals(this.name2));
    }

    public void testType() {
        TestDatasetSource.assertTrue((boolean)DatasetSourceType.LOCAL.toString().equals(this.typeName1));
        TestDatasetSource.assertTrue((boolean)DatasetSourceType.DODS_FILE_SERVER.toString().equals(this.typeName2));
        TestDatasetSource.assertTrue((boolean)DatasetSourceType.DODS_DIR.toString().equals(this.typeName3));
        TestDatasetSource.assertTrue((boolean)this.me1.getType().equals(DatasetSourceType.getType((String)this.typeName1)));
        TestDatasetSource.assertTrue((boolean)this.me2.getType().equals(DatasetSourceType.getType((String)this.typeName2)));
        TestDatasetSource.assertTrue((boolean)this.me3.getType().equals(DatasetSourceType.getType((String)this.typeName3)));
    }

    public void testStructure() {
        TestDatasetSource.assertTrue((boolean)DatasetSourceStructure.FLAT.toString().equals(this.structName1));
        TestDatasetSource.assertTrue((boolean)DatasetSourceStructure.DIRECTORY_TREE.toString().equals(this.structName2));
        TestDatasetSource.assertTrue((boolean)this.me1.getStructure().equals(DatasetSourceStructure.getStructure((String)this.structName1)));
        this.me1.setStructure(DatasetSourceStructure.getStructure((String)this.structName2));
        TestDatasetSource.assertTrue((boolean)this.me1.getStructure().toString().equals(this.structName2));
    }

    public void testAccessPoint() {
        TestDatasetSource.assertTrue((boolean)this.me1.getAccessPoint().equals(this.accessPoint1));
        this.me1.setAccessPoint(this.accessPoint2);
        TestDatasetSource.assertTrue((boolean)this.me1.getAccessPoint().equals(this.accessPoint2));
    }

    public void testResultService() {
        TestDatasetSource.assertTrue((boolean)this.me1.getResultService().getAccessPointHeader().equals("access point header 1"));
        this.me1.setResultService(new ResultService("service name", ServiceType.DODS, "base url", "suffix", "access point header"));
        TestDatasetSource.assertTrue((boolean)this.me1.getResultService().getAccessPointHeader().equals("access point header"));
    }

    public void testDatasetNamer() {
        TestDatasetSource.assertTrue((boolean)this.me1.getDatasetNamerList().isEmpty());
        DatasetNamer namer = new DatasetNamer((InvDataset)this.parentDs1, "dsNamer name", true, DatasetNamerType.REGULAR_EXPRESSION, "match pattern", "substitute pattern", "attrib container", "attrib name");
        this.me1.addDatasetNamer(namer);
        TestDatasetSource.assertTrue((boolean)this.me1.getDatasetNamerList().contains(namer));
    }

    public void testValid() {
        boolean bool = this.me1.validate(this.out);
        TestDatasetSource.assertTrue((String)this.out.toString(), (boolean)bool);
    }
}

