/*
 * Decompiled with CFR 0.152.
 */
package thredds.cataloggen.config;

import junit.framework.TestCase;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import thredds.catalog.InvDatasetImpl;
import thredds.catalog.ServiceType;
import thredds.cataloggen.config.ResultService;

public class TestResultService
extends TestCase {
    private static Logger log = LoggerFactory.getLogger(TestResultService.class);
    private String name;
    private String base;
    private String suffix;
    private ServiceType type = null;
    private InvDatasetImpl parent;
    private String accessPointHeader1;
    private String accessPointHeader2;
    private ResultService me = null;
    private StringBuilder out = null;

    public TestResultService(String name) {
        super(name);
    }

    protected void setUp() {
        this.name = "service name";
        this.base = "http://www.unidata.ucar.edu/";
        this.suffix = "suffix";
        this.type = ServiceType.getType((String)"DODS");
        this.parent = new InvDatasetImpl(null, "parent dataset");
        this.accessPointHeader1 = "access point header1";
        this.accessPointHeader2 = "access point header2";
        this.me = new ResultService(this.name, this.type, this.base, this.suffix, this.accessPointHeader1);
        this.out = new StringBuilder();
    }

    public void testInvServiceImpl() {
        TestResultService.assertTrue((boolean)this.me.getName().equals(this.name));
        TestResultService.assertTrue((boolean)this.me.getBase().equals(this.base));
        TestResultService.assertTrue((boolean)this.me.getServiceType().equals((Object)this.type));
        TestResultService.assertTrue((boolean)this.me.getSuffix().equals(this.suffix));
    }

    public void testAccessPointHeader() {
        TestResultService.assertTrue((boolean)this.me.getAccessPointHeader().equals(this.accessPointHeader1));
        this.me.setAccessPointHeader(this.accessPointHeader2);
        TestResultService.assertTrue((boolean)this.me.getAccessPointHeader().equals(this.accessPointHeader2));
    }

    public void testIsValid() {
        boolean bool = this.me.validate(this.out);
        TestResultService.assertTrue((String)this.out.toString(), (boolean)bool);
        this.out = new StringBuilder();
        this.me.setAccessPointHeader("");
        bool = this.me.validate(this.out);
        TestResultService.assertTrue((String)this.out.toString(), (boolean)bool);
        this.out = new StringBuilder();
        this.me.setAccessPointHeader(null);
        bool = this.me.validate(this.out);
        TestResultService.assertFalse((String)this.out.toString(), (boolean)bool);
    }
}

