/*
 * Decompiled with CFR 0.152.
 */
package thredds.crawlabledataset;

import java.io.File;
import java.io.IOException;
import java.util.List;
import junit.framework.TestCase;
import thredds.crawlabledataset.CrawlableDataset;
import thredds.crawlabledataset.CrawlableDatasetFile;
import ucar.nc2.TestAll;

public class TestCrawlableDatasetFile
extends TestCase {
    public TestCrawlableDatasetFile(String name) {
        super(name);
    }

    public void testUnreadableDir_Level2() {
        File topDir = new File(new File(TestAll.cdmUnitTestDir), "TestCrawlableDatasetFile");
        File testDir = new File(topDir, "testUnreadableDir");
        CrawlableDatasetFile crDs = new CrawlableDatasetFile(testDir);
        TestCrawlableDatasetFile.assertTrue((boolean)crDs.exists());
        TestCrawlableDatasetFile.assertTrue((boolean)crDs.isCollection());
        List crDsChildren = null;
        try {
            crDsChildren = crDs.listDatasets();
        }
        catch (IOException e) {
            TestCrawlableDatasetFile.fail((String)("Couldn't list children: " + e.getMessage()));
        }
        TestCrawlableDatasetFile.assertTrue((crDsChildren.size() == 1 ? 1 : 0) != 0);
        crDs = (CrawlableDatasetFile)crDsChildren.get(0);
        try {
            crDsChildren = crDs.listDatasets();
        }
        catch (IOException e) {
            TestCrawlableDatasetFile.fail((String)("Couldn't list children: " + e.getMessage()));
        }
        for (CrawlableDataset curCrDs : crDsChildren) {
            if (curCrDs.getName().equals("aSubSubdir")) {
                TestCrawlableDatasetFile.assertTrue((boolean)curCrDs.exists());
                continue;
            }
            if (curCrDs.getName().equals("anUnreadableSubSubdir")) {
                if (curCrDs.exists()) {
                    System.out.println("DANG! File.canRead()==true when it shouldn't.");
                    System.out.println("      OS Name        : " + System.getProperty("os.name"));
                    System.out.println("      OS Architecture: " + System.getProperty("os.arch"));
                    System.out.println("      OS Version     : " + System.getProperty("os.version"));
                    List kids = null;
                    try {
                        kids = curCrDs.listDatasets();
                    }
                    catch (IOException e) {
                        TestCrawlableDatasetFile.fail((String)("Listing children failed: " + e.getMessage()));
                    }
                    TestCrawlableDatasetFile.assertTrue((boolean)kids.isEmpty());
                    continue;
                }
                System.out.println("YAY! File.canRead() returned false?");
                continue;
            }
            TestCrawlableDatasetFile.fail((String)("Unexpected sub-subdirectory [" + curCrDs.getPath() + "]."));
        }
    }
}

