/*
 * Decompiled with CFR 0.152.
 */
package thredds.crawlabledataset.filter;

import java.io.File;
import java.io.IOException;
import java.util.List;
import junit.framework.TestCase;
import thredds.crawlabledataset.CrawlableDataset;
import thredds.crawlabledataset.CrawlableDatasetFile;
import thredds.crawlabledataset.CrawlableDatasetFilter;
import thredds.crawlabledataset.filter.LastModifiedLimitFilter;
import thredds.crawlabledataset.filter.LogicalFilterComposer;
import thredds.crawlabledataset.filter.MultiSelectorFilter;
import thredds.crawlabledataset.filter.WildcardMatchOnNameFilter;

public class TestLogicalFilterComposer
extends TestCase {
    private File tmpFile;
    private File tmpDir;
    private File file1;
    private File file2;
    private File file3;
    private File file4;

    public TestLogicalFilterComposer(String name) {
        super(name);
    }

    protected void setUp() {
    }

    public void testOne() {
        this.createFiles();
        MultiSelectorFilter includeGribFilter = new MultiSelectorFilter(new MultiSelectorFilter.Selector((CrawlableDatasetFilter)new WildcardMatchOnNameFilter("*.grib1"), true, true, false));
        LastModifiedLimitFilter lastModAtLeast4MinPastFilter = new LastModifiedLimitFilter(240000L);
        CrawlableDatasetFilter oldGribFilter = LogicalFilterComposer.getAndFilter((CrawlableDatasetFilter)includeGribFilter, (CrawlableDatasetFilter)lastModAtLeast4MinPastFilter);
        MultiSelectorFilter includeNcFilter = new MultiSelectorFilter(new MultiSelectorFilter.Selector((CrawlableDatasetFilter)new WildcardMatchOnNameFilter("*.nc"), true, true, false));
        CrawlableDatasetFilter newNcFilter = LogicalFilterComposer.getAndFilter((CrawlableDatasetFilter)includeNcFilter, (CrawlableDatasetFilter)LogicalFilterComposer.getNotFilter((CrawlableDatasetFilter)lastModAtLeast4MinPastFilter));
        CrawlableDatasetFilter oldGribOrNewNcFilter = LogicalFilterComposer.getOrFilter((CrawlableDatasetFilter)oldGribFilter, (CrawlableDatasetFilter)newNcFilter);
        CrawlableDatasetFile tmpDirCrDs = new CrawlableDatasetFile(this.tmpDir);
        List crDsList = null;
        try {
            crDsList = tmpDirCrDs.listDatasets();
        }
        catch (IOException e) {
            TestLogicalFilterComposer.assertTrue((String)"I/O problem getting contained dataset list.", (boolean)false);
            this.deleteFiles();
            return;
        }
        for (CrawlableDataset curCrDs : crDsList) {
            if (!oldGribOrNewNcFilter.accept(curCrDs) || curCrDs.getName().equals("old.grib1") || curCrDs.getName().equals("new.nc")) continue;
            TestLogicalFilterComposer.assertTrue((String)("Matched wrong file <" + curCrDs.getPath() + ">."), (boolean)false);
            this.deleteFiles();
            return;
        }
        this.deleteFiles();
    }

    private void createFiles() {
        try {
            this.tmpFile = File.createTempFile("thredds.testLogicalCompFilterFactory", "file");
        }
        catch (IOException e) {
            TestLogicalFilterComposer.assertTrue((String)("Failed to create temp file in default temp directory: " + e.getMessage()), (boolean)false);
            return;
        }
        this.tmpDir = new File(this.tmpFile.getParentFile(), "thredds.testLogicalCompFilterFactory");
        this.file1 = new File(this.tmpDir, "new.grib1");
        this.file2 = new File(this.tmpDir, "old.grib1");
        this.file3 = new File(this.tmpDir, "new.nc");
        this.file4 = new File(this.tmpDir, "old.nc");
        if (!this.tmpDir.mkdir()) {
            TestLogicalFilterComposer.assertTrue((String)("Failed to create test dir <" + this.tmpDir.getAbsolutePath() + ">."), (boolean)false);
            return;
        }
        try {
            this.file1.createNewFile();
            this.file2.createNewFile();
            this.file3.createNewFile();
            this.file4.createNewFile();
        }
        catch (IOException e) {
            TestLogicalFilterComposer.assertTrue((String)("Failed to create test file: " + e.getMessage()), (boolean)false);
            return;
        }
        if (!this.file2.setLastModified(System.currentTimeMillis() - 360000L)) {
            TestLogicalFilterComposer.assertTrue((String)("Failed to set last modified time <" + this.file2.getPath() + ">."), (boolean)false);
            this.deleteFiles();
            return;
        }
        if (!this.file4.setLastModified(System.currentTimeMillis() - 360000L)) {
            TestLogicalFilterComposer.assertTrue((String)("Failed to set last modified time <" + this.file4.getPath() + ">."), (boolean)false);
            this.deleteFiles();
            return;
        }
    }

    private void deleteFiles() {
        if (!(this.file1.delete() || this.file2.delete() || this.file3.delete() || this.file4.delete())) {
            System.out.println("Failed to delete at least one temp file <dir=" + this.tmpDir.getAbsolutePath() + ">.");
            return;
        }
        if (!this.tmpDir.delete()) {
            System.out.println("Failed to remove temp dir <" + this.tmpDir.getAbsolutePath() + ">.");
            return;
        }
        if (!this.tmpFile.delete()) {
            System.out.println("Failed to remove temp file <" + this.tmpFile.getAbsolutePath() + ">.");
            return;
        }
    }
}

