/*
 * Decompiled with CFR 0.152.
 */
package thredds.crawlabledataset.filter;

import junit.framework.TestCase;
import thredds.crawlabledataset.CrawlableDataset;
import thredds.crawlabledataset.CrawlableDatasetFactory;
import thredds.crawlabledataset.filter.RegExpMatchOnNameFilter;

public class TestRegExpMatchOnNameFilter
extends TestCase {
    public TestRegExpMatchOnNameFilter(String name) {
        super(name);
    }

    protected void setUp() {
    }

    public void testRegExpMatch() {
        this.checkRegExpMatch("build\\.xml", "build.xml");
        this.checkRegExpMatch("build\\.xm.?", "build.xml");
        this.checkRegExpMatch("build\\..*", "build.xml");
        this.checkRegExpMatch("visad\\.jar", "lib/visad.jar");
        this.checkRegExpMatch("visad\\.j.?r", "lib/visad.jar");
        this.checkRegExpMatch(".*ad\\.jar", "lib/visad.jar");
    }

    private void checkRegExpMatch(String regExpString, String dsPath) {
        RegExpMatchOnNameFilter me = new RegExpMatchOnNameFilter(regExpString);
        CrawlableDataset ds = null;
        try {
            ds = CrawlableDatasetFactory.createCrawlableDataset((String)dsPath, null, null);
        }
        catch (Exception e) {
            TestRegExpMatchOnNameFilter.assertTrue((String)("Failed to create CrawlableDataset <" + dsPath + ">: " + e.getMessage()), (boolean)false);
        }
        TestRegExpMatchOnNameFilter.assertTrue((String)("Failed to construct RegExpMatchOnNameFilter <" + regExpString + ">."), (me != null ? 1 : 0) != 0);
        TestRegExpMatchOnNameFilter.assertTrue((String)("RegExp string <" + regExpString + "> did not match dataset <" + ds.getName() + ">."), (boolean)me.accept(ds));
    }
}

