/*
 * Decompiled with CFR 0.152.
 */
package thredds.crawlabledataset.filter;

import junit.framework.TestCase;
import thredds.crawlabledataset.CrawlableDataset;
import thredds.crawlabledataset.CrawlableDatasetFactory;
import thredds.crawlabledataset.filter.WildcardMatchOnNameFilter;

public class TestWildcardMatchOnNameFilter
extends TestCase {
    public TestWildcardMatchOnNameFilter(String name) {
        super(name);
    }

    protected void setUp() {
    }

    public void testWildcardStringConversionToRegExp() {
        this.checkWildcardStringAsRegExp("aFile.nc", "aFile\\.nc");
        this.checkWildcardStringAsRegExp("a?ile.nc", "a.?ile\\.nc");
        this.checkWildcardStringAsRegExp("a*e.nc", "a.*e\\.nc");
        this.checkWildcardStringAsRegExp("a*e.n?", "a.*e\\.n.?");
    }

    public void testWildcardMatch() {
        this.checkWildcardMatch("build.xml", "build.xml");
        this.checkWildcardMatch("build.xm?", "build.xml");
        this.checkWildcardMatch("build.*", "build.xml");
        this.checkWildcardMatch("visad.jar", "lib/visad.jar");
        this.checkWildcardMatch("visad.j?r", "lib/visad.jar");
        this.checkWildcardMatch("*ad.jar", "lib/visad.jar");
    }

    private void checkWildcardStringAsRegExp(String wildcardString, String wildcardStringAsRegExp) {
        WildcardMatchOnNameFilter me = new WildcardMatchOnNameFilter(wildcardString);
        TestWildcardMatchOnNameFilter.assertTrue((String)("Failed to construct WildcardMatchOnNameFilter <" + wildcardString + ">."), (me != null ? 1 : 0) != 0);
        TestWildcardMatchOnNameFilter.assertTrue((String)("Wildcard string <" + wildcardString + "> as regExp <" + me.wildcardString + "> not as expected <" + wildcardStringAsRegExp + ">."), (boolean)me.wildcardString.equals(wildcardStringAsRegExp));
    }

    private void checkWildcardMatch(String wildcardString, String dsPath) {
        WildcardMatchOnNameFilter me = new WildcardMatchOnNameFilter(wildcardString);
        CrawlableDataset ds = null;
        try {
            ds = CrawlableDatasetFactory.createCrawlableDataset((String)dsPath, null, null);
        }
        catch (Exception e) {
            TestWildcardMatchOnNameFilter.assertTrue((String)("Failed to create CrawlableDataset <" + dsPath + ">: " + e.getMessage()), (boolean)false);
        }
        TestWildcardMatchOnNameFilter.assertTrue((String)("Failed to construct WildcardMatchOnNameFilter <" + wildcardString + ">."), (me != null ? 1 : 0) != 0);
        TestWildcardMatchOnNameFilter.assertTrue((String)("Wildcard string <" + wildcardString + "> did not match dataset <" + ds.getName() + ">."), (boolean)me.accept(ds));
    }
}

