/*
 * Decompiled with CFR 0.152.
 */
package thredds.crawlabledataset.mock;

import java.io.IOException;
import java.util.Collections;
import java.util.Date;
import java.util.List;
import java.util.Map;
import thredds.crawlabledataset.CrawlableDataset;
import thredds.crawlabledataset.CrawlableDatasetFilter;
import thredds.crawlabledataset.mock.MockCrDsInfo;
import thredds.crawlabledataset.mock.MockCrawlableDataset;

public class MockCrawlableDatasetTree
implements CrawlableDataset {
    private final MockCrawlableDataset delegate;
    private final Map<String, MockCrDsInfo> crDsTree;

    public MockCrawlableDatasetTree(String path, Map<String, MockCrDsInfo> crDsTree) {
        if (crDsTree == null || crDsTree.isEmpty()) {
            throw new IllegalArgumentException("CrawlableDataset tree must not be null or empty.");
        }
        if (path == null) {
            path = crDsTree.keySet().iterator().next();
            this.delegate = new MockCrawlableDataset(crDsTree.get(path));
        } else {
            this.delegate = crDsTree.containsKey(path) ? new MockCrawlableDataset(crDsTree.get(path)) : new MockCrawlableDataset(new MockCrDsInfo(path, false, false, null, -1L));
        }
        this.crDsTree = crDsTree;
    }

    public Object getConfigObject() {
        return null;
    }

    public String getPath() {
        return this.delegate.getPath();
    }

    public String getName() {
        return this.delegate.getName();
    }

    public CrawlableDataset getParentDataset() {
        if (!this.delegate.exists()) {
            return null;
        }
        CrawlableDataset possibleParent = this.delegate.getParentDataset();
        if (possibleParent == null) {
            return null;
        }
        if (this.crDsTree.containsKey(possibleParent.getPath())) {
            return new MockCrawlableDatasetTree(possibleParent.getPath(), this.crDsTree);
        }
        return this.delegate.getParentDataset();
    }

    public boolean exists() {
        return this.delegate.exists();
    }

    public boolean isCollection() {
        return this.delegate.isCollection();
    }

    public CrawlableDataset getDescendant(String relativePath) {
        if (!this.delegate.exists()) {
            return null;
        }
        return this.delegate.getDescendant(relativePath);
    }

    public List<CrawlableDataset> listDatasets() throws IOException {
        if (!this.delegate.exists()) {
            return Collections.emptyList();
        }
        return null;
    }

    public List<CrawlableDataset> listDatasets(CrawlableDatasetFilter filter) throws IOException {
        if (!this.delegate.exists()) {
            return Collections.emptyList();
        }
        return null;
    }

    public long length() {
        return this.delegate.length();
    }

    public Date lastModified() {
        return this.delegate.lastModified();
    }
}

