/*
 * Decompiled with CFR 0.152.
 */
package thredds.util;

import java.io.IOException;
import java.io.InputStream;
import java.io.InputStreamReader;
import java.net.URI;
import java.net.URISyntaxException;
import junit.framework.TestCase;
import thredds.util.HttpUriResolver;
import thredds.util.HttpUriResolverFactory;

public class TestUriResolver
extends TestCase {
    public TestUriResolver(String name) {
        super(name);
    }

    public void testOne() {
        URI uri = null;
        try {
            uri = new URI("http://motherlode.ucar.edu:8080/thredds/catalog.xml");
        }
        catch (URISyntaxException e) {
            TestUriResolver.fail();
        }
        HttpUriResolver httpUriResolver = HttpUriResolverFactory.getDefaultHttpUriResolver((URI)uri);
        InputStream resp = null;
        try {
            httpUriResolver.makeRequest();
            resp = httpUriResolver.getResponseBodyAsInputStream();
            if (-1 == resp.read()) {
                TestUriResolver.fail((String)"");
            }
        }
        catch (IOException e) {
            TestUriResolver.fail((String)e.getMessage());
        }
        TestUriResolver.assertTrue((String)"URI resolved to null string.", (resp != null ? 1 : 0) != 0);
    }

    public static void main(String[] args) {
        String catUriString = "http://newmotherlode.ucar.edu:8080/thredds/catalog/nexrad/level2/KFTG/20080730/catalog.xml";
        if (args.length > 0 && args[0] != null && args[0].startsWith("http://")) {
            catUriString = args[0];
        }
        URI catUri = null;
        try {
            catUri = new URI(catUriString);
        }
        catch (URISyntaxException e) {
            TestUriResolver.fail((String)("Bad syntax in catalog URI [" + catUriString + "]: " + e.getMessage()));
        }
        try {
            HttpUriResolver httpUriResolver = HttpUriResolverFactory.getDefaultHttpUriResolver((URI)catUri);
            httpUriResolver.makeRequest();
            InputStream is = httpUriResolver.getResponseBodyAsInputStream();
            InputStreamReader isr = new InputStreamReader(is, "UTF-8");
            int cnt = 1;
            while (isr.ready()) {
                char[] c = new char[1000];
                int num = isr.read(c);
                System.out.println(cnt + "[" + num + "]" + new String(c));
                ++cnt;
            }
        }
        catch (IOException e) {
            TestUriResolver.fail((String)("Failed to read catalog [" + catUriString + "]: " + e.getMessage()));
        }
    }
}

