/*
 * Decompiled with CFR 0.152.
 */
package thredds.wms;

import java.io.File;
import java.io.IOException;
import junit.framework.TestCase;
import ucar.nc2.util.IO;

public class TestWmsServer
extends TestCase {
    private String server = "http://localhost:8080/thredds/wms/";

    public TestWmsServer(String name) {
        super(name);
    }

    public void testNAM() throws IOException {
        String dataset = this.server + "testAll/namExtract/20060925_0600.nc";
        this.showGetCapabilities(dataset);
        this.getMap(dataset, "Pressure_surface", "C:/temp/wmsNAM.jpg");
    }

    public void testLatlon() throws IOException {
        String dataset = this.server + "testWMS/cmor_pcmdi.nc";
        this.showGetCapabilities(dataset);
    }

    public void testRot() throws IOException {
        String dataset = this.server + "testWMS/rotatedLatlon.grb";
        this.showGetCapabilities(dataset);
        this.getMap(dataset, "Geopotential_height", "C:/temp/wmsRot.jpg");
    }

    public void testGoogle() throws IOException {
        String g = "testWMS/rotatedlatlon.grb?VERSION=1.1.1&REQUEST=GetMap&SRS=EPSG:4326&WIDTH=512&HEIGHT=512&LAYERS=Geopotential_height&STYLES=BOXFILL/alg&TRANSPARENT=TRUE&FORMAT=image/gif&BBOX=-135,35.34046249175859,135,82.1914946416798";
        this.saveRead(this.server + g, "C:/temp/wmsGoogle.gif");
    }

    private void showGetCapabilities(String url) throws IOException {
        this.showRead(url + "?request=GetCapabilities&version=1.3.0&service=WMS");
    }

    private void getMap(String url, String grid, String filename) throws IOException {
        String opts = "&STYLES=BOXFILL/ncview&";
        opts = opts + "CRS=CRS:84&";
        opts = opts + "BBOX=0,-90,360,90&";
        opts = opts + "WIDTH=1000&";
        opts = opts + "HEIGHT=500&";
        opts = opts + "FORMAT=image/png&";
        this.saveRead(url + "?request=GetMap&version=1.3.0&service=WMS&Layers=" + grid + opts, filename);
    }

    private void getMap3(String url, String grid, String filename) throws IOException {
        String styles = "&STYLES=BOXFILL/redblue&";
        String srs = "CRS=CRS:84&";
        String bb = "BBOX=-100,30,-40,40&";
        String width = "WIDTH=600&";
        String height = "HEIGHT=500&";
        String format = "FORMAT=image/png";
        String opts = styles + srs + bb + width + height + format;
        this.saveRead(url + "?request=GetMap&version=1.3.0&service=WMS&Layers=" + grid + opts, filename);
    }

    private void showRead(String url) throws IOException {
        System.out.println("****************\n");
        System.out.println(url + "\n");
        String contents = IO.readURLcontentsWithException((String)url);
        System.out.println(contents);
    }

    private void saveRead(String url, String filename) throws IOException {
        System.out.println("****************\n");
        System.out.println("Read " + url + "\n");
        File file = new File(filename);
        String result = IO.readURLtoFile((String)url, (File)file);
        System.out.println("Save to " + filename + " result = " + result + "\n");
        System.out.println("****************\n");
    }
}

