/*
 * Decompiled with CFR 0.152.
 */
package timing;

import java.util.Random;
import timing.Average;
import timing.PerformanceChecker;
import timing.PerformanceHarness;

public class Example {
    private static final int RUNS = 10;
    private static final long TEST_TIME = 100L;

    public static void main(String[] args) throws Exception {
        Example.test(1);
        Example.test(1);
        Example.test(10);
        Example.test(100);
        Example.test(1000);
        Example.test(10000);
        Example.test(100000);
    }

    private static void test(int length) {
        PerformanceHarness harness = new PerformanceHarness();
        Average arrayClone = harness.calculatePerf(new PerformanceChecker(100L, new ArrayCloneTest(length)), 10);
        Average arrayNewAndCopy = harness.calculatePerf(new PerformanceChecker(100L, new ArrayNewAndCopyTest(length)), 10);
        Average arrayNewAndCopy2 = harness.calculatePerf(new PerformanceChecker(100L, new ArrayNewAndCopyTest2(length)), 10);
        System.out.println("Length=" + length);
        System.out.println(" Clone avg= " + arrayClone.mean() + " dev= " + arrayClone.stddev());
        System.out.println(" Copy  avg= " + arrayNewAndCopy.mean() + " dev= " + arrayNewAndCopy.stddev());
        System.out.println(" Copy/Clone  avg= " + arrayNewAndCopy.mean() / arrayClone.mean());
        System.out.println(" Copy2  avg= " + arrayNewAndCopy2.mean() + " dev= " + arrayNewAndCopy2.stddev());
        System.out.println(" Copy2/Clone  avg= " + arrayNewAndCopy2.mean() / arrayClone.mean());
        System.out.println();
    }

    private static class ArrayNewAndCopyTest2
    implements Runnable {
        private final byte[] byteValue;

        public ArrayNewAndCopyTest2(int length) {
            this.byteValue = new byte[length];
            new Random(0L).nextBytes(this.byteValue);
        }

        @Override
        public void run() {
            Class<?> cls = this.byteValue.getClass();
            if (cls.isArray() && !cls.getComponentType().isAssignableFrom(Object.class)) {
                byte[] b = new byte[this.byteValue.length];
                System.arraycopy(this.byteValue, 0, b, 0, this.byteValue.length);
                return;
            }
            throw new RuntimeException();
        }
    }

    private static class ArrayNewAndCopyTest
    implements Runnable {
        private final byte[] byteValue;

        public ArrayNewAndCopyTest(int length) {
            this.byteValue = new byte[length];
            new Random(0L).nextBytes(this.byteValue);
        }

        @Override
        public void run() {
            byte[] b = new byte[this.byteValue.length];
            System.arraycopy(this.byteValue, 0, b, 0, this.byteValue.length);
        }
    }

    private static class ArrayCloneTest
    implements Runnable {
        private final byte[] byteValue;

        public ArrayCloneTest(int length) {
            this.byteValue = new byte[length];
            new Random(0L).nextBytes(this.byteValue);
        }

        @Override
        public void run() {
            byte[] result = (byte[])this.byteValue.clone();
        }
    }
}

