/*
 * Decompiled with CFR 0.152.
 */
package timing.IO;

import java.io.BufferedInputStream;
import java.io.BufferedOutputStream;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.net.ConnectException;
import java.net.HttpURLConnection;
import java.net.MalformedURLException;
import java.net.URL;
import java.nio.ByteBuffer;
import java.nio.FloatBuffer;
import java.nio.channels.FileChannel;
import java.util.Date;
import ucar.nc2.util.IO;
import ucar.unidata.util.Format;

public class TimeCopy {
    static boolean debug = true;

    public static void main(String[] args) throws IOException {
        TimeCopy.copyURL("http://motherlode.ucar.edu:9080/thredds/netcdf/null/dd/RUC2_CONUS_40km_20070709_1800.nc?v,u,Z,T", "C:/temp/null.nc", 10000);
    }

    public static void copyFile(String filenameIn, String filenameOut, boolean buffer) throws IOException {
        long lenIn = new File(filenameIn).length();
        if (debug) {
            System.out.println("read " + filenameIn + " len = " + lenIn);
        }
        FileInputStream in = new FileInputStream(filenameIn);
        if (buffer) {
            new BufferedInputStream(in, 10000);
        }
        OutputStream out = new FileOutputStream(filenameOut);
        if (buffer) {
            out = new BufferedOutputStream(out, 1000);
        }
        long start = System.currentTimeMillis();
        IO.copyB((InputStream)in, (OutputStream)out, (int)10000);
        out.flush();
        double took = 0.001 * (double)(System.currentTimeMillis() - start);
        out.close();
        ((InputStream)in).close();
        long lenOut = new File(filenameOut).length();
        if (debug) {
            System.out.println(" write file= " + filenameOut + " len = " + lenOut);
        }
        double rate = (double)lenIn / took / 1000000.0;
        String name = buffer ? "buffer" : "no buffer";
        System.out.println(" copy (" + name + ") took = " + took + " sec; rate = " + rate + "Mb/sec");
    }

    public static void copyFileNIO(String filenameIn, String filenameOut, long kbchunks) throws IOException {
        long need;
        FileInputStream in = new FileInputStream(filenameIn);
        FileChannel inChannel = in.getChannel();
        FileOutputStream out = new FileOutputStream(filenameOut);
        FileChannel outChannel = out.getChannel();
        long size = inChannel.size();
        if (debug) {
            System.out.println("read " + filenameIn + " len = " + size + " out starts at=" + outChannel.position());
        }
        long start = System.currentTimeMillis();
        for (long done = 0L; done < size; done += inChannel.transferTo(done, need, outChannel)) {
            need = Math.min(kbchunks * 1000L, size - done);
        }
        outChannel.close();
        inChannel.close();
        double took = 0.001 * (double)(System.currentTimeMillis() - start);
        if (debug) {
            System.out.println(" write file= " + filenameOut + " len = " + size);
        }
        double rate = (double)size / took / 1000000.0;
        System.out.println(" copyFileNIO(" + kbchunks + " kb chunk) took = " + took + " sec; rate = " + rate + "Mb/sec");
    }

    public static void testNIO(String filenameIn, String filenameOut, long kbchunks) throws IOException {
        ByteBuffer bb = ByteBuffer.allocate(8000);
        FloatBuffer fb = bb.asFloatBuffer();
    }

    public static void readFile(String filenameIn, int bufferSize) throws IOException {
        int bytesRead;
        long lenIn = new File(filenameIn).length();
        if (debug) {
            System.out.println("read " + filenameIn + " len = " + lenIn);
        }
        FileInputStream in = new FileInputStream(filenameIn);
        long total = 0L;
        long start = System.currentTimeMillis();
        byte[] buffer = new byte[bufferSize];
        while ((bytesRead = ((InputStream)in).read(buffer)) != -1) {
            total += (long)buffer[0];
        }
        double took = 0.001 * (double)(System.currentTimeMillis() - start);
        ((InputStream)in).close();
        double rate = (double)lenIn / took / 1000000.0;
        System.out.println(" copy (" + bufferSize + ") took = " + took + " sec; rate = " + rate + "Mb/sec total=" + total);
    }

    public static void copyURL(String url, String filenameOut, int bufferSize) throws IOException {
        File outFile = new File(filenameOut);
        long start = System.currentTimeMillis();
        String ok = IO.readURLtoFileWithExceptions((String)url, (File)outFile, (int)bufferSize);
        double took = 0.001 * (double)(System.currentTimeMillis() - start);
        double len = (double)outFile.length() / 1000000.0;
        double rate = len / took;
        System.out.println(" copyURL (" + url + ") took = " + took + " sec; len= " + len + " Mbytes; rate = " + Format.d((double)rate, (int)3) + "Mb/sec ok=" + ok);
    }

    public static void copyURL2null(String url, String filenameOut, int bufferSize) throws IOException {
        long start = System.currentTimeMillis();
        long count = IO.copyUrlB((String)url, null, (int)bufferSize);
        double len = (double)count / 1000000.0;
        double took = 0.001 * (double)(System.currentTimeMillis() - start);
        double rate = len / took;
        System.out.println(" copyURL2null (" + url + ") took = " + took + " sec; len= " + len + " Mbytes; rate = " + Format.d((double)rate, (int)3) + " Mb/sec");
    }

    public static void readURL(String urlString, int bufferSize) throws IOException {
        URL url;
        System.out.println("start=" + new Date());
        long start = System.currentTimeMillis();
        InputStream is = null;
        try {
            url = new URL(urlString);
        }
        catch (MalformedURLException e) {
            throw new IOException("** MalformedURLException on URL <" + urlString + ">\n" + e.getMessage() + "\n");
        }
        try {
            int bytesRead;
            HttpURLConnection httpConnection = (HttpURLConnection)url.openConnection();
            int responseCode = httpConnection.getResponseCode();
            System.out.println(" response code= " + responseCode);
            if (responseCode / 100 != 2) {
                throw new IOException("** Cant open URL <" + urlString + ">\n Response code = " + responseCode + "\n" + httpConnection.getResponseMessage() + "\n");
            }
            is = httpConnection.getInputStream();
            int nreads = 0;
            long totalB = 0L;
            long total = 0L;
            byte[] buffer = new byte[bufferSize];
            while ((bytesRead = is.read(buffer)) != -1) {
                totalB += (long)bytesRead;
                total += (long)buffer[0];
                ++nreads;
            }
            double took = 0.001 * (double)(System.currentTimeMillis() - start);
            double rate = (double)totalB / took / 1000000.0;
            double avg = totalB / (long)nreads;
            System.out.println(" readURL (" + bufferSize + ") took = " + took + " sec; rate = " + rate + "Mb/sec avg read= " + avg);
            System.out.println("   dummy=" + total);
            System.out.println(" end=" + new Date());
        }
        catch (ConnectException e) {
            throw new IOException("** ConnectException on URL: <" + urlString + ">\n" + e.getMessage() + "\nServer probably not running");
        }
        finally {
            if (is != null) {
                is.close();
            }
        }
    }
}

