/*
 * Decompiled with CFR 0.152.
 */
package timing;

import java.util.Timer;
import java.util.TimerTask;

public class PerformanceChecker {
    private volatile boolean expired = false;
    private final long testTime;
    private final Runnable task;
    public static final int EPSILON = 20;
    private static final int MAXIMUM_ATTEMPTS = 3;

    public PerformanceChecker(long testTime, Runnable task) {
        this.testTime = testTime;
        this.task = task;
    }

    public long start() {
        long numberOfLoops;
        long start;
        int runs = 0;
        do {
            if (++runs > 3) {
                throw new IllegalStateException("Test not accurate");
            }
            this.expired = false;
            start = System.currentTimeMillis();
            numberOfLoops = 0L;
            Timer timer = new Timer();
            timer.schedule(new TimerTask(){

                @Override
                public void run() {
                    PerformanceChecker.this.expired = true;
                }
            }, this.testTime);
            while (!this.expired) {
                this.task.run();
                ++numberOfLoops;
            }
            start = System.currentTimeMillis() - start;
            timer.cancel();
        } while (Math.abs(start - this.testTime) > 20L);
        this.collectGarbage();
        return numberOfLoops;
    }

    private void collectGarbage() {
        for (int i = 0; i < 3; ++i) {
            System.gc();
            try {
                Thread.sleep(10L);
                continue;
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
                break;
            }
        }
    }
}

