/*
 * Decompiled with CFR 0.152.
 */
package ucar.ma2;

import junit.framework.TestCase;
import ucar.ma2.ArrayDouble;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;

public class TestIterator
extends TestCase {
    int m = 4;
    int n = 3;
    int p = 2;
    int[] sA = new int[]{this.m, this.n, this.p};
    int stride1 = this.p;
    int stride2 = this.n * this.p;
    ArrayDouble A = new ArrayDouble(this.sA);
    Index ima;
    int i;
    int j;
    int k;
    ArrayDouble secA;
    int m1 = 2;
    int m2 = 3;
    int mlen = this.m2 - this.m1 + 1;

    public TestIterator(String name) {
        super(name);
    }

    public void setUp() {
        this.ima = this.A.getIndex();
        for (int i = 0; i < this.m; ++i) {
            this.ima.set0(i);
            this.j = 0;
            while (this.j < this.n) {
                this.ima.set1(this.j);
                this.k = 0;
                while (this.k < this.p) {
                    this.ima.set2(this.k);
                    this.A.setDouble(this.ima, (double)(i * 100 + this.j * 10 + this.k));
                    ++this.k;
                }
                ++this.j;
            }
        }
    }

    public void testFastIter() {
        int count = 0;
        IndexIterator iter = this.A.getIndexIterator();
        while (iter.hasNext()) {
            iter.getDoubleNext();
            ++count;
        }
        assert (count == this.n * this.m * this.p);
        iter = this.A.getIndexIterator();
        this.i = 0;
        while (this.i < this.m) {
            this.j = 0;
            while (this.j < this.n) {
                this.k = 0;
                while (this.k < this.p) {
                    double val = iter.getDoubleNext();
                    double myVal = this.i * 100 + this.j * 10 + this.k;
                    assert (val == myVal);
                    ++this.k;
                }
                ++this.j;
            }
            ++this.i;
        }
    }

    public void testScalerIter() {
        ArrayDouble.D0 scalar = new ArrayDouble.D0();
        scalar.set(10.0);
        int count = 0;
        double sum = 0.0;
        IndexIterator iter = scalar.getIndexIterator();
        while (iter.hasNext()) {
            sum += iter.getDoubleNext();
            ++count;
        }
        assert (count == 1);
        assert (sum == 10.0);
        System.out.println(" testScalerIter");
    }

    public void testSectionIter() {
        try {
            this.secA = (ArrayDouble)this.A.section(Range.parseSpec((String)(this.m1 + ":" + this.m2 + ",:,:")));
        }
        catch (InvalidRangeException e) {
            System.out.println("testMAsection failed == " + (Object)((Object)e));
            return;
        }
        int count = 0;
        IndexIterator iter = this.secA.getIndexIterator();
        while (iter.hasNext()) {
            iter.getDoubleNext();
            ++count;
        }
        assert (count == this.n * this.mlen * this.p);
        iter = this.secA.getIndexIterator();
        this.i = 0;
        while (this.i < this.mlen) {
            this.j = 0;
            while (this.j < this.n) {
                this.k = 0;
                while (this.k < this.p) {
                    double val = iter.getDoubleNext();
                    double myVal = (double)(this.i + this.m1) * 100.0 + (double)(this.j * 10) + (double)this.k;
                    assert (val == (double)((this.i + this.m1) * 100 + this.j * 10 + this.k));
                    ++this.k;
                }
                ++this.j;
            }
            ++this.i;
        }
    }

    public void testSectionRank2() {
        ArrayDouble secA2;
        try {
            secA2 = (ArrayDouble)this.A.section(Range.parseSpec((String)"2,:,:"));
        }
        catch (InvalidRangeException e) {
            System.out.println("testMAsectionrank2 failed == " + (Object)((Object)e));
            return;
        }
        IndexIterator iter = secA2.getIndexIterator();
        this.i = 0;
        while (this.i < this.n) {
            this.j = 0;
            while (this.j < this.p) {
                double val = iter.getDoubleNext();
                assert (val == (double)(200 + this.i * 10 + this.j));
                ++this.j;
            }
            ++this.i;
        }
    }
}

