/*
 * Decompiled with CFR 0.152.
 */
package ucar.ma2;

import java.io.IOException;
import java.io.PrintWriter;
import java.util.List;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.ArrayDouble;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.MAMath;
import ucar.ma2.Range;
import ucar.ma2.Section;
import ucar.nc2.NCdumpW;

public class TestMAMath
extends TestCase {
    int m = 4;
    int n = 3;
    int p = 2;
    int[] sA = new int[]{this.m, this.n, this.p};
    int stride1 = this.p;
    int stride2 = this.n * this.p;
    ArrayDouble A = new ArrayDouble(this.sA);
    int i;
    int j;
    int k;
    ArrayDouble secA;
    int m1 = 2;
    int m2 = 3;
    int mlen = this.m2 - this.m1 + 1;

    public TestMAMath(String name) {
        super(name);
    }

    public void setUp() {
        Index ima = this.A.getIndex();
        this.i = 0;
        while (this.i < this.m) {
            this.j = 0;
            while (this.j < this.n) {
                this.k = 0;
                while (this.k < this.p) {
                    this.A.setDouble(ima.set(this.i, this.j, this.k), (double)(this.i * 100 + this.j * 10 + this.k));
                    ++this.k;
                }
                ++this.j;
            }
            ++this.i;
        }
        try {
            this.secA = (ArrayDouble)this.A.section(new Section(this.m1 + ":" + this.m2 + ",:,:").getRanges());
        }
        catch (InvalidRangeException e) {
            TestMAMath.fail((String)("testMAsection failed == " + (Object)((Object)e)));
            return;
        }
    }

    public void testConformable() {
        System.out.println("test MAMath conformable ");
        int[] a1 = new int[]{1, 3, 1, 5, 1, 1};
        int[] b1 = new int[]{3, 5};
        assert (MAMath.conformable((int[])b1, (int[])a1));
        assert (MAMath.conformable((int[])a1, (int[])b1));
        int[] a2 = new int[]{1, 3, 1, 5, 1, 1};
        int[] b2 = new int[]{1, 5, 3};
        assert (!MAMath.conformable((int[])b2, (int[])a2));
        assert (!MAMath.conformable((int[])a2, (int[])b2));
        int[] a3 = new int[]{1, 3, 1, 5, 1, 1};
        int[] b3 = new int[]{3, 5, 1, 1, 1, 2};
        assert (!MAMath.conformable((int[])b3, (int[])a3));
        assert (!MAMath.conformable((int[])a3, (int[])b3));
        int[] a4 = new int[]{1, 3, 1, 5, 1, 1, 7};
        int[] b4 = new int[]{1, 1, 3, 5, 1, 7, 1, 1};
        assert (MAMath.conformable((int[])b4, (int[])a4));
        assert (MAMath.conformable((int[])a4, (int[])b4));
    }

    public void testSet() {
        System.out.println("test MAMath set/sum ");
        try {
            MAMath.setDouble((Array)this.A, (double)1.0);
            assert (MAMath.sumDouble((Array)this.A) == (double)this.m * (double)this.n * (double)this.p);
        }
        catch (Exception e) {
            TestMAMath.fail((String)("testSet Exception" + e));
        }
        try {
            assert (MAMath.sumDouble((Array)this.secA) == (double)this.mlen * (double)this.n * (double)this.p);
        }
        catch (Exception e) {
            TestMAMath.fail((String)("testSet2 Exception" + e));
        }
    }

    public void testAdd() {
        System.out.println("test MAMath add ");
        int dim0 = 2;
        int dim1 = 3;
        int[] shape = new int[]{dim0, dim1};
        ArrayDouble A = new ArrayDouble(shape);
        ArrayDouble B = new ArrayDouble(shape);
        try {
            MAMath.setDouble((Array)A, (double)1.0);
            MAMath.setDouble((Array)B, (double)22.0);
            MAMath.addDouble((Array)A, (Array)A, (Array)A);
            Array result = MAMath.add((Array)A, (Array)B);
            IndexIterator iterR = result.getIndexIterator();
            while (iterR.hasNext()) {
                double vala = iterR.getDoubleNext();
                assert (vala == 24.0);
            }
        }
        catch (Exception e) {
            TestMAMath.fail((String)("testAdd Exception" + e));
        }
    }

    public void testSectionCopy() {
        System.out.println("test MAMath section copy ");
        int dim0 = 2;
        int dim1 = 3;
        int dim2 = 4;
        int[] shape = new int[]{dim0, dim1, dim2};
        ArrayDouble A = new ArrayDouble(shape);
        try {
            MAMath.setDouble((Array)A, (double)1.0);
            assert (MAMath.sumDouble((Array)A) == (double)dim0 * (double)dim1 * (double)dim2);
            List ranges = Range.parseSpec((String)":,:,1");
            Array secA = A.section(ranges);
            MAMath.setDouble((Array)secA, (double)0.0);
            assert (MAMath.sumDouble((Array)secA) == 0.0);
            assert (MAMath.sumDouble((Array)A) == (double)(dim0 * dim1 * dim2 - dim0 * dim1));
            MAMath.setDouble((Array)A, (double)1.0);
            assert (MAMath.sumDouble((Array)A) == (double)dim0 * (double)dim1 * (double)dim2);
            Array copyA = A.section(ranges).copy();
            MAMath.setDouble((Array)copyA, (double)0.0);
            assert (MAMath.sumDouble((Array)A) == (double)dim0 * (double)dim1 * (double)dim2);
        }
        catch (InvalidRangeException e) {
            TestMAMath.fail((String)("testSectionCopy InvalidRangeException " + (Object)((Object)e)));
        }
        catch (Exception e) {
            TestMAMath.fail((String)("testSectionCopy Exception" + e));
        }
    }

    public void testSectionIterator() throws InvalidRangeException, IOException {
        ArrayDouble data = this.A;
        NCdumpW.printArray((Array)this.A, (String)"full", (PrintWriter)new PrintWriter(System.out), null);
        Section section = new Section("1,:,:");
        Array datasection = data.sectionNoReduce(section.getRanges());
        NCdumpW.printArray((Array)datasection, (String)"section", (PrintWriter)new PrintWriter(System.out), null);
        double sum = MAMath.sumDouble((Array)datasection);
        System.out.printf(" sum=%f%n ", sum);
        assert (sum == 663.0);
    }
}

