/*
 * Decompiled with CFR 0.152.
 */
package ucar.ma2;

import junit.framework.TestCase;
import ucar.ma2.ArrayDouble;
import ucar.ma2.Index;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;
import ucar.ma2.Section;

public class TestSection
extends TestCase {
    int m = 4;
    int n = 5;
    int p = 6;
    int[] sA = new int[]{this.m, this.n, this.p};
    int stride1 = this.p;
    int stride2 = this.n * this.p;
    ArrayDouble A = new ArrayDouble(this.sA);
    int i;
    int j;
    int k;
    ArrayDouble secA;
    int m1 = 2;
    int m2 = 3;
    int mlen = this.m2 - this.m1 + 1;

    public TestSection(String name) {
        super(name);
    }

    public void setUp() throws InvalidRangeException {
        Index ima = this.A.getIndex();
        this.i = 0;
        while (this.i < this.m) {
            ima.set0(this.i);
            this.j = 0;
            while (this.j < this.n) {
                ima.set1(this.j);
                this.k = 0;
                while (this.k < this.p) {
                    ima.set2(this.k);
                    this.A.setDouble(ima, (double)(this.i * 100 + this.j * 10 + this.k));
                    ++this.k;
                }
                ++this.j;
            }
            ++this.i;
        }
        Range[] ranges = new Range[]{new Range(this.m1, this.m2), null, null};
        this.secA = (ArrayDouble)this.A.section(Range.parseSpec((String)(this.m1 + ":" + this.m2 + ",:,:")));
    }

    public void testSection() {
        Index ima = this.secA.getIndex();
        int[] shape = ima.getShape();
        assert (ima.getRank() == 3);
        assert (ima.getSize() == (long)(this.mlen * this.n * this.p));
        assert (shape[0] == this.mlen);
        assert (shape[1] == this.n);
        assert (shape[2] == this.p);
    }

    public void testSectionRead() {
        Index ima = this.secA.getIndex();
        this.i = 0;
        while (this.i < this.mlen) {
            this.j = 0;
            while (this.j < this.n) {
                this.k = 0;
                while (this.k < this.p) {
                    double val = this.secA.getDouble(ima.set(this.i, this.j, this.k));
                    assert (val == (double)((this.i + this.m1) * 100 + this.j * 10 + this.k));
                    ++this.k;
                }
                ++this.j;
            }
            ++this.i;
        }
        System.out.println("testSection ");
    }

    public void testIter() {
        IndexIterator iter = this.secA.getIndexIterator();
        this.i = 0;
        while (this.i < this.mlen) {
            this.j = 0;
            while (this.j < this.n) {
                this.k = 0;
                while (this.k < this.p) {
                    double val = iter.getDoubleNext();
                    double myVal = (double)(this.i + this.m1) * 100.0 + (double)(this.j * 10) + (double)this.k;
                    assert (val == (double)((this.i + this.m1) * 100 + this.j * 10 + this.k));
                    ++this.k;
                }
                ++this.j;
            }
            ++this.i;
        }
        System.out.println("testSectionIter ");
    }

    public void testRangeIterator() {
        IndexIterator iter;
        try {
            iter = this.A.getRangeIterator(Range.parseSpec((String)(this.m1 + ":" + this.m2 + ",:,:")));
        }
        catch (InvalidRangeException e) {
            System.out.println("testMAsection failed == " + (Object)((Object)e));
            return;
        }
        this.i = 0;
        while (this.i < this.mlen) {
            this.j = 0;
            while (this.j < this.n) {
                this.k = 0;
                while (this.k < this.p) {
                    double val = iter.getDoubleNext();
                    double myVal = (double)(this.i + this.m1) * 100.0 + (double)(this.j * 10) + (double)this.k;
                    assert (val == (double)((this.i + this.m1) * 100 + this.j * 10 + this.k));
                    ++this.k;
                }
                ++this.j;
            }
            ++this.i;
        }
        System.out.println("testRangeIterator ");
    }

    public void testSectionReduce() {
        ArrayDouble secA2;
        try {
            secA2 = (ArrayDouble)this.A.section(Range.parseSpec((String)"2,:,:"));
        }
        catch (InvalidRangeException e) {
            System.out.println("testSectionReduce failed == " + (Object)((Object)e));
            return;
        }
        Index ima = secA2.getIndex();
        int[] shape = ima.getShape();
        assert (ima.getRank() == 2);
        assert (ima.getSize() == (long)(this.n * this.p));
        assert (shape[0] == this.n);
        assert (shape[1] == this.p);
        this.i = 0;
        while (this.i < this.n) {
            this.j = 0;
            while (this.j < this.p) {
                ima.set(this.i, this.j);
                double val = secA2.getDouble(ima);
                assert (val == (double)(200 + this.i * 10 + this.j));
                ++this.j;
            }
            ++this.i;
        }
        IndexIterator iter = secA2.getIndexIterator();
        this.i = 0;
        while (this.i < this.n) {
            this.j = 0;
            while (this.j < this.p) {
                double val = iter.getDoubleNext();
                assert (val == (double)(200 + this.i * 10 + this.j));
                ++this.j;
            }
            ++this.i;
        }
        System.out.println("testSectionReduce ");
    }

    public void testSectionNoReduce() throws InvalidRangeException {
        ArrayDouble secA2 = (ArrayDouble)this.A.sectionNoReduce(Range.parseSpec((String)"2,:,:"));
        Index ima = secA2.getIndex();
        int[] shape = ima.getShape();
        assert (ima.getRank() == 3);
        assert (ima.getSize() == (long)(this.n * this.p));
        assert (shape[0] == 1);
        assert (shape[1] == this.n);
        assert (shape[2] == this.p);
        this.i = 0;
        while (this.i < this.n) {
            this.j = 0;
            while (this.j < this.p) {
                ima.set(0, this.i, this.j);
                double val = secA2.getDouble(ima);
                assert (val == (double)(200 + this.i * 10 + this.j));
                ++this.j;
            }
            ++this.i;
        }
        IndexIterator iter = secA2.getIndexIterator();
        this.i = 0;
        while (this.i < this.n) {
            this.j = 0;
            while (this.j < this.p) {
                double val = iter.getDoubleNext();
                assert (val == (double)(200 + this.i * 10 + this.j));
                ++this.j;
            }
            ++this.i;
        }
        System.out.println("testSectionNoReduce ");
    }

    public void testDoubleRange() throws InvalidRangeException {
        ArrayDouble secA2 = (ArrayDouble)this.A.section(Range.parseSpec((String)"2,:,:"));
        ArrayDouble secA1 = (ArrayDouble)secA2.section(Range.parseSpec((String)":,1"));
        Index ima = secA1.getIndex();
        int[] shape = ima.getShape();
        assert (ima.getRank() == 1);
        assert (ima.getSize() == (long)this.n);
        assert (shape[0] == this.n);
        this.j = 0;
        while (this.j < this.n) {
            ima.set(this.j);
            double val = secA1.getDouble(ima);
            assert (val == (double)(200 + this.j * 10 + 1));
            ++this.j;
        }
        IndexIterator iter = secA1.getIndexIterator();
        this.i = 0;
        while (this.i < this.n) {
            double val = iter.getDoubleNext();
            assert (val == (double)(200 + this.i * 10 + 1));
            ++this.i;
        }
        System.out.println("testDoubleRange");
    }

    public void testDoubleRange2() throws InvalidRangeException {
        ArrayDouble secA2 = (ArrayDouble)this.A.section(Range.parseSpec((String)"2,:,:"));
        secA2 = (ArrayDouble)secA2.reduce();
        ArrayDouble secA1 = (ArrayDouble)secA2.section(Range.parseSpec((String)":,1"));
        Index ima = secA1.getIndex();
        int[] shape = ima.getShape();
        assert (ima.getRank() == 1);
        assert (ima.getSize() == (long)this.n);
        assert (shape[0] == this.n);
        this.j = 0;
        while (this.j < this.n) {
            ima.set(this.j);
            double val = secA1.getDouble(ima);
            assert (val == (double)(200 + this.j * 10 + 1));
            ++this.j;
        }
        IndexIterator iter = secA1.getIndexIterator();
        this.i = 0;
        while (this.i < this.n) {
            double val = iter.getDoubleNext();
            assert (val == (double)(200 + this.i * 10 + 1));
            ++this.i;
        }
        System.out.println("testDoubleRange 2");
    }

    public void testRange3() throws InvalidRangeException {
        ArrayDouble secA2 = (ArrayDouble)this.A.section(Range.parseSpec((String)("1:" + (this.m - 2) + ",0:" + (this.n - 2) + ",1:" + (this.p - 1))));
        Index imaOrg = this.A.getIndex();
        Index ima = secA2.getIndex();
        int[] shape = ima.getShape();
        assert (ima.getRank() == 3);
        assert (ima.getSize() == (long)((this.m - 2) * (this.n - 1) * (this.p - 1)));
        assert (shape[0] == this.m - 2);
        assert (shape[1] == this.n - 1);
        assert (shape[2] == this.p - 1);
        this.i = 0;
        while (this.i < this.m - 2) {
            this.j = 0;
            while (this.j < this.n - 1) {
                this.k = 0;
                while (this.k < this.p - 1) {
                    ima.set(this.i, this.j);
                    double val = secA2.getDouble(ima.set(this.i, this.j, this.k));
                    double valOrg = this.A.getDouble(imaOrg.set(this.i + 1, this.j, this.k + 1));
                    assert (val == valOrg);
                    ++this.k;
                }
                ++this.j;
            }
            ++this.i;
        }
        System.out.println("testRange 3");
    }

    public void testSlice() {
        ArrayDouble secA2 = (ArrayDouble)this.A.slice(0, 2);
        Index ima = secA2.getIndex();
        ima = secA2.getIndex();
        int[] shape = ima.getShape();
        assert (ima.getRank() == 2);
        assert (ima.getSize() == (long)(this.n * this.p));
        assert (shape[0] == this.n);
        assert (shape[1] == this.p);
        this.i = 0;
        while (this.i < this.n) {
            this.j = 0;
            while (this.j < this.p) {
                ima.set(this.i, this.j);
                double val = secA2.getDouble(ima);
                assert (val == (double)(200 + this.i * 10 + this.j));
                ++this.j;
            }
            ++this.i;
        }
        IndexIterator iter = secA2.getIndexIterator();
        this.i = 0;
        while (this.i < this.n) {
            this.j = 0;
            while (this.j < this.p) {
                double val = iter.getDoubleNext();
                assert (val == (double)(200 + this.i * 10 + this.j));
                ++this.j;
            }
            ++this.i;
        }
        System.out.println("testSlice ");
    }

    public void testSliceOne() throws InvalidRangeException {
        ArrayDouble secA1 = (ArrayDouble)this.A.sectionNoReduce(Range.parseSpec((String)("1,0:" + (this.n - 2) + ",1:" + (this.p - 1))));
        int[] shape = secA1.getShape();
        assert (secA1.getRank() == 3);
        assert (secA1.getSize() == (long)((this.n - 1) * (this.p - 1)));
        assert (shape[0] == 1);
        assert (shape[1] == this.n - 1);
        assert (shape[2] == this.p - 1);
        ArrayDouble secA2 = (ArrayDouble)secA1.slice(1, 2);
        shape = secA2.getShape();
        assert (secA2.getRank() == 2);
        assert (secA2.getSize() == (long)(this.p - 1));
        assert (shape[0] == 1);
        assert (shape[1] == this.p - 1);
        Index imaOrg = this.A.getIndex();
        Index ima = secA2.getIndex();
        this.k = 0;
        while (this.k < this.p - 1) {
            double val = secA2.getDouble(ima.set(0, this.k));
            double valOrg = this.A.getDouble(imaOrg.set(1, 2, this.k + 1));
            assert (val == valOrg);
            ++this.k;
        }
        System.out.println("testSlice with length 1 dim");
    }

    public void testSectionCopy() throws InvalidRangeException {
        ArrayDouble secA2 = (ArrayDouble)this.A.section(Range.parseSpec((String)("1:" + (this.m - 2) + ",0:" + (this.n - 2) + ",1:" + (this.p - 1)))).copy();
        Index imaOrg = this.A.getIndex();
        Index ima = secA2.getIndex();
        int[] shape = ima.getShape();
        assert (ima.getRank() == 3);
        assert (ima.getSize() == (long)((this.m - 2) * (this.n - 1) * (this.p - 1)));
        assert (shape[0] == this.m - 2);
        assert (shape[1] == this.n - 1);
        assert (shape[2] == this.p - 1);
        assert (secA2 instanceof ArrayDouble.D3);
        this.i = 0;
        while (this.i < this.m - 2) {
            this.j = 0;
            while (this.j < this.n - 1) {
                this.k = 0;
                while (this.k < this.p - 1) {
                    ima.set(this.i, this.j);
                    double val = secA2.getDouble(ima.set(this.i, this.j, this.k));
                    secA2.setDouble(ima, 0.0);
                    double valOrg = this.A.getDouble(imaOrg.set(this.i + 1, this.j, this.k + 1));
                    assert (val == valOrg);
                    ++this.k;
                }
                ++this.j;
            }
            ++this.i;
        }
        System.out.println("test sectionCopy");
    }

    public void testIntersect() throws InvalidRangeException {
        Section have = new Section("101:101,0:1919");
        Section want = new Section("100:229:3,100:191:7");
        boolean b = have.intersects(want);
        assert (!b);
    }

    public void testIntersectWithStrides() throws InvalidRangeException {
        Section have = new Section("121:121:1,0:1919:1");
        Section want = new Section("100:229:3,100:191:7");
        Section intersectCorrect = new Section("121:121:3,100:191:7");
        Section intersect = have.intersect(want);
        assert (intersect.equals((Object)intersectCorrect));
        int offset = want.offset(intersect);
        assert (offset == 98) : offset;
    }
}

