/*
 * Decompiled with CFR 0.152.
 */
package ucar.ma2;

import java.io.IOException;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.ArrayStructure;
import ucar.ma2.ArrayStructureMA;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.StructureMembers;
import ucar.ma2.TestStructureArray;

public class TestStructureArrayMA
extends TestCase {
    public TestStructureArrayMA(String name) {
        super(name);
    }

    public void testMA() throws IOException, InvalidRangeException {
        StructureMembers members = new StructureMembers("s");
        StructureMembers.Member m = members.addMember("f1", "desc", "units", DataType.FLOAT, new int[]{1});
        Array data = Array.factory((DataType)DataType.FLOAT, (int[])new int[]{4});
        m.setDataArray(data);
        this.fill(data);
        m = members.addMember("f2", "desc", "units", DataType.SHORT, new int[]{3});
        data = Array.factory((DataType)DataType.SHORT, (int[])new int[]{4, 3});
        m.setDataArray(data);
        this.fill(data);
        m = members.addMember("nested1", "desc", "units", DataType.STRUCTURE, new int[]{9});
        data = this.makeNested1(m);
        m.setDataArray(data);
        ArrayStructureMA as = new ArrayStructureMA(members, new int[]{4});
        new TestStructureArray().testArrayStructure((ArrayStructure)as);
        StructureMembers.Member f2 = as.getStructureMembers().findMember("f2");
        short[] f2data = as.getJavaArrayShort(2, f2);
        assert (f2data[0] == 20);
        assert (f2data[1] == 21);
        assert (f2data[2] == 22);
        StructureMembers.Member nested1 = as.getStructureMembers().findMember("nested1");
        ArrayStructure nested1Data = as.getArrayStructure(2, nested1);
        StructureMembers.Member g1 = nested1Data.getStructureMembers().findMember("g1");
        int g1data = nested1Data.getScalarInt(6, g1);
        assert (g1data == 26);
        StructureMembers.Member nested2 = nested1Data.getStructureMembers().findMember("nested2");
        ArrayStructure nested2Data = nested1Data.getArrayStructure(6, nested2);
        StructureMembers.Member h1 = nested2Data.getStructureMembers().findMember("h1");
        int val = nested2Data.getScalarInt(4, h1);
        assert (val == 264);
    }

    public ArrayStructure makeNested1(StructureMembers.Member parent) throws IOException, InvalidRangeException {
        StructureMembers members = new StructureMembers(parent.getName());
        parent.setStructureMembers(members);
        StructureMembers.Member m = members.addMember("g1", "desc", "units", DataType.INT, new int[]{1});
        Array data = Array.factory((DataType)DataType.INT, (int[])new int[]{4, 9});
        m.setDataArray(data);
        this.fill(data);
        m = members.addMember("g2", "desc", "units", DataType.DOUBLE, new int[]{2});
        data = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{4, 9, 2});
        m.setDataArray(data);
        this.fill(data);
        m = members.addMember("g3", "desc", "units", DataType.DOUBLE, new int[]{3, 4});
        data = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{4, 9, 3, 4});
        m.setDataArray(data);
        this.fill(data);
        m = members.addMember("nested2", "desc", "units", DataType.STRUCTURE, new int[]{7});
        data = this.makeNested2(m);
        m.setDataArray(data);
        return new ArrayStructureMA(members, new int[]{4, 9});
    }

    public ArrayStructure makeNested2(StructureMembers.Member parent) throws IOException, InvalidRangeException {
        StructureMembers members = new StructureMembers(parent.getName());
        parent.setStructureMembers(members);
        StructureMembers.Member m = members.addMember("h1", "desc", "units", DataType.INT, new int[]{1});
        Array data = Array.factory((DataType)DataType.INT, (int[])new int[]{4, 9, 7});
        m.setDataArray(data);
        this.fill(data);
        m = members.addMember("h2", "desc", "units", DataType.DOUBLE, new int[]{2});
        data = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{4, 9, 7, 2});
        m.setDataArray(data);
        this.fill(data);
        return new ArrayStructureMA(members, new int[]{4, 9, 7});
    }

    private void fill(Array a) {
        IndexIterator ii = a.getIndexIterator();
        while (ii.hasNext()) {
            ii.getIntNext();
            int[] counter = ii.getCurrentCounter();
            int value = 0;
            for (int i = 0; i < counter.length; ++i) {
                value = value * 10 + counter[i];
            }
            ii.setIntCurrent(value);
        }
    }
}

