/*
 * Decompiled with CFR 0.152.
 */
package ucar.ma2;

import java.io.IOException;
import junit.framework.TestCase;
import ucar.ma2.Array;
import ucar.ma2.ArrayStructure;
import ucar.ma2.ArrayStructureW;
import ucar.ma2.DataType;
import ucar.ma2.IndexIterator;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.StructureData;
import ucar.ma2.StructureDataW;
import ucar.ma2.StructureMembers;
import ucar.ma2.TestStructureArray;

public class TestStructureArrayW
extends TestCase {
    public TestStructureArrayW(String name) {
        super(name);
    }

    public void testW() throws IOException, InvalidRangeException {
        StructureMembers members = new StructureMembers("s");
        StructureMembers.Member f1 = members.addMember("f1", "desc", "units", DataType.FLOAT, new int[]{1});
        members.addMember(f1);
        StructureMembers.Member f2 = members.addMember("f2", "desc", "units", DataType.SHORT, new int[]{3});
        members.addMember(f2);
        StructureMembers.Member nested1 = members.addMember("nested1", "desc", "units", DataType.STRUCTURE, new int[]{9});
        members.addMember(nested1);
        int size = 4;
        StructureData[] sdata = new StructureData[size];
        for (int i = 0; i < size; ++i) {
            StructureDataW sdw = new StructureDataW(members);
            sdata[i] = sdw;
            Array data = Array.factory((DataType)DataType.FLOAT, (int[])new int[]{1});
            sdw.setMemberData(f1, data);
            this.fill(data, i);
            data = Array.factory((DataType)DataType.SHORT, (int[])new int[]{3});
            sdw.setMemberData(f2, data);
            this.fill(data, i * 2);
            data = this.makeNested1(nested1, 9, 7);
            sdw.setMemberData(nested1, data);
        }
        ArrayStructureW as = new ArrayStructureW(members, new int[]{4}, sdata);
        new TestStructureArray().testArrayStructure((ArrayStructure)as);
        short[] f2data = as.getJavaArrayShort(1, f2);
        assert (f2data[0] == 2);
        assert (f2data[1] == 3);
        assert (f2data[2] == 4);
        ArrayStructure nested1Data = as.getArrayStructure(2, nested1);
        StructureMembers.Member g1 = nested1Data.getStructureMembers().findMember("g1");
        int g1data = nested1Data.getScalarInt(3, g1);
        assert (g1data == 66);
        StructureMembers.Member g3 = nested1Data.getStructureMembers().findMember("g3");
        double[] g3data = nested1Data.getJavaArrayDouble(3, g3);
        assert (g3data[0] == 73326.0);
        StructureMembers.Member nested2 = nested1Data.getStructureMembers().findMember("nested2");
        ArrayStructure nested2Data = nested1Data.getArrayStructure(6, nested2);
        StructureMembers.Member h1 = nested2Data.getStructureMembers().findMember("h1");
        int val = nested2Data.getScalarInt(4, h1);
        assert (val == 1218) : val;
        StructureMembers.Member h2 = nested2Data.getStructureMembers().findMember("h2");
        double[] h2data = nested2Data.getJavaArrayDouble(4, h2);
        assert (h2data[0] == 12018.0);
        assert (h2data[1] == 12019.0);
    }

    public Array makeNested1(StructureMembers.Member nested1, int size1, int size2) throws IOException, InvalidRangeException {
        StructureMembers members = new StructureMembers(nested1.getName());
        nested1.setStructureMembers(members);
        StructureMembers.Member g1 = members.addMember("g1", "desc", "units", DataType.INT, new int[]{1});
        members.addMember(g1);
        StructureMembers.Member g2 = members.addMember("g2", "desc", "units", DataType.DOUBLE, new int[]{2});
        members.addMember(g2);
        StructureMembers.Member g3 = members.addMember("g3", "desc", "units", DataType.DOUBLE, new int[]{3, 4});
        members.addMember(g3);
        StructureMembers.Member nested2 = members.addMember("nested2", "desc", "units", DataType.STRUCTURE, new int[]{7});
        members.addMember(nested2);
        StructureData[] sdata = new StructureData[size1];
        for (int i = 0; i < size1; ++i) {
            StructureDataW sdw = new StructureDataW(members);
            sdata[i] = sdw;
            Array data = Array.factory((DataType)DataType.INT, (int[])new int[]{1});
            sdw.setMemberData(g1, data);
            this.fill(data, i * 22);
            data = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{2});
            sdw.setMemberData(g2, data);
            this.fill(data, i * 222);
            data = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{3, 4});
            sdw.setMemberData(g3, data);
            this.fill(data, i * 2222);
            data = this.makeNested2(nested2, i, size2);
            sdw.setMemberData(nested2, data);
        }
        return new ArrayStructureW(members, new int[]{size1}, sdata);
    }

    public Array makeNested2(StructureMembers.Member nested, int who, int size) throws IOException, InvalidRangeException {
        StructureMembers members = new StructureMembers(nested.getName());
        nested.setStructureMembers(members);
        StructureMembers.Member h1 = members.addMember("h1", "desc", "units", DataType.INT, new int[]{1});
        members.addMember(h1);
        StructureMembers.Member h2 = members.addMember("h2", "desc", "units", DataType.DOUBLE, new int[]{2});
        members.addMember(h2);
        StructureData[] sdata = new StructureData[size];
        for (int i = 0; i < size; ++i) {
            StructureDataW sdw = new StructureDataW(members);
            sdata[i] = sdw;
            Array data = Array.factory((DataType)DataType.INT, (int[])new int[]{1});
            sdw.setMemberData(h1, data);
            this.fill(data, i * 303 + who);
            data = Array.factory((DataType)DataType.DOUBLE, (int[])new int[]{2});
            sdw.setMemberData(h2, data);
            this.fill(data, i * 3003 + who);
        }
        return new ArrayStructureW(members, new int[]{size}, sdata);
    }

    private void fill(Array a, int start) {
        IndexIterator ii = a.getIndexIterator();
        while (ii.hasNext()) {
            ii.getIntNext();
            int[] counter = ii.getCurrentCounter();
            int value = 0;
            for (int i = 0; i < counter.length; ++i) {
                value = start + value * 10 + counter[i];
            }
            ii.setIntCurrent(value);
        }
    }
}

