/*
 * Decompiled with CFR 0.152.
 */
package ucar.ma2;

import junit.framework.TestCase;
import ucar.ma2.ArrayDouble;
import ucar.ma2.Index;
import ucar.ma2.InvalidRangeException;
import ucar.ma2.Range;

public class TestTxCompose
extends TestCase {
    int m = 4;
    int n = 3;
    int p = 2;
    int[] sA = new int[]{this.m, this.n, this.p};
    int stride1 = this.p;
    int stride2 = this.n * this.p;
    ArrayDouble A = new ArrayDouble(this.sA);
    int i;
    int j;
    int k;
    ArrayDouble secA;
    int m1 = 2;
    int m2 = 3;
    int mlen = this.m2 - this.m1 + 1;

    public TestTxCompose(String name) {
        super(name);
    }

    public void setUp() {
        Index ima = this.A.getIndex();
        this.i = 0;
        while (this.i < this.m) {
            this.j = 0;
            while (this.j < this.n) {
                this.k = 0;
                while (this.k < this.p) {
                    this.A.setDouble(ima.set(this.i, this.j, this.k), (double)(this.i * 100 + this.j * 10 + this.k));
                    ++this.k;
                }
                ++this.j;
            }
            ++this.i;
        }
        try {
            Range[] ranges = new Range[]{new Range(this.m1, this.m2), null, null};
            this.secA = (ArrayDouble)this.A.section(Range.parseSpec((String)(this.m1 + ":" + this.m2 + ",:,:")));
        }
        catch (InvalidRangeException e) {
            TestTxCompose.fail((String)("testMAsection failed == " + (Object)((Object)e)));
            return;
        }
    }

    public void testFlip() {
        ArrayDouble flipA = (ArrayDouble)this.A.flip(1);
        Index ima = flipA.getIndex();
        this.i = 0;
        while (this.i < this.m) {
            this.j = 0;
            while (this.j < this.n) {
                this.k = 0;
                while (this.k < this.p) {
                    double val = flipA.getDouble(ima.set(this.i, this.j, this.k));
                    double myVal = this.i * 100 + (this.n - this.j - 1) * 10 + this.k;
                    assert (val == myVal);
                    ++this.k;
                }
                ++this.j;
            }
            ++this.i;
        }
        System.out.println("testFlip");
    }

    public void testTranspose() {
        ArrayDouble trA = (ArrayDouble)this.A.transpose(0, 1);
        Index ima = trA.getIndex();
        this.i = 0;
        while (this.i < this.m) {
            this.j = 0;
            while (this.j < this.n) {
                this.k = 0;
                while (this.k < this.p) {
                    double val = trA.getDouble(ima.set(this.j, this.i, this.k));
                    double myVal = this.i * 100 + this.j * 10 + this.k;
                    assert (val == myVal);
                    ++this.k;
                }
                ++this.j;
            }
            ++this.i;
        }
        System.out.println("testTranspose");
    }

    public void testPermute() {
        ArrayDouble pA = (ArrayDouble)this.A.permute(new int[]{2, 0, 1});
        Index ima = pA.getIndex();
        this.i = 0;
        while (this.i < this.m) {
            this.j = 0;
            while (this.j < this.n) {
                this.k = 0;
                while (this.k < this.p) {
                    double val = pA.getDouble(ima.set(this.k, this.i, this.j));
                    double myVal = this.i * 100 + this.j * 10 + this.k;
                    assert (val == myVal);
                    ++this.k;
                }
                ++this.j;
            }
            ++this.i;
        }
        System.out.println("testPermute");
    }

    public void testCompose() {
        ArrayDouble trA = (ArrayDouble)this.A.transpose(0, 1);
        ArrayDouble composeA = (ArrayDouble)trA.flip(1);
        Index ima = composeA.getIndex();
        this.i = 0;
        while (this.i < this.m) {
            this.j = 0;
            while (this.j < this.n) {
                this.k = 0;
                while (this.k < this.p) {
                    double val = composeA.getDouble(ima.set(this.j, this.i, this.k));
                    double myVal = (this.m - this.i - 1) * 100 + this.j * 10 + this.k;
                    assert (val == myVal);
                    ++this.k;
                }
                ++this.j;
            }
            ++this.i;
        }
        System.out.println("testCompose transpose/flip");
    }

    public void testCompose2() {
        ArrayDouble flipA = (ArrayDouble)this.A.flip(1);
        ArrayDouble composeA = (ArrayDouble)flipA.transpose(0, 1);
        Index ima = composeA.getIndex();
        this.i = 0;
        while (this.i < this.m) {
            this.j = 0;
            while (this.j < this.n) {
                this.k = 0;
                while (this.k < this.p) {
                    double val = composeA.getDouble(ima.set(this.j, this.i, this.k));
                    double myVal = this.i * 100 + (this.n - this.j - 1) * 10 + this.k;
                    assert (val == myVal);
                    ++this.k;
                }
                ++this.j;
            }
            ++this.i;
        }
        System.out.println("testCompose flip/transpose");
    }

    public void testCompose3() {
        ArrayDouble secA2;
        int ival = 2;
        try {
            secA2 = (ArrayDouble)this.A.section(Range.parseSpec((String)(ival + ",:,:")));
        }
        catch (InvalidRangeException e) {
            System.out.println("testDoubleRange2 failed == " + (Object)((Object)e));
            return;
        }
        ArrayDouble composeA = (ArrayDouble)secA2.permute(new int[]{1, 0});
        Index ima = composeA.getIndex();
        this.j = 0;
        while (this.j < this.n) {
            this.k = 0;
            while (this.k < this.p) {
                double val = composeA.getDouble(ima.set(this.k, this.j));
                double myVal = ival * 100 + this.j * 10 + this.k;
                assert (val == myVal);
                ++this.k;
            }
            ++this.j;
        }
        System.out.println("testCompose section/permute");
    }
}

