/*
 * Decompiled with CFR 0.152.
 */
package ucar.nc2;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import junit.framework.TestCase;
import ucar.nc2.FileWriter;
import ucar.nc2.NetcdfFile;
import ucar.nc2.TestAll;
import ucar.nc2.dataset.NetcdfDataset;
import ucar.nc2.util.CompareNetcdf;

public class TestCompareFileWriter
extends TestCase {
    public ArrayList files;

    public TestCompareFileWriter(String name) {
        super(name);
    }

    public void testCompare() throws IOException {
        this.doOne(TestAll.testdataDir + "satellite/gini/n0r_20041013_1852-compress", TestAll.temporaryLocalDataDir + "n0r_20041013_1852.nc");
    }

    public void utestCompareAll() throws IOException {
        this.readAllDir(TestAll.testdataDir + "satellite/gini/");
    }

    void readAllDir(String dirName) throws IOException {
        File f;
        int i;
        System.out.println("---------------Reading directory " + dirName);
        File allDir = new File(dirName);
        File[] allFiles = allDir.listFiles();
        for (i = 0; i < allFiles.length; ++i) {
            f = allFiles[i];
            if (f.isDirectory()) continue;
            String name = f.getAbsolutePath();
            this.doOne(name, "C:/temp/data/temp.nc");
        }
        for (i = 0; i < allFiles.length; ++i) {
            f = allFiles[i];
            if (!f.isDirectory()) continue;
            this.readAllDir(allFiles[i].getAbsolutePath());
        }
    }

    private void doOne(String datasetIn, String filenameOut) throws IOException {
        NetcdfFile ncfileIn = NetcdfDataset.openFile((String)datasetIn, null);
        NetcdfFile ncfileOut = FileWriter.writeToFile((NetcdfFile)ncfileIn, (String)filenameOut);
        CompareNetcdf.compareFiles((NetcdfFile)ncfileIn, (NetcdfFile)ncfileOut);
        ncfileIn.close();
        ncfileOut.close();
    }
}

